/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.transport.https;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.connection.transport.http.HTTPClientTransport;
import weblogic.wsee.connection.transport.https.JdkSSLAdapter;
import weblogic.wsee.connection.transport.https.SSLAdapter;
import weblogic.wsee.util.Verbose;

public class HTTPSClientTransport
extends HTTPClientTransport {
    private static final boolean verbose = Verbose.isVerbose(HTTPSClientTransport.class);
    public static final String USE_JDK_SSL_PROPERTY = "weblogic.wsee.client.ssl.usejdk";
    private static final boolean USE_JDK_SSL = Boolean.getBoolean("weblogic.wsee.client.ssl.usejdk");
    private static final String WLS_HTTPS_URL_CONNECTION = "weblogic.net.http.SOAPHttpsURLConnection";
    private SSLAdapter sslAdapter = null;

    public String getName() {
        return "https";
    }

    protected HttpURLConnection openConnection(URL uRL, Proxy proxy, TransportInfo transportInfo) throws IOException {
        if (verbose) {
            Verbose.log("Opening connection to " + uRL + (proxy == null ? "" : " using " + proxy));
        }
        return this.getSSLAdapter().openConnection(uRL, proxy, transportInfo);
    }

    public final void setSSLAdapter(SSLAdapter sSLAdapter) {
        if (sSLAdapter == null) {
            throw new IllegalArgumentException("SSLAdapter cannot be null");
        }
        this.sslAdapter = sSLAdapter;
    }

    private SSLAdapter getSSLAdapter() throws IOException {
        if (this.sslAdapter == null) {
            SSLAdapter sSLAdapter;
            try {
                sSLAdapter = (SSLAdapter)HTTPSClientTransport.getAdapterClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new IOException("Failed to instantiate SSL Adapter class: " + instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException("Could not access SSL Adapter class: " + illegalAccessException.getMessage());
            }
            this.sslAdapter = sSLAdapter;
        }
        return this.sslAdapter;
    }

    private static Class getAdapterClass() throws IOException {
        Class clazz;
        if (USE_JDK_SSL || !HTTPSClientTransport.wlsSSLPresent()) {
            clazz = JdkSSLAdapter.class;
        } else {
            try {
                clazz = Class.forName("weblogic.wsee.connection.transport.https.WlsSSLAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Failed to load SSLAdapter class: " + classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static boolean wlsSSLPresent() {
        URLConnection uRLConnection;
        Object object;
        try {
            object = new URL("https://127.0.0.1/");
            uRLConnection = ((URL)object).openConnection();
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        object = uRLConnection.getClass().getName();
        return WLS_HTTPS_URL_CONNECTION.equals(object);
    }
}

