/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.transport.https;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import weblogic.wsee.connection.transport.http.HttpTransportInfo;
import weblogic.wsee.connection.transport.https.SSLAdapter;
import weblogic.wsee.util.Verbose;

public class HttpsTransportInfo
extends HttpTransportInfo {
    private static final long serialVersionUID = 5277936336380367841L;
    public static final String STRICT_CHECKING_DEFAULT = "weblogic.wsee.client.ssl.stricthostchecking";
    public static final String RELAXED_CHECKING_DEFAULT = "weblogic.wsee.client.ssl.relaxedtrustmanager";
    private static boolean strictCheckingDefault;
    private static boolean relaxedTrustManagerDefault;
    private static final HostnameVerifier NONVERIFIER;
    private static final TrustManager[] RELAXED_MANAGERS;
    public static final HttpsTransportInfo DEFAULT_TRANSPORTINFO;
    private static final boolean verbose;
    private transient KeyManager[] keyManagers;
    private transient TrustManager[] trustManagers;
    private transient HostnameVerifier hostnameVerifier;
    private static final String KEYSTORE_PASSWORD_PROPERTY = "javax.net.ssl.keyStorePassword";
    private static final String KEYSTORE_PROPERTY = "javax.net.ssl.keyStore";
    private static final String TRUST_KEYSTORE_PROPERTY = "javax.net.ssl.trustStore";
    private transient SSLAdapter sslAdapter;

    public HttpsTransportInfo() {
        block5: {
            block4: {
                this.sslAdapter = null;
                HostnameVerifier hostnameVerifier = !strictCheckingDefault ? NONVERIFIER : null;
                this.hostnameVerifier = hostnameVerifier;
                try {
                    TrustManager[] trustManagerArray = relaxedTrustManagerDefault ? RELAXED_MANAGERS : HttpsTransportInfo.getDefaultTrustManagers();
                    this.trustManagers = trustManagerArray;
                }
                catch (Exception exception) {
                    if (!verbose) break block4;
                    exception.printStackTrace();
                }
            }
            try {
                this.keyManagers = HttpsTransportInfo.getDefaultKeyManagers();
            }
            catch (Exception exception) {
                if (!verbose) break block5;
                exception.printStackTrace();
            }
        }
    }

    public HttpsTransportInfo(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, HostnameVerifier hostnameVerifier) {
        this.sslAdapter = null;
        if (keyManagerArray == null) {
            throw new IllegalArgumentException("KeyManagers cannot be null");
        }
        if (trustManagerArray == null) {
            throw new IllegalArgumentException("TrustManagers cannot be null");
        }
        this.keyManagers = keyManagerArray;
        this.trustManagers = trustManagerArray;
        this.hostnameVerifier = hostnameVerifier;
    }

    public HttpsTransportInfo(SSLAdapter sSLAdapter) {
        this.sslAdapter = null;
        this.sslAdapter = sSLAdapter;
    }

    public void setSSLAdapter(SSLAdapter sSLAdapter) {
        this.sslAdapter = sSLAdapter;
    }

    public SSLAdapter getSSLAdapter() {
        return this.sslAdapter;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public void setKeyManagers(KeyManager[] keyManagerArray) {
        this.keyManagers = keyManagerArray;
    }

    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    public void setTrustManagers(TrustManager[] trustManagerArray) {
        this.trustManagers = trustManagerArray;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public static void setStrictHostnameCheckDefault(boolean bl) {
        strictCheckingDefault = bl;
        if (!bl) {
            DEFAULT_TRANSPORTINFO.setHostnameVerifier(NONVERIFIER);
        } else {
            HostnameVerifier hostnameVerifier = DEFAULT_TRANSPORTINFO.getHostnameVerifier();
            if (hostnameVerifier == NONVERIFIER) {
                DEFAULT_TRANSPORTINFO.setHostnameVerifier(null);
            }
        }
    }

    public static void setRelaxedTrustManagerDefault(boolean bl) {
        block5: {
            relaxedTrustManagerDefault = bl;
            if (bl) {
                DEFAULT_TRANSPORTINFO.setTrustManagers(RELAXED_MANAGERS);
            } else {
                TrustManager[] trustManagerArray = DEFAULT_TRANSPORTINFO.getTrustManagers();
                if (trustManagerArray == RELAXED_MANAGERS) {
                    try {
                        DEFAULT_TRANSPORTINFO.setTrustManagers(HttpsTransportInfo.getDefaultTrustManagers());
                    }
                    catch (Exception exception) {
                        if (!verbose) break block5;
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    private static KeyManager[] getDefaultKeyManagers() throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        String string = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string);
        KeyStore keyStore = HttpsTransportInfo.getKeyStoreFromSystemProperty(KEYSTORE_PROPERTY, KEYSTORE_PASSWORD_PROPERTY);
        String string2 = System.getProperty(KEYSTORE_PASSWORD_PROPERTY);
        keyManagerFactory.init(keyStore, string2 != null ? string2.toCharArray() : null);
        KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
        if (verbose) {
            Verbose.say("Loaded keymanagers from system properties");
        }
        return keyManagerArray;
    }

    private static TrustManager[] getDefaultTrustManagers() throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
        KeyStore keyStore = HttpsTransportInfo.getKeyStoreFromSystemProperty(TRUST_KEYSTORE_PROPERTY, null);
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (verbose) {
            Verbose.say("Loaded default trust managers");
        }
        return trustManagerArray;
    }

    /*
     * Loose catch block
     */
    private static KeyStore getKeyStoreFromSystemProperty(String string, String string2) {
        KeyStore keyStore;
        block9: {
            String string3 = System.getProperty(string);
            String string4 = string2 != null ? System.getProperty(string2) : null;
            if (string3 == null || string2 != null && string4 == null) {
                return null;
            }
            if (verbose) {
                Verbose.log("loading keystore from: " + string3);
            }
            FileInputStream fileInputStream = null;
            fileInputStream = new FileInputStream(string3);
            keyStore = KeyStore.getInstance("jks");
            keyStore.load(fileInputStream, string4 != null ? string4.toCharArray() : null);
            Object var8_6 = null;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block9;
            {
                catch (Exception exception) {
                    throw new IllegalStateException("Unable to load keystore", exception);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
        return keyStore;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.sslAdapter instanceof Serializable) {
            objectOutputStream.writeObject(this.sslAdapter);
        } else {
            Object var2_2 = null;
            objectOutputStream.writeObject(var2_2);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.sslAdapter = (SSLAdapter)objectInputStream.readObject();
    }

    static {
        block7: {
            strictCheckingDefault = false;
            relaxedTrustManagerDefault = false;
            NONVERIFIER = new RelaxedVerifier();
            RELAXED_MANAGERS = new TrustManager[]{new RelaxedX509TrustManager()};
            DEFAULT_TRANSPORTINFO = new HttpsTransportInfo();
            verbose = Verbose.isVerbose(HttpsTransportInfo.class);
            try {
                if (verbose) {
                    Verbose.log("HttpsTransportInfo verbose output enabled");
                }
                if ("true".equals(System.getProperty(STRICT_CHECKING_DEFAULT))) {
                    strictCheckingDefault = true;
                    if (verbose) {
                        Verbose.log("JdkSSLAdapter strict hostname checking ENABLED by default");
                    }
                }
                if ("true".equals(System.getProperty(RELAXED_CHECKING_DEFAULT))) {
                    relaxedTrustManagerDefault = true;
                    if (verbose) {
                        Verbose.log("JdkSSLAdapter relaxed trust manager ENABLED by default");
                    }
                }
            }
            catch (Throwable throwable) {
                if (!verbose) break block7;
                Verbose.log("JdkSSLAdapter error: " + throwable.getMessage());
                Verbose.logException(throwable);
            }
        }
    }

    private static class RelaxedX509TrustManager
    implements X509TrustManager {
        private RelaxedX509TrustManager() {
        }

        public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
            return true;
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        }
    }

    private static class RelaxedVerifier
    implements HostnameVerifier {
        private RelaxedVerifier() {
        }

        public boolean verify(String string, SSLSession sSLSession) {
            if (verbose) {
                Verbose.log("HTTPSClientTransport RelaxedVerifier called.");
            }
            if (!string.equals(sSLSession.getPeerHost())) {
                if (verbose) {
                    Verbose.log("HTTPSClientTransport NullVerifyer certificate <" + sSLSession.getPeerHost() + "> does not match host <" + string + "> however continuing anyway.");
                }
            } else if (verbose) {
                Verbose.log("HTTPSClientTransport success URL: " + string);
            }
            return true;
        }
    }
}

