/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.transport.https;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.connection.transport.https.HttpsTransportInfo;
import weblogic.wsee.connection.transport.https.SSLAdapter;
import weblogic.wsee.util.Verbose;

public class JdkSSLAdapter
implements SSLAdapter {
    private static boolean verbose = Verbose.isVerbose(JdkSSLAdapter.class);
    private static final String SUN_JDK_PROTOCOL_HANDLER = "sun.net.www.protocol.https.Handler";
    private static final String IBM_JDK_PROTOCOL_HANDLER = "com.ibm.net.ssl.www2.protocol.https.Handler";
    private static Class PROTOCOL_HANDLER_CLASS = JdkSSLAdapter.getProtocolHandlerClass();

    public HttpsURLConnection openConnection(URL uRL, Proxy proxy, TransportInfo transportInfo) throws IOException {
        HttpsTransportInfo httpsTransportInfo;
        HttpsTransportInfo httpsTransportInfo2 = httpsTransportInfo = transportInfo == null || !(transportInfo instanceof HttpsTransportInfo) ? HttpsTransportInfo.DEFAULT_TRANSPORTINFO : (HttpsTransportInfo)transportInfo;
        if (verbose) {
            Verbose.log("JdkSSLAdapter: opening connection to " + uRL + (proxy != null ? " via " + proxy : ""));
        }
        uRL = this.prepareURL(uRL);
        HttpsURLConnection httpsURLConnection = proxy != null ? (HttpsURLConnection)uRL.openConnection(proxy) : (HttpsURLConnection)uRL.openConnection();
        if (verbose) {
            Verbose.say("JdkSSLAdapter.openConnection() got " + httpsURLConnection.getClass().getName());
        }
        this.prepareConnection(httpsURLConnection, httpsTransportInfo);
        return httpsURLConnection;
    }

    public void setClientCert(String string, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        throw new UnsupportedOperationException("Not Implemented for JDKSSLAdapter");
    }

    public void setKeystore(String string, char[] cArray, String string2) {
        throw new UnsupportedOperationException("Not Implemented for JDKSSLAdapter");
    }

    private URL prepareURL(URL uRL) throws MalformedURLException, IOException {
        return new URL(uRL, uRL.toString(), this.getProtocolHandler());
    }

    private URLStreamHandler getProtocolHandler() throws IOException {
        try {
            if (PROTOCOL_HANDLER_CLASS != null) {
                return (URLStreamHandler)PROTOCOL_HANDLER_CLASS.newInstance();
            }
        }
        catch (Exception exception) {
            throw new IOException("Unable to instantiate URLStreamHandler class", exception);
        }
        throw new IOException("Unable to instantiate URLStreamHandler: class not found");
    }

    private static Class getProtocolHandlerClass() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(SUN_JDK_PROTOCOL_HANDLER);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName(IBM_JDK_PROTOCOL_HANDLER);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                clazz = null;
            }
        }
        return clazz;
    }

    private void prepareConnection(HttpsURLConnection httpsURLConnection, HttpsTransportInfo httpsTransportInfo) throws IOException {
        HostnameVerifier hostnameVerifier = httpsTransportInfo.getHostnameVerifier();
        if (hostnameVerifier != null) {
            httpsURLConnection.setHostnameVerifier(hostnameVerifier);
        }
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(httpsTransportInfo.getKeyManagers(), httpsTransportInfo.getTrustManagers(), new SecureRandom());
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            httpsURLConnection.setSSLSocketFactory(sSLSocketFactory);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IOException(generalSecurityException.getMessage());
        }
    }
}

