/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.transport.https;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class SSLAdapterUtils {
    public static final String PEM_PREAMBLE_STRING = "-----BEGIN ";
    public static final byte[] PEM_PREAMBLE_BYTES = "-----BEGIN ".getBytes();
    private static final String JKS_KEYSTORE_TYPE = "JKS";

    public static byte[] getFileBytes(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n = 0;
        try {
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            while (n >= 0) {
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    public static boolean containsPEMdata(byte[] byArray) {
        boolean bl = true;
        int n = 0;
        do {
            boolean bl2 = bl = PEM_PREAMBLE_BYTES[n] == byArray[n];
        } while (++n < PEM_PREAMBLE_BYTES.length && bl);
        return bl;
    }

    public static KeyStore openKeyStore(InputStream inputStream) throws KeyManagementException {
        try {
            KeyStore keyStore = KeyStore.getInstance(JKS_KEYSTORE_TYPE);
            keyStore.load(inputStream, null);
            return keyStore;
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyManagementException(keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagementException(noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new KeyManagementException(iOException);
        }
        catch (CertificateException certificateException) {
            throw new KeyManagementException(certificateException);
        }
    }
}

