/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.transport.https;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.util.Properties;
import weblogic.net.http.HttpsURLConnection;
import weblogic.security.SSL.TrustManager;
import weblogic.security.utils.KeyStoreUtils;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.connection.transport.https.SSLAdapter;
import weblogic.wsee.server.EncryptionUtil;
import weblogic.wsee.util.Verbose;

public class WlsSSLAdapter
implements SSLAdapter,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean verbose = Verbose.isVerbose(WlsSSLAdapter.class);
    private String _keystore;
    private char[] _keystorePassword;
    private String _keystoreType;
    private String _keyAlias;
    private char[] _keyPassword;
    private transient KeyStore clientKeyStore = null;
    private transient PrivateKey key = null;
    private transient Certificate[] certs = null;
    private transient TrustManager tm = null;

    public WlsSSLAdapter() {
        Properties properties = System.getProperties();
        String string = properties.getProperty("java.protocol.handler.pkgs");
        if (string == null) {
            string = "weblogic.net";
        } else if (string.indexOf("weblogic.net") == -1) {
            string = string + "|weblogic.net";
        }
        properties.put("java.protocol.handler.pkgs", string);
        System.setProperties(properties);
    }

    public HttpURLConnection openConnection(URL uRL, Proxy proxy, TransportInfo transportInfo) throws IOException {
        HttpsURLConnection httpsURLConnection;
        if (verbose) {
            Verbose.log("openConnection(" + uRL + (proxy != null ? ", " + proxy : "") + ")");
        }
        try {
            URLConnection uRLConnection = null;
            uRLConnection = proxy == null ? uRL.openConnection() : uRL.openConnection(proxy);
            if (!(uRLConnection instanceof HttpsURLConnection)) {
                String string = "----  openConnection returned class='" + uRLConnection.getClass().getName() + "'." + "  We were expecting an HTTPS connection object: weblogic.net.http.HttpsURLConnection" + "\nCheck that your SSL environment is setup correctly.";
                throw new IOException(string);
            }
            httpsURLConnection = (HttpsURLConnection)uRLConnection;
            if (this.certs != null && this.key != null) {
                httpsURLConnection.loadLocalIdentity(this.certs, this.key);
            }
            if (this.tm != null) {
                httpsURLConnection.setTrustManager(this.tm);
            }
        }
        catch (IOException iOException) {
            if (verbose) {
                iOException.printStackTrace();
            }
            throw iOException;
        }
        return httpsURLConnection;
    }

    public void setClientCert(String string, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        this._keyAlias = string;
        this._keyPassword = cArray;
        this.initClientCert();
    }

    private void initClientCert() throws NoSuchAlgorithmException, UnrecoverableEntryException, KeyStoreException {
        if (this.clientKeyStore != null) {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.clientKeyStore.getEntry(this._keyAlias, new KeyStore.PasswordProtection(this._keyPassword));
            if (privateKeyEntry != null) {
                this.key = privateKeyEntry.getPrivateKey();
            }
            this.certs = this.clientKeyStore.getCertificateChain(this._keyAlias);
        }
    }

    public void setKeystore(String string, char[] cArray, String string2) {
        this._keystore = string;
        this._keystorePassword = cArray;
        this._keystoreType = string2;
        this.initClientKeyStore();
    }

    private void initClientKeyStore() {
        this.clientKeyStore = KeyStoreUtils.load(KeyStoreUtils.getFile(this._keystore), this._keystorePassword, this._keystoreType);
    }

    public void setTrustManager(TrustManager trustManager) {
        this.tm = trustManager;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this._keystore);
        this.writeEncryptedField(this._keystorePassword, objectOutputStream);
        objectOutputStream.writeObject(this._keystoreType);
        objectOutputStream.writeObject(this._keyAlias);
        this.writeEncryptedField(this._keyPassword, objectOutputStream);
    }

    private void writeEncryptedField(Object object, ObjectOutputStream objectOutputStream) throws IOException {
        if (object == null) {
            objectOutputStream.writeInt(-1);
            objectOutputStream.writeObject(object);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream2.writeObject(object);
            objectOutputStream2.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byArray = EncryptionUtil.encrypt(byArray);
            objectOutputStream.writeInt(byArray.length);
            objectOutputStream.write(byArray);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this._keystore = (String)objectInputStream.readObject();
        this._keystorePassword = (char[])this.readEncryptedField(objectInputStream);
        this._keystoreType = (String)objectInputStream.readObject();
        this._keyAlias = (String)objectInputStream.readObject();
        this._keyPassword = (char[])this.readEncryptedField(objectInputStream);
        this.initialize();
    }

    private Object readEncryptedField(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        if (n <= 0) {
            return objectInputStream.readObject();
        }
        byte[] byArray = new byte[n];
        objectInputStream.readFully(byArray);
        byArray = EncryptionUtil.decrypt(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream2 = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream2.readObject();
    }

    private void initialize() {
        if (this._keystore != null) {
            this.initClientKeyStore();
        }
        if (this._keyAlias != null) {
            try {
                this.initClientCert();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    static {
        if (verbose) {
            Verbose.log("WlsSSLAdapter: verbose output enabled");
        }
    }
}

