/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.transport.jms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.util.Hashtable;
import javax.jms.BytesMessage;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.jms.common.LostServerException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.encoders.BASE64Encoder;
import weblogic.wsee.connection.transport.TransportUtil;
import weblogic.wsee.connection.transport.jms.JmsQueueConnectionPool;
import weblogic.wsee.connection.transport.jms.JmsQueueConnectionPoolInternal;
import weblogic.wsee.connection.transport.jms.JmsTransportInfo;
import weblogic.wsee.util.Verbose;

public class JmsQueueConnection {
    private QueueConnectionFactory factory;
    private QueueConnection connection;
    private QueueSession session;
    private QueueSender sender;
    private TemporaryQueue responseQueue;
    private QueueReceiver receiver;
    private boolean alive = true;
    private static final boolean verbose = Verbose.isVerbose(JmsQueueConnection.class);
    private JmsQueueConnectionPoolInternal pool;
    private String subjectString;
    public static final String JNDI_FACTORY = "weblogic.jndi.WLInitialContextFactory";

    public JmsQueueConnection(JmsTransportInfo jmsTransportInfo) throws NamingException, IOException, JMSException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", JNDI_FACTORY);
        if (jmsTransportInfo.getJndiURL() != null) {
            if (verbose) {
                Verbose.say("Setting Provider URL to Jms JNDI url " + jmsTransportInfo.getJndiURL());
            }
            hashtable.put("java.naming.provider.url", jmsTransportInfo.getJndiURL());
        } else {
            if (verbose) {
                Verbose.say("Setting Provider URL to default url t3://" + jmsTransportInfo.getHost() + ":" + jmsTransportInfo.getPort());
            }
            hashtable.put("java.naming.provider.url", "t3://" + jmsTransportInfo.getHost() + ":" + jmsTransportInfo.getPort());
        }
        String string = jmsTransportInfo.getUsername();
        String string2 = jmsTransportInfo.getPassword();
        if (verbose) {
            Verbose.say("Got username from the transportinfo: " + string);
        }
        if (string != null) {
            if (verbose) {
                Verbose.say("Setting username to " + string);
            }
            hashtable.put("java.naming.security.principal", string);
            hashtable.put("java.naming.security.credentials", string2);
        }
        InitialContext initialContext = new InitialContext(hashtable);
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        bl = TransportUtil.getForeignCredentials(jmsTransportInfo.getFactory(), initialContext, stringBuffer, stringBuffer2);
        this.factory = (QueueConnectionFactory)initialContext.lookup(jmsTransportInfo.getFactory());
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)((AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())));
        if (authenticatedSubject != null && string != null) {
            this.subjectString = this.getSubjectString(authenticatedSubject);
        }
        if (verbose) {
            Verbose.say("Subject = " + authenticatedSubject);
        }
        this.connection = bl ? this.factory.createQueueConnection(stringBuffer.toString(), stringBuffer2.toString()) : (string != null ? this.factory.createQueueConnection(string, string2) : this.factory.createQueueConnection());
        this.session = this.connection.createQueueSession(false, 1);
        Queue queue = (Queue)initialContext.lookup(jmsTransportInfo.getQueue());
        this.sender = this.session.createSender(queue);
        if (!jmsTransportInfo.isSendTo81()) {
            this.responseQueue = this.session.createTemporaryQueue();
            this.receiver = this.session.createReceiver((Queue)this.responseQueue);
        }
        this.connection.start();
        this.connection.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException jMSException) {
                if (jMSException instanceof LostServerException) {
                    JmsQueueConnection.this.alive = false;
                    if (verbose) {
                        Verbose.say("A LostServerException found. ");
                    }
                }
            }
        });
        this.alive = true;
    }

    QueueReceiver getReceiver() {
        return this.receiver;
    }

    Queue getResponseQueue() {
        return this.responseQueue;
    }

    public QueueSender getSender() {
        return this.sender;
    }

    private String getSubjectString(AuthenticatedSubject authenticatedSubject) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(authenticatedSubject);
        objectOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return new BASE64Encoder().encodeBuffer(byArray);
    }

    public Message getTextMessage() throws JMSException {
        TextMessage textMessage = this.session.createTextMessage();
        if (this.subjectString != null) {
            textMessage.setStringProperty("WSEE_JMS_SUBJECT", this.subjectString);
        }
        return textMessage;
    }

    public Message getBytesMessage() throws JMSException {
        BytesMessage bytesMessage = this.session.createBytesMessage();
        if (this.subjectString != null) {
            bytesMessage.setStringProperty("WSEE_JMS_SUBJECT", this.subjectString);
        }
        return bytesMessage;
    }

    void setPool(JmsQueueConnectionPoolInternal jmsQueueConnectionPoolInternal) {
        this.pool = jmsQueueConnectionPoolInternal;
    }

    void release() {
        if (verbose) {
            Verbose.say("releasing a connection");
        }
        JmsQueueConnectionPool.getInstance().release(this.pool, this);
    }

    public void close() throws JMSException {
        this.sender.close();
        this.session.close();
        this.connection.close();
        if (this.receiver != null) {
            this.receiver.close();
        }
        if (this.responseQueue != null) {
            this.responseQueue.delete();
        }
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void closeIgoreException() {
        try {
            this.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }
}

