/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.transport.jms;

import java.io.IOException;
import java.util.HashMap;
import java.util.TimerTask;
import javax.jms.JMSException;
import javax.naming.NamingException;
import weblogic.wsee.connection.transport.jms.JmsQueueConnection;
import weblogic.wsee.connection.transport.jms.JmsQueueConnectionPoolInternal;
import weblogic.wsee.connection.transport.jms.JmsTransportInfo;
import weblogic.wsee.util.Verbose;

public class JmsQueueConnectionPool
extends TimerTask {
    private static final boolean verbose = Verbose.isVerbose(JmsQueueConnectionPool.class);
    private static final int POOL_CAPACITY = 32;
    private static JmsQueueConnectionPool instance = new JmsQueueConnectionPool();
    private HashMap connections = new HashMap();
    private int numOfWaitings;

    private JmsQueueConnectionPool() {
    }

    public static JmsQueueConnectionPool getInstance() {
        return instance;
    }

    public synchronized void close() {
        for (JmsQueueConnectionPoolInternal jmsQueueConnectionPoolInternal : this.connections.values()) {
            jmsQueueConnectionPoolInternal.clear();
        }
        this.connections.clear();
    }

    JmsQueueConnection getNewConnection(JmsTransportInfo jmsTransportInfo, JmsQueueConnectionPoolInternal jmsQueueConnectionPoolInternal) throws NamingException, IOException, JMSException {
        JmsQueueConnection jmsQueueConnection = new JmsQueueConnection(jmsTransportInfo);
        jmsQueueConnection.setPool(jmsQueueConnectionPoolInternal);
        jmsQueueConnectionPoolInternal.increaseCount();
        return jmsQueueConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized JmsQueueConnection getConnection(JmsTransportInfo jmsTransportInfo) throws NamingException, IOException, JMSException {
        JmsQueueConnection jmsQueueConnection;
        JmsQueueConnectionPoolInternal jmsQueueConnectionPoolInternal = (JmsQueueConnectionPoolInternal)this.connections.get(jmsTransportInfo);
        if (jmsQueueConnectionPoolInternal == null) {
            jmsQueueConnectionPoolInternal = new JmsQueueConnectionPoolInternal(32);
            this.connections.put(jmsTransportInfo, jmsQueueConnectionPoolInternal);
        }
        if ((jmsQueueConnection = jmsQueueConnectionPoolInternal.remove()) == null) {
            if (jmsQueueConnectionPoolInternal.connectionsCount() < 32) {
                jmsQueueConnection = this.getNewConnection(jmsTransportInfo, jmsQueueConnectionPoolInternal);
            } else {
                while (jmsQueueConnectionPoolInternal.size() == 0 && jmsQueueConnectionPoolInternal.connectionsCount() >= 32 && jmsQueueConnectionPoolInternal.isAlive()) {
                    Object var6_5;
                    ++this.numOfWaitings;
                    try {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            var6_5 = null;
                            --this.numOfWaitings;
                            continue;
                        }
                        var6_5 = null;
                        --this.numOfWaitings;
                    }
                    catch (Throwable throwable) {
                        var6_5 = null;
                        --this.numOfWaitings;
                        throw throwable;
                    }
                }
                jmsQueueConnection = !jmsQueueConnectionPoolInternal.isAlive() ? this.getConnection(jmsTransportInfo) : (jmsQueueConnectionPoolInternal.connectionsCount() < 32 ? this.getNewConnection(jmsTransportInfo, jmsQueueConnectionPoolInternal) : jmsQueueConnectionPoolInternal.remove());
            }
        }
        return jmsQueueConnection;
    }

    synchronized void release(JmsQueueConnectionPoolInternal jmsQueueConnectionPoolInternal, JmsQueueConnection jmsQueueConnection) {
        if (jmsQueueConnection == null) {
            return;
        }
        if (!jmsQueueConnection.isAlive()) {
            jmsQueueConnection.closeIgoreException();
            if (jmsQueueConnectionPoolInternal.isAlive()) {
                jmsQueueConnectionPoolInternal.decreaseCount();
                this.notifyAll();
            }
        } else if (!jmsQueueConnectionPoolInternal.isAlive()) {
            jmsQueueConnection.closeIgoreException();
            this.notifyAll();
        } else if (jmsQueueConnectionPoolInternal.add(jmsQueueConnection) && this.numOfWaitings > 0) {
            this.notifyAll();
        }
    }

    public void run() {
    }
}

