/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.transport.jms;

import weblogic.utils.collections.StackPool;
import weblogic.wsee.connection.transport.jms.JmsQueueConnection;

public class JmsQueueConnectionPoolInternal {
    private static final long POOL_REFRESH_TIME = 180000L;
    private StackPool pool = null;
    private int connectionsCount = 0;
    private boolean alive = true;
    private long lastRefreshTime = 0L;

    public JmsQueueConnectionPoolInternal(int n) {
        this.pool = new StackPool(n);
        this.connectionsCount = 0;
        this.alive = true;
        this.lastRefreshTime = System.currentTimeMillis();
    }

    public JmsQueueConnection remove() {
        if (this.pool == null) {
            return null;
        }
        return (JmsQueueConnection)this.pool.remove();
    }

    public boolean add(JmsQueueConnection jmsQueueConnection) {
        if (this.pool == null) {
            return false;
        }
        return this.pool.add((Object)jmsQueueConnection);
    }

    public int size() {
        if (this.pool == null) {
            return 0;
        }
        return this.pool.size();
    }

    public int connectionsCount() {
        return this.connectionsCount;
    }

    public void increaseCount() {
        ++this.connectionsCount;
    }

    public void decreaseCount() {
        --this.connectionsCount;
    }

    public boolean needRefresh() {
        if (!this.alive) {
            return true;
        }
        if (System.currentTimeMillis() - this.lastRefreshTime > 180000L) {
            this.alive = false;
        }
        return !this.alive;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void clear() {
        JmsQueueConnection jmsQueueConnection;
        if (this.pool == null) {
            return;
        }
        while ((jmsQueueConnection = (JmsQueueConnection)this.pool.remove()) != null) {
            jmsQueueConnection.closeIgoreException();
        }
    }
}

