/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import weblogic.wsee.connection.ConnectionException;
import weblogic.wsee.connection.transport.ServerTransport;
import weblogic.wsee.util.Verbose;

public class JmsServerQueueTransport
implements ServerTransport {
    private static final boolean verbose = Verbose.isVerbose(JmsServerQueueTransport.class);
    private static final String mimeHdrPrefix = "_wls_mimehdr";
    private Message message;
    private QueueConnectionFactory factory;
    private QueueConnection connection;
    private QueueSession session;
    private JmsMessageData messageData;
    private QueueSender sender;
    private String wsUrl;
    private boolean isWLW81Message;
    private boolean isNullReplyto;
    private String userName;
    private String passwd;

    public JmsServerQueueTransport(String string, Message message, QueueConnectionFactory queueConnectionFactory, String string2, String string3) {
        this.message = message;
        this.factory = queueConnectionFactory;
        this.wsUrl = string;
        this.userName = string2;
        this.passwd = string3;
        try {
            this.isWLW81Message = message.getBooleanProperty("IsWLW81Message");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public boolean isUserInRole(String string) {
        throw new Error("NYI");
    }

    public Principal getUserPrincipal() {
        throw new Error("NYI");
    }

    public boolean isReliable() {
        return true;
    }

    public String getName() {
        return "JMSServerTransport";
    }

    public String getServiceURI() {
        return this.wsUrl;
    }

    public String getEndpointAddress() {
        return this.wsUrl;
    }

    public boolean isBytesMessage() {
        return this.message instanceof BytesMessage;
    }

    public OutputStream send(MimeHeaders mimeHeaders) throws IOException {
        try {
            Queue queue = (Queue)this.message.getJMSReplyTo();
            if (queue == null) {
                if (this.isWLW81Message) {
                    this.isNullReplyto = true;
                    return new JmsMessageData();
                }
                throw new IOException("Failed to find queue");
            }
            this.connection = this.userName != null ? this.factory.createQueueConnection(this.userName, this.passwd) : this.factory.createQueueConnection();
            this.session = this.connection.createQueueSession(false, 1);
            String string = this.message.getJMSCorrelationID();
            if (string == null) {
                string = this.message.getJMSMessageID();
            }
            if (this.message instanceof TextMessage) {
                this.message = this.session.createTextMessage();
            }
            if (this.message instanceof BytesMessage) {
                this.message = this.session.createBytesMessage();
            }
            this.message.setJMSCorrelationID(string);
            Iterator iterator = mimeHeaders.getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                String string2 = mimeHeader.getName().replaceAll("-", "_");
                if (verbose) {
                    Verbose.say("write mime header " + string2 + ": " + mimeHeader.getValue());
                }
                this.message.setStringProperty(mimeHdrPrefix + string2, mimeHeader.getValue());
            }
            this.sender = this.session.createSender(queue);
            this.messageData = new JmsMessageData();
        }
        catch (JMSException jMSException) {
            throw new IOException("Failed to send message:" + (Object)((Object)jMSException));
        }
        return this.messageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeSend() throws JMSException {
        block16: {
            if (this.isWLW81Message && this.isNullReplyto) {
                if (verbose) {
                    Verbose.log("Request is sent by a WLW 8.1 client, we don't send response back");
                }
                return;
            }
            try {
                byte[] byArray = this.messageData.toByteArray();
                if (verbose) {
                    System.out.println("\n ***SENDING FOLLOWING MESSAGE AT SERVER SIDE *** \n");
                    System.out.print(new String(byArray));
                    System.out.println("\n **** END SENDING MESSAGE ***");
                }
                if (this.message instanceof TextMessage) {
                    try {
                        ((TextMessage)this.message).setText(new String(byArray, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                } else if (this.message instanceof BytesMessage) {
                    ((BytesMessage)this.message).writeBytes(byArray);
                }
                this.sender.send(this.message);
                Object var4_3 = null;
                if (this.sender == null) break block16;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (this.sender != null) {
                    this.sender.close();
                }
                if (this.session != null) {
                    this.session.close();
                }
                if (this.connection != null) {
                    this.connection.close();
                }
                throw throwable;
            }
            this.sender.close();
        }
        if (this.session != null) {
            this.session.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
        if (verbose) {
            Verbose.log("Message send ok for service " + this.wsUrl);
        }
    }

    public OutputStream sendGeneralFault(MimeHeaders mimeHeaders) throws IOException {
        return this.send(mimeHeaders);
    }

    public OutputStream sendAuthorizationFault(MimeHeaders mimeHeaders) throws IOException {
        return this.send(mimeHeaders);
    }

    public OutputStream sendAuthorizationRequiredFault(MimeHeaders mimeHeaders) throws IOException {
        return this.send(mimeHeaders);
    }

    private void readMimeHeaders(Message message, MimeHeaders mimeHeaders) throws JMSException {
        Enumeration enumeration = message.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (verbose) {
                Verbose.log("read mime header - jms key " + string);
            }
            if (!string.startsWith(mimeHdrPrefix)) continue;
            String string2 = string.substring(mimeHdrPrefix.length()).replaceAll("_", "-");
            String string3 = message.getStringProperty(string);
            if (string3 == null || string3.length() == 0) continue;
            if (verbose) {
                Verbose.log("set mime header " + string2 + ":" + string3);
            }
            mimeHeaders.addHeader(string2, string3);
        }
    }

    public InputStream receive(MimeHeaders mimeHeaders) throws IOException {
        try {
            this.readMimeHeaders(this.message, mimeHeaders);
            if (this.message instanceof TextMessage) {
                String string = ((TextMessage)this.message).getText();
                if (verbose) {
                    System.out.println("\n ***RECEIVED FOLLOWING MESSAGE AT SERVER SIDE *****\n");
                    System.out.print(string);
                    System.out.println("\n ***END RECEIVING MESSAGE ***\n");
                }
                ByteArrayInputStream byteArrayInputStream = null;
                try {
                    byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                return byteArrayInputStream;
            }
            if (this.message instanceof BytesMessage) {
                byte[] byArray = new byte[(int)((BytesMessage)this.message).getBodyLength()];
                ((BytesMessage)this.message).readBytes(byArray);
                if (verbose) {
                    System.out.println("\n ***RECEIVED FOLLOWING MESSAGE AT SERVER SIDE *****\n");
                    System.out.print(new String(byArray));
                    System.out.println("\n ***END RECEIVING MESSAGE ***\n");
                }
                return new ByteArrayInputStream(byArray);
            }
            throw new IOException("Unsupported JMS message type '" + this.message.getClass() + "'");
        }
        catch (JMSException jMSException) {
            IOException iOException = new IOException("Failed to get text");
            iOException.initCause(jMSException);
            throw iOException;
        }
    }

    public void confirmOneway() throws IOException {
    }

    class JmsMessageData
    extends ByteArrayOutputStream {
        JmsMessageData() {
        }

        public void close() throws IOException {
            if (verbose) {
                Verbose.log("here");
            }
            super.close();
            try {
                JmsServerQueueTransport.this.completeSend();
            }
            catch (JMSException jMSException) {
                throw new ConnectionException("Failed to send jms message", jMSException);
            }
        }
    }
}

