/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Iterator;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.TextMessage;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import weblogic.transaction.TxHelper;
import weblogic.wsee.connection.ConnectionException;
import weblogic.wsee.connection.ResponseListener;
import weblogic.wsee.connection.transport.ClientTransport;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.connection.transport.jms.JmsQueueConnection;
import weblogic.wsee.connection.transport.jms.JmsQueueConnectionPool;
import weblogic.wsee.connection.transport.jms.JmsTransportInfo;
import weblogic.wsee.util.Verbose;

public class JmsTransport
implements ClientTransport {
    private static final boolean verbose = Verbose.isVerbose(JmsTransport.class);
    private static final String mimeHdrPrefix = "_wls_mimehdr";
    private JmsQueueConnection connection;
    private JmsTransportInfo info;
    private String uri;
    private Message message;
    private JmsMessageData messageData;
    private int readTimeout = -1;

    public void connect(String string, TransportInfo transportInfo) throws IOException {
        if (verbose) {
            Verbose.log("destination: " + string);
        }
        if (verbose) {
            Verbose.log("transport info: " + transportInfo);
        }
        this.uri = string;
        if (transportInfo instanceof JmsTransportInfo) {
            this.info = (JmsTransportInfo)transportInfo;
        } else {
            this.createTransportInfo();
        }
    }

    private void createTransportInfo() throws ConnectionException {
        try {
            this.info = new JmsTransportInfo(this.uri);
            Transaction transaction = TxHelper.getTransactionManager().getTransaction();
            if (transaction != null) {
                this.info.setTransactional(true);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ConnectionException("Failed to create JMS transport info", uRISyntaxException);
        }
        catch (SystemException systemException) {
            throw new ConnectionException("Failed to create JMS transport info", systemException);
        }
    }

    public void setResponseListener(ResponseListener responseListener) {
        throw new Error("NIY");
    }

    public boolean isBlocking() {
        return true;
    }

    public void setConnectionTimeout(int n) {
        throw new Error("NIY");
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public String getName() {
        return "JMSTransport";
    }

    public String getServiceURI() {
        return this.uri;
    }

    public String getEndpointAddress() {
        return this.uri;
    }

    public OutputStream send(MimeHeaders mimeHeaders) throws IOException {
        this.connection = null;
        try {
            MimeHeader mimeHeader;
            String string = null;
            Iterator iterator = mimeHeaders.getAllHeaders();
            while (iterator.hasNext()) {
                mimeHeader = (MimeHeader)iterator.next();
                if (mimeHeader.getName().equals("weblogic.wsee.transport.jms.url")) {
                    if (verbose) {
                        Verbose.say("DEBUG---- Setting Provider URL in JmsTransportInfo to " + mimeHeader.getValue());
                    }
                    this.info.setJndiURL(mimeHeader.getValue());
                }
                if (mimeHeader.getName().equals("javax.xml.rpc.security.auth.username")) {
                    if (verbose) {
                        Verbose.say("DEBUG---- Setting username/password in JmsTransportInfo to " + mimeHeader.getValue());
                    }
                    this.info.setUsername(mimeHeader.getValue());
                }
                if (mimeHeader.getName().equals("javax.xml.rpc.security.auth.password")) {
                    this.info.setPassword(mimeHeader.getValue());
                }
                if (!mimeHeader.getName().equals("weblogic.wsee.transport.jms.messagetype")) continue;
                if (verbose) {
                    Verbose.say("DEBUG---- MessageType = " + mimeHeader.getValue());
                }
                string = mimeHeader.getValue();
            }
            this.connection = JmsQueueConnectionPool.getInstance().getConnection(this.info);
            if (string == null || string.equals("TextMessage")) {
                this.message = this.connection.getTextMessage();
            } else if (string.equals("BytesMessage")) {
                this.message = this.connection.getBytesMessage();
            } else {
                throw new ConnectionException("Unsupported JMS message type " + string);
            }
            if (verbose) {
                Verbose.log("URI : " + this.info.getServiceUri());
            }
            if (verbose) {
                Verbose.log("Message : " + this.message);
            }
            iterator = mimeHeaders.getAllHeaders();
            while (iterator.hasNext()) {
                mimeHeader = (MimeHeader)iterator.next();
                String string2 = mimeHeader.getName().replaceAll("-", "_");
                if (string2.equals("weblogic.wsee.transport.jms.url") || string2.equals("javax.xml.rpc.security.auth.username") || string2.equals("javax.xml.rpc.security.auth.password") || string2.equals("weblogic.wsee.transport.jms.messagetype")) continue;
                if (verbose) {
                    Verbose.say("write mime header " + string2 + ": " + mimeHeader.getValue());
                }
                this.message.setStringProperty(mimeHdrPrefix + string2, mimeHeader.getValue());
            }
            this.message.setStringProperty("URI", this.info.getServiceUri());
            this.message.setJMSReplyTo((Destination)this.connection.getResponseQueue());
            this.messageData = new JmsMessageData();
            return this.messageData;
        }
        catch (Throwable throwable) {
            if (this.connection != null) {
                this.connection.release();
            }
            if (throwable instanceof NamingException) {
                throw new ConnectionException("Failed to lookup jms connection", throwable);
            }
            if (throwable instanceof JMSException) {
                throw new ConnectionException("JMS connection send faile", throwable);
            }
            throw new IOException("Failed to send jms message", throwable);
        }
    }

    private void completeSend() throws JMSException {
        byte[] byArray = this.messageData.toByteArray();
        if (verbose) {
            System.out.println("\n *** SENDING FOLLOWING MESSAGE AT CALLING SIDE *** \n");
            System.out.print(new String(byArray));
            System.out.println("\n *** END SENDING MESSAGE AT CALLING SIDE *** \n");
        }
        if (this.message instanceof TextMessage) {
            try {
                ((TextMessage)this.message).setText(new String(byArray, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            ((BytesMessage)this.message).writeBytes(byArray);
        }
        QueueSender queueSender = this.connection.getSender();
        queueSender.send(this.message);
        if (verbose) {
            Verbose.log("Message send ok for servcie " + this.uri);
        }
    }

    public OutputStream sendFault(MimeHeaders mimeHeaders) throws IOException {
        return this.send(mimeHeaders);
    }

    private void readMimeHeaders(Message message, MimeHeaders mimeHeaders) throws JMSException {
        Enumeration enumeration = message.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (verbose) {
                Verbose.log("read mime header - jms key " + string);
            }
            if (!string.startsWith(mimeHdrPrefix)) continue;
            String string2 = string.substring(mimeHdrPrefix.length()).replaceAll("_", "-");
            String string3 = message.getStringProperty(string);
            if (string3 == null || string3.length() == 0) continue;
            if (verbose) {
                Verbose.log("set mime header " + string2 + ":" + string3);
            }
            mimeHeaders.addHeader(string2, string3);
        }
    }

    public InputStream receive(MimeHeaders mimeHeaders) throws IOException {
        QueueReceiver queueReceiver;
        if (verbose) {
            Verbose.log("Receive response from temp queue");
        }
        if ((queueReceiver = this.connection.getReceiver()) == null) {
            throw new IOException("No receiver found");
        }
        Message message = null;
        try {
            message = this.readTimeout != -1 ? queueReceiver.receive((long)this.readTimeout) : queueReceiver.receive();
            if (message == null) {
                throw new IOException("Request timed out");
            }
            this.readMimeHeaders(message, mimeHeaders);
            if (message instanceof TextMessage) {
                String string = ((TextMessage)message).getText();
                if (verbose) {
                    System.out.println("\n *** RECEIVED FOLLOWING MESSAGE AT CALLING SIDE *** \n");
                    System.out.print(string);
                    System.out.println("\n *** END MESSAGE **** \n");
                }
                ByteArrayInputStream byteArrayInputStream = null;
                try {
                    byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
                return byteArrayInputStream2;
            }
            if (message instanceof BytesMessage) {
                ByteArrayInputStream byteArrayInputStream;
                byte[] byArray = new byte[(int)((BytesMessage)message).getBodyLength()];
                ((BytesMessage)message).readBytes(byArray);
                if (verbose) {
                    System.out.println("\n *** RECEIVED FOLLOWING MESSAGE AT CALLING SIDE *** \n");
                    System.out.print(new String(byArray));
                    System.out.println("\n *** END MESSAGE **** \n");
                }
                ByteArrayInputStream byteArrayInputStream3 = byteArrayInputStream = new ByteArrayInputStream(byArray);
                return byteArrayInputStream3;
            }
            try {
                throw new IOException("Got an unsuported JMS message type: " + message);
            }
            catch (JMSException jMSException) {
                IOException iOException = new IOException("Failed to receive message");
                iOException.initCause(jMSException);
                throw iOException;
            }
        }
        finally {
            this.connection.release();
        }
    }

    public void confirmOneway() throws IOException {
        if (verbose) {
            Verbose.log("confirmOneway is called");
        }
        this.connection.release();
    }

    class JmsMessageData
    extends ByteArrayOutputStream {
        JmsMessageData() {
        }

        public void close() throws IOException {
            if (verbose) {
                Verbose.log("here");
            }
            super.close();
            try {
                JmsTransport.this.completeSend();
            }
            catch (JMSException jMSException) {
                throw new ConnectionException("Failed to send jms message", jMSException);
            }
        }
    }
}

