/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.transport.jms;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.rpc.JAXRPCException;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.util.JmsUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;

public class JmsTransportInfo
implements TransportInfo,
Serializable {
    private static final long serialVersionUID = -7303084944915898634L;
    private static final boolean verbose = Verbose.isVerbose(JmsTransportInfo.class);
    private String host;
    private int port;
    private String jndiURL;
    private String factory;
    private String queue;
    private String serviceURI;
    private boolean transactional = false;
    private String username;
    private String password;
    private boolean defaultFactory = false;
    private boolean sendTo81 = false;

    public JmsTransportInfo(String string) throws URISyntaxException {
        URI uRI = new URI(string);
        this.host = uRI.getHost();
        this.port = uRI.getPort();
        String string2 = uRI.getQuery();
        this.jndiURL = null;
        if (verbose) {
            Verbose.log("Query :" + string2);
        }
        if (string2 == null) {
            this.queue = "weblogic.wsee.DefaultQueue";
            this.factory = "weblogic.jms.ConnectionFactory";
            this.defaultFactory = true;
        } else {
            Map map = JmsUtil.asMap(string2);
            this.queue = (String)map.get("URI");
            if (StringUtil.isEmpty(this.queue)) {
                this.queue = "weblogic.wsee.DefaultQueue";
            } else if (this.checkWlw81Uri(uRI)) {
                this.sendTo81 = true;
                return;
            }
            this.factory = (String)map.get("FACTORY");
            if (verbose) {
                Verbose.log("queue :" + this.queue + " factory = " + this.factory);
            }
            if (StringUtil.isEmpty(this.factory)) {
                this.factory = "weblogic.jms.ConnectionFactory";
                this.defaultFactory = true;
            }
        }
        this.serviceURI = uRI.getPath();
    }

    private boolean checkWlw81Uri(URI uRI) {
        if (this.isWlw81Uri(this.queue)) {
            this.serviceURI = this.queue;
            String string = uRI.getPath();
            String[] stringArray = string.split("/");
            if (stringArray.length != 3) {
                throw new JAXRPCException("Incorrect format for path");
            }
            this.factory = stringArray[1];
            this.queue = stringArray[2];
            return true;
        }
        return false;
    }

    private boolean isWlw81Uri(String string) {
        return string.startsWith("/");
    }

    public boolean isSendTo81() {
        return this.sendTo81;
    }

    public String getServiceUri() {
        return this.serviceURI;
    }

    public String getJndiURL() {
        return this.jndiURL;
    }

    public void setJndiURL(String string) {
        this.jndiURL = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getFactory() {
        return this.factory;
    }

    public void setFactory(String string) {
        this.factory = string;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String string) {
        this.queue = string;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean bl) {
        this.transactional = bl;
        if (bl && this.defaultFactory) {
            this.factory = "weblogic.jms.XAConnectionFactory";
        }
    }

    public boolean isDefaultFactory() {
        return this.defaultFactory;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JmsTransportInfo)) {
            return false;
        }
        JmsTransportInfo jmsTransportInfo = (JmsTransportInfo)object;
        if (this.host == null && jmsTransportInfo.getHost() != null || this.host != null && !this.host.equals(jmsTransportInfo.getHost())) {
            return false;
        }
        if (this.port != jmsTransportInfo.getPort()) {
            return false;
        }
        if (this.jndiURL == null && jmsTransportInfo.getJndiURL() != null || this.jndiURL != null && !this.jndiURL.equals(jmsTransportInfo.getJndiURL())) {
            return false;
        }
        if (this.factory == null && jmsTransportInfo.getFactory() != null || this.factory != null && !this.factory.equals(jmsTransportInfo.getFactory())) {
            return false;
        }
        if (this.queue == null && jmsTransportInfo.getQueue() != null || this.queue != null && !this.queue.equals(jmsTransportInfo.getQueue())) {
            return false;
        }
        if (this.serviceURI == null && jmsTransportInfo.getServiceUri() != null || this.serviceURI != null && !this.serviceURI.equals(jmsTransportInfo.getServiceUri())) {
            return false;
        }
        if (this.username == null && jmsTransportInfo.getUsername() != null || this.username != null && !this.username.equals(jmsTransportInfo.getUsername())) {
            return false;
        }
        if (this.password == null && jmsTransportInfo.getPassword() != null || this.password != null && !this.password.equals(jmsTransportInfo.getPassword())) {
            return false;
        }
        if (this.transactional != jmsTransportInfo.isTransactional()) {
            return false;
        }
        return this.defaultFactory == jmsTransportInfo.isDefaultFactory();
    }

    public int hashCode() {
        int n = 0;
        if (this.host != null) {
            n = this.host.hashCode();
        }
        n = 29 * n + this.port;
        if (this.jndiURL != null) {
            n = 29 * n + this.jndiURL.hashCode();
        }
        if (this.factory != null) {
            n = 29 * n + this.factory.hashCode();
        }
        if (this.queue != null) {
            n = 29 * n + this.queue.hashCode();
        }
        if (this.serviceURI != null) {
            n = 29 * n + this.serviceURI.hashCode();
        }
        if (this.username != null) {
            n = 29 * n + this.username.hashCode();
        }
        if (this.password != null) {
            n = 29 * n + this.password.hashCode();
        }
        if (this.transactional) {
            n = 29 * n + 1;
        }
        if (this.defaultFactory) {
            n = 29 * n + 1;
        }
        return n;
    }
}

