/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.transport.rmi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.Iterator;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import weblogic.wsee.connection.transport.ServerTransport;
import weblogic.wsee.util.Verbose;

public class RMIServerTransport
implements ServerTransport {
    private static final boolean verbose = Verbose.isVerbose(RMIServerTransport.class);
    protected String uri;
    protected OutputStream os;

    public RMIServerTransport(String string, OutputStream outputStream) {
        this.uri = string;
        this.os = outputStream;
    }

    public String getServiceURI() {
        return this.uri;
    }

    public String getEndpointAddress() {
        return null;
    }

    public String getName() {
        return "RMIServerTransport";
    }

    public OutputStream send(MimeHeaders mimeHeaders) throws IOException {
        assert (mimeHeaders != null);
        if (verbose) {
            Verbose.log("Sending from RMIServerTransport");
            Iterator iterator = mimeHeaders.getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                Verbose.log("Name: " + mimeHeader.getName() + " Value: " + mimeHeader.getValue());
            }
        }
        return this.os;
    }

    public OutputStream sendGeneralFault(MimeHeaders mimeHeaders) throws IOException {
        return this.send(mimeHeaders);
    }

    public OutputStream sendAuthorizationFault(MimeHeaders mimeHeaders) throws IOException {
        return this.send(mimeHeaders);
    }

    public OutputStream sendAuthorizationRequiredFault(MimeHeaders mimeHeaders) throws IOException {
        return this.send(mimeHeaders);
    }

    public InputStream receive(MimeHeaders mimeHeaders) throws IOException {
        throw new IOException("RMIServerTransport receive should not be called");
    }

    public boolean isUserInRole(String string) {
        throw new Error("NYI");
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isReliable() {
        return false;
    }

    public void confirmOneway() throws IOException {
        if (verbose) {
            Verbose.log("confirming status of oneway");
        }
    }
}

