/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.transport.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import weblogic.wsee.connection.transport.ServerTransport;
import weblogic.wsee.connection.transport.TransportUtil;
import weblogic.wsee.util.ServletDebugUtil;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.VerboseOutputStream;

public class HttpServerTransport
implements ServerTransport {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String serviceURI;
    private static final boolean verbose = Verbose.isVerbose(HttpServerTransport.class);

    public HttpServerTransport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.serviceURI = httpServletRequest.getContextPath() + httpServletRequest.getServletPath();
    }

    public String getServiceURI() {
        return this.serviceURI;
    }

    public String getEndpointAddress() {
        StringBuffer stringBuffer = new StringBuffer(this.request.getScheme());
        stringBuffer.append("://");
        stringBuffer.append(this.request.getServerName());
        stringBuffer.append(":");
        stringBuffer.append(this.request.getServerPort());
        stringBuffer.append(this.serviceURI);
        return stringBuffer.toString();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getName() {
        return "HttpServerTransport";
    }

    public OutputStream send(MimeHeaders mimeHeaders) throws IOException {
        assert (mimeHeaders != null);
        if (verbose) {
            Verbose.say("     ** S T A R T   R E S P O N S E **");
        }
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            this.response.addHeader(mimeHeader.getName(), mimeHeader.getValue());
            if (!verbose) continue;
            Verbose.say(mimeHeader.getName() + ": " + mimeHeader.getValue());
        }
        if (verbose) {
            ServletDebugUtil.printResponse(this.response);
            return new VerboseOutputStream((OutputStream)this.response.getOutputStream());
        }
        return this.response.getOutputStream();
    }

    public OutputStream sendGeneralFault(MimeHeaders mimeHeaders) throws IOException {
        this.response.setStatus(500);
        return this.send(mimeHeaders);
    }

    public OutputStream sendAuthorizationFault(MimeHeaders mimeHeaders) throws IOException {
        this.response.setStatus(403);
        return this.send(mimeHeaders);
    }

    public OutputStream sendAuthorizationRequiredFault(MimeHeaders mimeHeaders) throws IOException {
        this.response.setStatus(401);
        return this.send(mimeHeaders);
    }

    public InputStream receive(MimeHeaders mimeHeaders) throws IOException {
        assert (mimeHeaders != null);
        Object object = this.request.getHeaderNames();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            String string2 = this.request.getHeader(string);
            mimeHeaders.addHeader(string, string2);
        }
        object = this.request.getInputStream();
        if (verbose) {
            Verbose.say("     ** S T A R T   R E Q U E S T **");
            ServletDebugUtil.printRequest(this.request);
            object = TransportUtil.dumpInput((InputStream)object);
            Verbose.say("");
            Verbose.say("     ** E N D   R E Q U E S T **");
        }
        return object;
    }

    public boolean isUserInRole(String string) {
        return this.request.isUserInRole(string);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public boolean isReliable() {
        return false;
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }

    public void confirmOneway() throws IOException {
        if (verbose) {
            Verbose.log("confirming status of oneway @ " + new Date().toString());
        }
        this.response.setStatus(202);
        this.response.setContentLength(0);
        this.response.flushBuffer();
    }
}

