/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.context;

import java.util.HashMap;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import weblogic.wsee.context.ContextNotFoundException;
import weblogic.wsee.context.WebServiceHeader;
import weblogic.wsee.context.WebServiceSession;

public abstract class WebServiceContext {
    private static HashMap contexts = new HashMap();

    WebServiceContext() {
    }

    public static WebServiceContext currentContext() throws ContextNotFoundException {
        WebServiceContext webServiceContext = (WebServiceContext)contexts.get(Thread.currentThread());
        if (webServiceContext == null) {
            throw new ContextNotFoundException("unable to find context for current thread");
        }
        return webServiceContext;
    }

    public static void register(WebServiceContext webServiceContext) {
        if (webServiceContext == null) {
            contexts.remove(Thread.currentThread());
        } else {
            contexts.put(Thread.currentThread(), webServiceContext);
        }
    }

    public abstract WebServiceHeader getHeader();

    public abstract WebServiceSession getSession();

    public abstract SOAPMessageContext getLastMessageContext();
}

