/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.conversation;

import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.w3c.dom.Element;
import weblogic.wsee.conversation.ConversationConstants;
import weblogic.wsee.conversation.ConversationHeader;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderType;
import weblogic.wsee.util.ToStringWriter;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class ContinueHeader
extends ConversationHeader {
    static final long serialVersionUID = -6280278919348660347L;
    private String serverName;
    private String appVersionId;
    public static final QName NAME = ConversationConstants.CONV_HEADER_CONTINUE;
    public static final MsgHeaderType TYPE = new MsgHeaderType();

    public ContinueHeader(String string) {
        super(string);
    }

    public ContinueHeader(String string, String string2) {
        super(string);
        this.serverName = string2;
    }

    public ContinueHeader(String string, String string2, String string3) {
        super(string);
        this.serverName = string2;
        this.appVersionId = string3;
    }

    public ContinueHeader() {
    }

    public QName getName() {
        return ConversationConstants.CONV_HEADER_CONTINUE;
    }

    public MsgHeaderType getType() {
        return TYPE;
    }

    public boolean isServerAssigned() {
        return this.serverName != null;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public String getAppVersionId() {
        return this.appVersionId;
    }

    public void setAppVersionId(String string) {
        this.appVersionId = string;
    }

    public void write(Element element) throws MsgHeaderException {
        super.write(element);
        if (this.serverName != null) {
            DOMUtils.addValueNS(element, "http://www.openuri.org/2002/04/soap/conversation/", "conv:serverName", this.serverName);
        }
        if (this.appVersionId != null) {
            DOMUtils.addValueNS(element, "http://www.openuri.org/2002/04/soap/conversation/", "conv:appVersionId", this.appVersionId);
        }
    }

    public void read(Element element) throws MsgHeaderException {
        super.read(element);
        try {
            this.serverName = DOMUtils.getOptionalValueByTagNameNS(element, "http://www.openuri.org/2002/04/soap/conversation/", "serverName");
            this.appVersionId = DOMUtils.getOptionalValueByTagNameNS(element, "http://www.openuri.org/2002/04/soap/conversation/", "appVersionId");
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new MsgHeaderException("Could not read server name", (Throwable)((Object)dOMProcessingException));
        }
    }

    public void toString(ToStringWriter toStringWriter) {
        super.toString(toStringWriter);
        toStringWriter.writeField("serverName", this.serverName);
        toStringWriter.writeField("appVersionId", this.appVersionId);
    }

    public String convertToWlw81StringForm() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.conversationId == null) {
            throw new JAXRPCException("No conversation ID found");
        }
        stringBuffer.append("cid=" + this.conversationId + ";");
        if (this.serverName != null) {
            stringBuffer.append("sn=" + this.serverName + ";");
        }
        return stringBuffer.toString();
    }

    public void parseFromWlw81StringForm(String string) {
        if (string == null) {
            throw new JAXRPCException("Input callback information is null");
        }
        int n = string.indexOf("cid=");
        if (n < 0) {
            throw new JAXRPCException("No conversation ID found in callback information " + string);
        }
        int n2 = string.indexOf(";", n += "cid=".length());
        if (n2 <= n) {
            throw new JAXRPCException("No conversation ID value found in callback information " + string);
        }
        this.conversationId = string.substring(n, n2);
        n = string.indexOf("sn=", n2);
        if (n >= 0) {
            n2 = string.indexOf(";", n += "sn=".length());
            if (n2 <= n) {
                throw new JAXRPCException("No server name value found in callback information " + string);
            }
            this.serverName = string.substring(n, n2);
        }
    }
}

