/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.conversation;

import java.util.Iterator;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.jws.Conversational;
import weblogic.jws.DatabaseStore;
import weblogic.jws.FileStore;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.conversation.ConversationHandler;
import weblogic.wsee.conversation.ConversationPhase;
import weblogic.wsee.conversation.LockManager;
import weblogic.wsee.deploy.VersioningHelper;
import weblogic.wsee.handler.WLHandler;
import weblogic.wsee.jws.container.Container;
import weblogic.wsee.jws.container.ContainerFactory;
import weblogic.wsee.jws.conversation.ConversationState;
import weblogic.wsee.jws.conversation.Store;
import weblogic.wsee.jws.conversation.StoreConfig;
import weblogic.wsee.jws.conversation.StoreException;
import weblogic.wsee.jws.conversation.StoreManager;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;

public class ConversationCMPHandler
extends ConversationHandler
implements WLHandler {
    public static final String CONVERSATION_STORE_CONFIG = "weblogic.wsee.conversation.StoreConfig";
    public static final String CONVERSATION_LOCK = "weblogic.wsee.conversation.Lock";
    public static final boolean verbose = Verbose.isVerbose(ConversationCMPHandler.class);

    public boolean handleRequest(MessageContext messageContext) {
        Object object;
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        ConversationPhase conversationPhase = (ConversationPhase)messageContext.getProperty("weblogic.wsee.conversation.ConversationPhase");
        if (conversationPhase == null || conversationPhase == ConversationPhase.NONE) {
            return true;
        }
        String string = this.getConversationId(wlMessageContext);
        try {
            object = LockManager.getInstance().lock(string);
            messageContext.setProperty(CONVERSATION_LOCK, object);
        }
        catch (InterruptedException interruptedException) {
            throw new JAXRPCException((Throwable)interruptedException);
        }
        object = this.getStore(string, wlMessageContext);
        if (conversationPhase != ConversationPhase.START) {
            ConversationState conversationState = null;
            try {
                conversationState = ConversationCMPHandler.loadState(wlMessageContext, (Store)object, string);
            }
            catch (RuntimeException runtimeException) {
                Iterator iterator = wlMessageContext.getPropertyNames();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    Verbose.log(string2 + " = " + wlMessageContext.getProperty(string2));
                }
                Verbose.log(wlMessageContext.getDispatcher().getWsPort().getEndpoint().getJwsClass().getName());
                Verbose.log(Thread.currentThread().getContextClassLoader());
                throw runtimeException;
            }
            wlMessageContext.setProperty("weblogic.wsee.jws.container", conversationState);
            Container container = ContainerFactory.getContainer(messageContext);
            Conversational conversational = container.getTargetJWS().getClass().getAnnotation(Conversational.class);
            if (conversational != null && conversational.runAsStartUser()) {
                wlMessageContext.setProperty("weblogic.wsee.ejb.altRunAs", conversationState.getAltAuthenticatedSubject());
                wlMessageContext.setProperty("weblogic.wsee.wss.subject", conversationState.getAltAuthenticatedSubject());
            }
        }
        return true;
    }

    protected Store getStore(String string, WlMessageContext wlMessageContext) {
        try {
            StoreConfig storeConfig = this.getStoreConfig(wlMessageContext);
            Store store = StoreManager.getStore(storeConfig);
            wlMessageContext.setProperty(CONVERSATION_STORE_CONFIG, storeConfig);
            return store;
        }
        catch (Throwable throwable) {
            throw new JAXRPCException("Could not get Store for conversation with id " + string, throwable);
        }
    }

    private StoreConfig getStoreConfig(WlMessageContext wlMessageContext) {
        StoreConfig storeConfig = null;
        Class clazz = wlMessageContext.getDispatcher().getWsPort().getEndpoint().getJwsClass();
        DatabaseStore databaseStore = clazz.getAnnotation(DatabaseStore.class);
        if (databaseStore == null) {
            storeConfig = new StoreConfig("file");
            FileStore fileStore = clazz.getAnnotation(FileStore.class);
            if (fileStore != null && !StringUtil.isEmpty(fileStore.storeName())) {
                storeConfig.put("storeName", fileStore.storeName());
            }
        } else {
            storeConfig = new StoreConfig("database");
        }
        return storeConfig;
    }

    private String getConversationId(WlMessageContext wlMessageContext) {
        String string = (String)wlMessageContext.getProperty("weblogic.wsee.conversation.ConversationId");
        assert (string != null);
        return string;
    }

    protected static ConversationState loadState(WlMessageContext wlMessageContext, Store store, String string) {
        try {
            ConversationState conversationState = store.readForUpdate(string);
            if (conversationState == null) {
                throw new JAXRPCException("Conversation " + string + " not found in store: " + store);
            }
            return conversationState;
        }
        catch (StoreException storeException) {
            throw new JAXRPCException("Could not load conversation with id " + string, (Throwable)storeException);
        }
    }

    public boolean handleResponse(MessageContext messageContext) {
        return this.finish(messageContext);
    }

    public boolean handleClosure(MessageContext messageContext) {
        return this.finish(messageContext);
    }

    public boolean handleFault(MessageContext messageContext) {
        return this.finish(messageContext);
    }

    private boolean finish(MessageContext messageContext) {
        String string;
        LockManager.Lock lock;
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        ConversationPhase conversationPhase = (ConversationPhase)messageContext.getProperty("weblogic.wsee.conversation.ConversationPhase");
        if (conversationPhase == null || conversationPhase == ConversationPhase.NONE) {
            return true;
        }
        Container container = AsyncUtil.getContainer(messageContext);
        if (conversationPhase.equals(ConversationPhase.FINISH) || container == null || container.isFinished()) {
            LockManager.getInstance().destroy(this.getConversationId(WlMessageContext.narrow(messageContext)));
        }
        if ((lock = (LockManager.Lock)messageContext.getProperty(CONVERSATION_LOCK)) != null) {
            lock.release();
        }
        if ((string = ApplicationVersionUtils.getCurrentVersionId()) != null) {
            String string2 = ApplicationVersionUtils.getApplicationName(ApplicationVersionUtils.getCurrentApplicationId());
            ConversationCMPHandler.updateInstanceCount(string2, (String)wlMessageContext.getProperty("weblogic.wsee.version.appversion.id"), conversationPhase);
        }
        return true;
    }

    private static void updateInstanceCount(String string, String string2, ConversationPhase conversationPhase) {
        int n = 0;
        if (conversationPhase.equals(ConversationPhase.START)) {
            n = 1;
        } else if (conversationPhase.equals(ConversationPhase.FINISH)) {
            n = -1;
        }
        if (n != 0) {
            VersioningHelper.updateCount(string, string2, n);
        }
    }
}

