/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.conversation;

import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import weblogic.jws.CallbackMethod;
import weblogic.wsee.callback.CallbackInfoHeader;
import weblogic.wsee.component.pojo.JavaClassComponent;
import weblogic.wsee.conversation.ContinueHeader;
import weblogic.wsee.conversation.ConversationHandler;
import weblogic.wsee.conversation.ConversationPhase;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsRegistry;
import weblogic.wsee.ws.WsSkel;

public class ConversationCallbackHandler
extends ConversationHandler {
    private static final boolean verbose = Verbose.isVerbose(ConversationCallbackHandler.class);

    public boolean handleRequest(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        CallbackInfoHeader callbackInfoHeader = (CallbackInfoHeader)wlMessageContext.getHeaders().getHeader(CallbackInfoHeader.TYPE);
        if (callbackInfoHeader == null) {
            throw new JAXRPCException("No callback information header specified");
        }
        String string = callbackInfoHeader.getStubName();
        String string2 = callbackInfoHeader.getServiceURI();
        String string3 = null;
        string3 = callbackInfoHeader.getAppVersion();
        if (string3 != null) {
            if (verbose) {
                Verbose.log("Setting version to send callback to " + string3);
            }
            wlMessageContext.setProperty("weblogic.wsee.callback.appversion", string3);
        } else if (verbose) {
            Verbose.log("No app version in callback info header");
        }
        wlMessageContext.setProperty("weblogic.wsee.enclosing.jws.serviceuri", string2);
        WsPort wsPort = WsRegistry.instance().lookup(string2, string3);
        if (wsPort == null) {
            throw new JAXRPCException("No port found for " + string2);
        }
        wlMessageContext.setProperty("weblogic.wsee.callback.class", wsPort.getEndpoint().getJwsClass().getName());
        JavaClassComponent javaClassComponent = (JavaClassComponent)((WsSkel)wsPort.getEndpoint()).getComponent();
        Class clazz = javaClassComponent.getTargetClass();
        Method[] methodArray = clazz.getDeclaredMethods();
        QName qName = (QName)wlMessageContext.getProperty("weblogic.wsee.ws.server.OperationName");
        assert (qName != null);
        String string4 = qName.getLocalPart();
        boolean bl = false;
        for (int i = 0; i < methodArray.length; ++i) {
            String string5;
            CallbackMethod callbackMethod = null;
            callbackMethod = methodArray[i].getAnnotation(CallbackMethod.class);
            if (callbackMethod == null || string != null && !string.equals(string5 = callbackMethod.target())) continue;
            string5 = callbackMethod.operation();
            assert (string5 != null);
            if (!string5.equals(string4)) continue;
            wlMessageContext.setProperty("weblogic.wsee.callback.method", methodArray[i].getName());
            bl = true;
            break;
        }
        if (!bl) {
            throw new JAXRPCException("No callback method found");
        }
        ContinueHeader continueHeader = (ContinueHeader)wlMessageContext.getHeaders().getHeader(ContinueHeader.TYPE);
        if (continueHeader != null) {
            wlMessageContext.setProperty("weblogic.wsee.conversation.ConversationId", continueHeader.getConversationId());
            wlMessageContext.setProperty("weblogic.wsee.conversation.IsServerAssigned", new Boolean(continueHeader.isServerAssigned()));
            wlMessageContext.setProperty("weblogic.wsee.conversation.ConversationPhase", ConversationPhase.CONTINUE);
        }
        return true;
    }
}

