/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.conversation;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.conversation.ConversationClientHandler;
import weblogic.wsee.conversation.ConversationGetIdHandler;
import weblogic.wsee.conversation.ConversationUtils;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public class ConversationClientDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(ConversationClientDeploymentListener.class);
    private static final HandlerInfo HANDLER = new HandlerInfo(ConversationClientHandler.class, null, null);
    private static final HandlerInfo GET_ID_HANDLER = new HandlerInfo(ConversationGetIdHandler.class, null, null);
    private static final List BEFORE_CONVERSATION = Arrays.asList((Object[])new String[]{"MMEHEADER_HANDLER", "JAX_RPC_CHAIN_HANDLER"});
    private static final List AFTER_CONVERSATION = Arrays.asList((Object[])new String[]{"ADDRESSING_HANDLER"});
    private static final List BEFORE_CONVERSATION_GET_ID = Arrays.asList((Object[])new String[]{"ADDRESSING_HANDLER"});
    private static final List AFTER_CONVERSATION_GET_ID = Arrays.asList((Object[])new String[]{"CODEC_HANDLER", "WSRM_PREPROCESS_HANDLER"});

    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        if (verbose) {
            Verbose.log("Running ConversationClientDeploymentListener");
        }
        Iterator<WsPort> iterator = wsDeploymentContext.getWsService().getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            if (!ConversationUtils.isConversational(wsPort)) continue;
            try {
                wsPort.getInternalHandlerList().lenientInsert("CONVERSATION_HANDLER", HANDLER, AFTER_CONVERSATION, BEFORE_CONVERSATION);
                wsPort.getInternalHandlerList().lenientInsert("CONVERSATION_GET_ID_HANDLER", GET_ID_HANDLER, AFTER_CONVERSATION_GET_ID, BEFORE_CONVERSATION_GET_ID);
            }
            catch (HandlerException handlerException) {
                throw new WsDeploymentException("Could not insert client-side conversation handler", handlerException);
            }
        }
    }
}

