/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.conversation;

import java.util.Map;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.LocalServerIdentity;
import weblogic.store.PersistentStoreException;
import weblogic.wsee.addressing.AddressingProvider;
import weblogic.wsee.addressing.AddressingProviderFactory;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.addressing.ReplyToHeader;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.cluster.ClusterUtil;
import weblogic.wsee.cluster.CorrelationHeader;
import weblogic.wsee.cluster.ServiceIdentityHeader;
import weblogic.wsee.connection.soap.SoapClientConnection;
import weblogic.wsee.conversation.ContinueHeader;
import weblogic.wsee.conversation.ConversationHandler;
import weblogic.wsee.conversation.ConversationInvokeState;
import weblogic.wsee.conversation.ConversationInvokeStateObjectHandler;
import weblogic.wsee.conversation.ConversationPhase;
import weblogic.wsee.conversation.StartHeader;
import weblogic.wsee.message.FreeStandingMsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMsgHeaders;
import weblogic.wsee.server.ServerUtil;
import weblogic.wsee.server.WsStorage;
import weblogic.wsee.server.WsStorageFactory;
import weblogic.wsee.util.AddressingUtil;
import weblogic.wsee.util.Guid;
import weblogic.wsee.util.Verbose;

public class ConversationClientHandler
extends ConversationHandler {
    public static final boolean verbose = Verbose.isVerbose(ConversationClientHandler.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleRequest(MessageContext messageContext) {
        if (!(messageContext instanceof SOAPMessageContext)) {
            return true;
        }
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        ConversationPhase conversationPhase = (ConversationPhase)messageContext.getProperty("weblogic.wsee.conversation.ConversationPhase");
        if (conversationPhase == null || conversationPhase == ConversationPhase.NONE) {
            return true;
        }
        if (conversationPhase == ConversationPhase.START && messageContext.getProperty("weblogic.wsee.conversation.started") != null) {
            throw new JAXRPCException("Cannot invoke a start method when conversation has already started. Conv id=" + messageContext.getProperty("weblogic.wsee.conversation.ConversationId"));
        }
        int n = this.getConversationMajorVersion(wlMessageContext);
        String string = (String)messageContext.getProperty("weblogic.wsee.conversation.ConversationId");
        if (n == 2 && conversationPhase == ConversationPhase.START && string != null) {
            throw new JAXRPCException("In Diablo style conversation, a start method invoke should not include a client assigned conversation ID: " + string);
        }
        boolean bl = KernelStatus.isServer();
        Map map = (Map)messageContext.getProperty("weblogic.wsee.invoke_properties");
        assert (map != null);
        if (string == null) {
            if (n == 1) {
                if (conversationPhase != ConversationPhase.START) throw new JAXRPCException("Conversation id does not exist for operation marked " + conversationPhase);
                string = Guid.generateGuid();
                messageContext.setProperty("weblogic.wsee.conversation.ConversationId", (Object)string);
                map.put("weblogic.wsee.conversation.ConversationId", string);
                wlMessageContext.getHeaders().addHeader(new StartHeader(string));
            } else {
                if (n != 2) throw new JAXRPCException("Unsupported conversation version " + n);
                if (conversationPhase == ConversationPhase.START) {
                    boolean bl2;
                    boolean bl3 = wlMessageContext.getDispatcher().getOperation().getType() != 0;
                    ReplyToHeader replyToHeader = (ReplyToHeader)wlMessageContext.getHeaders().getHeader(ReplyToHeader.TYPE);
                    assert (replyToHeader != null);
                    boolean bl4 = bl2 = !AddressingUtil.isAnonymous(messageContext, replyToHeader.getReference()) || messageContext.getProperty("weblogic.wsee.async.invoke") != null;
                    if (!bl) {
                        if (bl3 || bl2) {
                            throw new JAXRPCException("Invoking a one way conversational start method requires to be on a server.");
                        }
                    } else if (bl3 || bl2) {
                        this.handleAsyncConvId(messageContext, bl2, replyToHeader, map);
                    }
                }
            }
        } else if (n == 1) {
            String string2 = (String)messageContext.getProperty("weblogic.wsee.callback.loc");
            if (conversationPhase == ConversationPhase.START) {
                wlMessageContext.getHeaders().addHeader(new StartHeader(string, string2));
            } else {
                wlMessageContext.getHeaders().addHeader(new ContinueHeader(string));
            }
        } else if (messageContext.getProperty("weblogic.wsee.conversation.key") != null) {
            messageContext.removeProperty("weblogic.wsee.conversation.key");
        }
        map.put("weblogic.wsee.conversation.started", "true");
        return true;
    }

    private void handleAsyncConvId(MessageContext messageContext, boolean bl, ReplyToHeader replyToHeader, Map map) {
        String string;
        EndpointReference endpointReference = null;
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(messageContext);
        if (bl) {
            endpointReference = addressingProvider.createEndpointReference(replyToHeader.getReference().getAddress());
        } else {
            string = SoapClientConnection.getDestinationAddress(messageContext);
            String string2 = ClusterUtil.getProtocol(string);
            if (string2 == null) {
                string2 = "http";
            }
            String string3 = ServerUtil.getServerURL(string2) + AsyncUtil.getAsyncUri(AsyncUtil.isSoap12(messageContext), string2);
            if ("jms".equals(string2)) {
                string3 = string3 + "?URI=" + ServerUtil.getMessagingQueue() + "&FACTORY=" + ServerUtil.getJmsConnectionFactory();
            }
            endpointReference = addressingProvider.createEndpointReference(string3);
        }
        string = Guid.generateGuid();
        this.mergeReplyToHeader(replyToHeader, endpointReference, (WlMessageContext)messageContext, string);
        this.saveConversationInvokeState(messageContext, string);
        map.put("weblogic.wsee.conversation.correlation.id", string);
        map.put("weblogic.wsee.conversation.epr.set", "false");
        map.put("weblogic.wsee.conversation.key", Guid.generateGuid());
    }

    private void saveConversationInvokeState(MessageContext messageContext, String string) {
        boolean bl = messageContext.getProperty("weblogic.wsee.enable.rm") != null;
        WsStorage wsStorage = WsStorageFactory.getStorage("weblogic.wsee.conversation.store", new ConversationInvokeStateObjectHandler());
        ConversationInvokeState conversationInvokeState = new ConversationInvokeState();
        Integer n = (Integer)messageContext.getProperty("weblogic.wsee.conversation.method.block.timeout");
        conversationInvokeState.setAbsTimeout(System.currentTimeMillis() + (long)(n == null ? 120000 : n * 1000));
        conversationInvokeState.setRmState(bl);
        String string2 = (String)messageContext.getProperty("weblogic.wsee.version.appversion.id");
        conversationInvokeState.setAppVersion(string2);
        try {
            if (bl) {
                if (verbose) {
                    Verbose.log("Storing ConversationInvokeState RM=true with NO seq ID under correlation ID " + string + ". Will not get cleaned up till explicitly removed, seqId set and seq is terminated, or main timeout expires");
                }
                wsStorage.persistentPut(string, conversationInvokeState);
            } else {
                wsStorage.put(string, conversationInvokeState);
            }
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new JAXRPCException((Throwable)persistentStoreException);
        }
    }

    private void mergeReplyToHeader(ReplyToHeader replyToHeader, EndpointReference endpointReference, WlMessageContext wlMessageContext, String string) {
        FreeStandingMsgHeaders freeStandingMsgHeaders = new FreeStandingMsgHeaders();
        CorrelationHeader correlationHeader = new CorrelationHeader();
        correlationHeader.setCorrelationId(string);
        freeStandingMsgHeaders.addHeader(correlationHeader);
        ServiceIdentityHeader serviceIdentityHeader = new ServiceIdentityHeader();
        serviceIdentityHeader.setServerName(LocalServerIdentity.getIdentity().getServerName());
        serviceIdentityHeader.setServiceName("weblogic.wsee.conversation.msg.cluster.service");
        freeStandingMsgHeaders.addHeader(serviceIdentityHeader);
        FreeStandingMsgHeaders freeStandingMsgHeaders2 = (FreeStandingMsgHeaders)replyToHeader.getReference().getReferenceParameters();
        freeStandingMsgHeaders.merge(freeStandingMsgHeaders2);
        endpointReference.setReferenceParameters(freeStandingMsgHeaders);
        endpointReference.setReferenceProperties((FreeStandingMsgHeaders)replyToHeader.getReference().getReferenceProperties());
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(wlMessageContext);
        ((SoapMsgHeaders)wlMessageContext.getHeaders()).replaceHeader(addressingProvider.createReplyToHeader(endpointReference));
    }
}

