/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.conversation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.cluster.ClusterDispatcher;
import weblogic.wsee.cluster.ForwardingHandler;
import weblogic.wsee.conversation.ConversationCMPHandler;
import weblogic.wsee.conversation.ConversationMsgClusterService;
import weblogic.wsee.conversation.ConversationServerHandler;
import weblogic.wsee.conversation.ConversationUtils;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.reliability.ReliableConversationMsgClusterService;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public class ConversationDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(ConversationDeploymentListener.class);
    private static final List CONVERSATION_HANDLER_BEFORE = Arrays.asList((Object[])new String[]{"PRE_INVOKE_HANDLER"});
    private static final List CONVERSATION_HANDLER_AFTER = Arrays.asList((Object[])new String[]{"ONE_WAY_HANDLER"});
    private static final List FORWARDING_HANDLER_BEFORE = Arrays.asList((Object[])new String[]{"ADDRESSING_HANDLER", "SECURITY_HANDLER"});
    private static final List FORWARDING_HANDLER_AFTER = Arrays.asList((Object[])new String[]{"CONNECTION_HANDLER"});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        if (verbose) {
            Verbose.log("ConversationDeploymentListener firing");
        }
        Iterator<WsPort> iterator = wsDeploymentContext.getWsService().getPorts();
        boolean bl = false;
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            if (!ConversationUtils.isConversational(wsPort)) continue;
            if (verbose) {
                Verbose.log("Adding conversation handlers for " + wsDeploymentContext.getServiceURIs()[0]);
            }
            HandlerInfo handlerInfo = new HandlerInfo(ForwardingHandler.class, new HashMap(), null);
            HandlerInfo handlerInfo2 = new HandlerInfo(ConversationServerHandler.class, null, null);
            HandlerInfo handlerInfo3 = new HandlerInfo(ConversationCMPHandler.class, null, null);
            try {
                wsPort.getInternalHandlerList().lenientInsert("FORWARDING_HANDLER", handlerInfo, FORWARDING_HANDLER_AFTER, FORWARDING_HANDLER_BEFORE);
                int n = wsPort.getInternalHandlerList().insert("ConversationServerHandler", handlerInfo2, CONVERSATION_HANDLER_AFTER, CONVERSATION_HANDLER_BEFORE);
                wsPort.getInternalHandlerList().insert("ConversationCMPHandler", n + 1, handlerInfo3);
            }
            catch (HandlerException handlerException) {
                throw new WsDeploymentException("Unable to register handler", handlerException);
            }
            Class<ConversationDeploymentListener> clazz = ConversationDeploymentListener.class;
            // MONITORENTER : weblogic.wsee.conversation.ConversationDeploymentListener.class
            ClusterDispatcher clusterDispatcher = ClusterDispatcher.getInstance();
            if (!bl) {
                clusterDispatcher.registerClusterService(new ConversationMsgClusterService());
                clusterDispatcher.registerClusterService(new ReliableConversationMsgClusterService());
                bl = true;
            }
            // MONITOREXIT : clazz
        }
    }
}

