/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.conversation;

import java.io.Serializable;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import weblogic.store.PersistentStoreException;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.conversation.ContinueHeader;
import weblogic.wsee.conversation.ConversationHandler;
import weblogic.wsee.conversation.ConversationInvokeState;
import weblogic.wsee.conversation.ConversationInvokeStateObjectHandler;
import weblogic.wsee.conversation.ConversationPhase;
import weblogic.wsee.handler.WLHandler;
import weblogic.wsee.message.FreeStandingMsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.server.WsStorage;
import weblogic.wsee.server.WsStorageFactory;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlBindingOperation;

public class ConversationGetIdHandler
extends ConversationHandler
implements WLHandler {
    static final int DEFAULT_WAITID_TIMEOUT = 120;
    private static final boolean verbose = Verbose.isVerbose(ConversationGetIdHandler.class);

    public boolean handleRequest(MessageContext messageContext) {
        if (!(messageContext instanceof SOAPMessageContext)) {
            return true;
        }
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        WsdlBindingOperation wsdlBindingOperation = wlMessageContext.getDispatcher().getBindingOperation();
        QName qName = wsdlBindingOperation.getName();
        ConversationPhase conversationPhase = this.getConversationPhase(wlMessageContext);
        if (conversationPhase == null || conversationPhase == ConversationPhase.NONE) {
            return true;
        }
        if (conversationPhase != ConversationPhase.START && messageContext.getProperty("weblogic.wsee.conversation.started") == null) {
            throw new JAXRPCException("Operation " + qName + " with phase " + conversationPhase + " cannot be invoked without calling" + " start operation first");
        }
        messageContext.setProperty("weblogic.wsee.conversation.ConversationPhase", (Object)conversationPhase);
        messageContext.setProperty("weblogic.wsee.complex", (Object)"true");
        int n = this.getConversationMajorVersion(wlMessageContext);
        if (n != 1 && n != 2) {
            throw new JAXRPCException("Unsupported conversation version " + n + " on method " + qName);
        }
        messageContext.setProperty("weblogic.wsee.conversation.ConversationVersion", (Object)new Integer(n));
        String string = (String)messageContext.getProperty("weblogic.wsee.conversation.ConversationId");
        if (string != null) {
            return true;
        }
        if (n == 1 || conversationPhase == ConversationPhase.START) {
            return true;
        }
        Map map = (Map)messageContext.getProperty("weblogic.wsee.invoke_properties");
        assert (map != null);
        String string2 = (String)map.get("weblogic.wsee.conversation.correlation.id");
        if (string2 != null) {
            EndpointReference endpointReference;
            Serializable serializable;
            ConversationInvokeState conversationInvokeState;
            WsStorage wsStorage = WsStorageFactory.getStorage("weblogic.wsee.conversation.store", new ConversationInvokeStateObjectHandler());
            try {
                conversationInvokeState = (ConversationInvokeState)wsStorage.persistentGet(string2);
                if (conversationInvokeState == null) {
                    throw new JAXRPCException("Cannot retrieve conversation information for correlation " + string2);
                }
            }
            catch (PersistentStoreException persistentStoreException) {
                if (verbose) {
                    Verbose.logException(persistentStoreException);
                }
                throw new JAXRPCException((Throwable)persistentStoreException);
            }
            EndpointReference endpointReference2 = conversationInvokeState.getEpr();
            if (endpointReference2 == null) {
                int n2;
                boolean bl;
                boolean bl2 = bl = messageContext.getProperty("weblogic.wsee.enable.rm") != null;
                if (bl) {
                    messageContext.setProperty("weblogic.wsee.conversation.waitid", (Object)"true");
                    return true;
                }
                serializable = (Integer)messageContext.getProperty("weblogic.wsee.conversation.method.block.timeout");
                int n3 = n2 = serializable == null ? 120 : (Integer)serializable;
                if (verbose) {
                    Verbose.log("Waiting for conversation EPR to come back on method " + qName + " (" + n2 + " seconds) ........");
                }
                if ((endpointReference2 = conversationInvokeState.getEpr(n2)) == null) {
                    throw new JAXRPCException("Did not receive server assigned conversation id for method " + qName + " in " + n2 + " seconds");
                }
            }
            if (verbose) {
                Verbose.log("Successfully got conversation EPR ........");
            }
            if ((endpointReference = (EndpointReference)messageContext.getProperty("weblogic.wsee.addressing.Target")) != null) {
                if (!endpointReference.getAddress().equals(endpointReference2.getAddress())) {
                    throw new JAXRPCException("The address in the new conversational EPR does not match the existing address for method " + qName + ", new: " + endpointReference2.getAddress() + " old: " + endpointReference.getAddress());
                }
                ((FreeStandingMsgHeaders)endpointReference.getReferenceProperties()).merge((FreeStandingMsgHeaders)endpointReference2.getReferenceProperties());
                ((FreeStandingMsgHeaders)endpointReference.getReferenceParameters()).merge((FreeStandingMsgHeaders)endpointReference2.getReferenceParameters());
                map.put("weblogic.wsee.addressing.Target", endpointReference);
            } else {
                map.put("weblogic.wsee.addressing.Target", endpointReference2);
                messageContext.setProperty("weblogic.wsee.addressing.Target", (Object)endpointReference2);
            }
            map.remove("weblogic.wsee.conversation.correlation.id");
            serializable = (EndpointReference)messageContext.getProperty("weblogic.wsee.addressing.Target");
            ContinueHeader continueHeader = (ContinueHeader)((EndpointReference)serializable).getReferenceParameters().getHeader(ContinueHeader.TYPE);
            if (continueHeader == null) {
                continueHeader = (ContinueHeader)((EndpointReference)serializable).getReferenceProperties().getHeader(ContinueHeader.TYPE);
            }
            if (continueHeader != null) {
                string = continueHeader.getConversationId();
                map.put("weblogic.wsee.conversation.ConversationId", string);
                messageContext.setProperty("weblogic.wsee.conversation.ConversationId", (Object)string);
            }
            try {
                if (verbose) {
                    Verbose.log("Explicitly removing ConversationInvokeState RM=true under correlation ID " + string2 + ".");
                }
                wsStorage.persistentRemove(string2);
            }
            catch (PersistentStoreException persistentStoreException) {
                if (verbose) {
                    Verbose.logException(persistentStoreException);
                }
                throw new JAXRPCException((Throwable)persistentStoreException);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleResponse(MessageContext messageContext) {
        ConversationPhase conversationPhase = (ConversationPhase)messageContext.getProperty("weblogic.wsee.conversation.ConversationPhase");
        if (conversationPhase == ConversationPhase.FINISH) {
            Map map = (Map)messageContext.getProperty("weblogic.wsee.invoke_properties");
            assert (map != null);
            Integer n = (Integer)messageContext.getProperty("weblogic.wsee.conversation.ConversationVersion");
            if (n == null) {
                return true;
            }
            Map map2 = map;
            synchronized (map2) {
                map.remove("weblogic.wsee.conversation.ConversationId");
                map.remove("weblogic.wsee.conversation.started");
                if (n == 2) {
                    map.remove("weblogic.wsee.addressing.Target");
                }
            }
        }
        return true;
    }

    public boolean handleClosure(MessageContext messageContext) {
        return this.handleResponse(messageContext);
    }
}

