/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.conversation;

import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import weblogic.store.PersistentStoreException;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.addressing.ReplyToHeader;
import weblogic.wsee.cluster.ClusterDispatcherRemote;
import weblogic.wsee.cluster.ClusterRoutingUtil;
import weblogic.wsee.cluster.ClusterServiceException;
import weblogic.wsee.cluster.CorrelationHeader;
import weblogic.wsee.conversation.ContinueHeader;
import weblogic.wsee.conversation.ConversationConstants;
import weblogic.wsee.conversation.ConversationInvokeState;
import weblogic.wsee.conversation.ConversationInvokeStateObjectHandler;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.reliability.ReliableConversationEPR;
import weblogic.wsee.reliability.SAFServerHeader;
import weblogic.wsee.server.WsStorage;
import weblogic.wsee.server.WsStorageFactory;
import weblogic.wsee.util.Verbose;

public class ConversationHandshakeHandler
extends GenericHandler {
    private static final boolean verbose = Verbose.isVerbose(ConversationHandshakeHandler.class);

    public QName[] getHeaders() {
        return ConversationConstants.CONV_HEADERS;
    }

    public boolean handleRequest(MessageContext messageContext) {
        block27: {
            Object object;
            ConversationInvokeState conversationInvokeState;
            WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
            CorrelationHeader correlationHeader = (CorrelationHeader)wlMessageContext.getHeaders().getHeader(CorrelationHeader.TYPE);
            if (correlationHeader == null) {
                return true;
            }
            WsStorage wsStorage = WsStorageFactory.getStorage("weblogic.wsee.conversation.store", new ConversationInvokeStateObjectHandler());
            try {
                conversationInvokeState = (ConversationInvokeState)wsStorage.persistentGet(correlationHeader.getCorrelationId());
                if (conversationInvokeState == null) {
                    return true;
                }
            }
            catch (PersistentStoreException persistentStoreException) {
                if (verbose) {
                    Verbose.logException(persistentStoreException);
                }
                throw new JAXRPCException((Throwable)persistentStoreException);
            }
            EndpointReference endpointReference = null;
            ReplyToHeader replyToHeader = (ReplyToHeader)wlMessageContext.getHeaders().getHeader(ReplyToHeader.TYPE);
            if (replyToHeader != null && (endpointReference = replyToHeader.getReference()) != null) {
                conversationInvokeState.setEpr(endpointReference);
            }
            boolean bl = messageContext.containsProperty("weblogic.wsee.enable.rm");
            try {
                if (bl) {
                    object = (String)messageContext.getProperty("weblogic.wsee.reliability.RequestMessageSeqID");
                    if (object != null) {
                        if (conversationInvokeState.getSeqId() == null || conversationInvokeState.getSeqId().equals("<UNKNOWN>")) {
                            if (verbose) {
                                Verbose.log("Setting sequence ID " + (String)object + " onto ConversationInvokeState at correlation id " + correlationHeader.getCorrelationId());
                            }
                            conversationInvokeState.setSeqId((String)object);
                        } else if (!((String)object).equals(conversationInvokeState.getSeqId())) {
                            throw new IllegalStateException("Found a different RM seq id than was already set on ConversationInvokeState for correlation id " + correlationHeader.getCorrelationId() + ". Old: " + conversationInvokeState.getSeqId() + " New: " + (String)object);
                        }
                    } else if (verbose) {
                        Verbose.log("!! No sequence ID " + (String)object + " found on message with Correlation header, for ConversationInfoState with correlation id " + correlationHeader.getCorrelationId());
                    }
                    wsStorage.persistentPut(correlationHeader.getCorrelationId(), conversationInvokeState);
                } else {
                    wsStorage.put(correlationHeader.getCorrelationId(), conversationInvokeState);
                }
            }
            catch (PersistentStoreException persistentStoreException) {
                if (verbose) {
                    Verbose.logException(persistentStoreException);
                }
                throw new JAXRPCException((Throwable)persistentStoreException);
            }
            if (endpointReference == null) {
                return true;
            }
            object = (SAFServerHeader)wlMessageContext.getHeaders().getHeader(SAFServerHeader.TYPE);
            if (object != null) {
                ContinueHeader continueHeader = (ContinueHeader)endpointReference.getReferenceParameters().getHeader(ContinueHeader.TYPE);
                if (continueHeader == null) {
                    return true;
                }
                String string = continueHeader.getConversationId();
                String string2 = ((SAFServerHeader)object).getServerName();
                try {
                    ClusterDispatcherRemote clusterDispatcherRemote;
                    if (verbose) {
                        Verbose.log("Dispatch Conversation (ID, Key) (" + string + ", " + ((SAFServerHeader)object).getConversationKey() + ") for " + "weblogic.wsee.reliability.conversation.msg.cluster.service" + " to " + string2);
                    }
                    if ((clusterDispatcherRemote = ClusterRoutingUtil.getClusterDispatcher(string2, "weblogic.wsee.reliability.conversation.msg.cluster.service")) != null) {
                        clusterDispatcherRemote.dispatch("weblogic.wsee.reliability.conversation.msg.cluster.service", new ReliableConversationEPR(((SAFServerHeader)object).getConversationKey(), endpointReference, conversationInvokeState.getSeqId()));
                    }
                }
                catch (ClusterServiceException clusterServiceException) {
                    if (verbose) {
                        Verbose.logException(clusterServiceException);
                    }
                }
                catch (RemoteException remoteException) {
                    if (!verbose) break block27;
                    Verbose.logException(remoteException);
                }
            }
        }
        return true;
    }
}

