/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.conversation;

import org.w3c.dom.Element;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.ToStringWriter;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public abstract class ConversationHeader
extends MsgHeader {
    private static final long serialVersionUID = 894328051313640482L;
    protected String conversationId;
    protected String callbackLocation;

    public ConversationHeader(String string, String string2) {
        this.conversationId = string;
        this.callbackLocation = string2;
    }

    public ConversationHeader(String string) {
        this.conversationId = string;
    }

    public ConversationHeader() {
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String string) {
        if (!StringUtil.isEmpty(string)) {
            throw new IllegalArgumentException("Cannot change a conversationId on the startHeader if one has already been set.");
        }
        this.conversationId = string;
    }

    public String getCallbackLocation() {
        return this.callbackLocation;
    }

    public void read(Element element) throws MsgHeaderException {
        try {
            this.conversationId = DOMUtils.getValueByTagNameNS(element, "http://www.openuri.org/2002/04/soap/conversation/", "conversationID");
            this.callbackLocation = DOMUtils.getOptionalValueByTagNameNS(element, "http://www.openuri.org/2002/04/soap/conversation/", "callbackLocation");
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new MsgHeaderException("Could not parse ContinueHeader", (Throwable)((Object)dOMProcessingException));
        }
    }

    public void write(Element element) throws MsgHeaderException {
        DOMUtils.addValueNS(element, "http://www.openuri.org/2002/04/soap/conversation/", "conv:conversationID", this.conversationId);
        if (this.callbackLocation != null) {
            DOMUtils.addValueNS(element, "http://www.openuri.org/2002/04/soap/conversation/", "conv:callbackLocation", this.callbackLocation);
        }
    }

    public void toString(ToStringWriter toStringWriter) {
        super.toString(toStringWriter);
        toStringWriter.writeField("conversationId", this.conversationId);
        toStringWriter.writeField("callbackLocation", this.callbackLocation);
    }
}

