/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.conversation;

import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.internal.SAFManagerImpl;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.server.StateExpiration;
import weblogic.wsee.util.Verbose;

public class ConversationInvokeState
implements StateExpiration {
    private EndpointReference epr;
    private long absTimeout = -1L;
    private String seqId = "<UNKNOWN>";
    private boolean rmState = false;
    private static final boolean verbose = Verbose.isVerbose(ConversationInvokeState.class);
    public static final String UNKNOWN_SEQID = "<UNKNOWN>";
    private String appVersion;
    private String appName;
    private String storeConfig;

    public void setSeqId(String string) {
        this.seqId = string;
    }

    public void setAppVersion(String string) {
        this.appVersion = string;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public void setStoreConfig(String string) {
        this.storeConfig = string;
    }

    public String getSeqId() {
        return this.seqId;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getStoreConfig() {
        return this.storeConfig;
    }

    public void setRmState(boolean bl) {
        this.rmState = bl;
    }

    public boolean isRmState() {
        return this.rmState;
    }

    public boolean isExpired() {
        if (verbose) {
            Verbose.say("CIS:isExpired called for:\n\t" + this.asString());
        }
        if (this.rmState) {
            if (verbose) {
                Verbose.say("CIS: Dealing with RM State");
            }
            if (!this.seqId.equals(UNKNOWN_SEQID)) {
                try {
                    SAFConversationInfo sAFConversationInfo;
                    if (verbose) {
                        Verbose.say("CIS RM State: offer seqID =  " + this.seqId);
                    }
                    if ((sAFConversationInfo = SAFManagerImpl.getManager().getConversationInfoOnReceivingSide(this.seqId)) == null) {
                        if (verbose) {
                            Verbose.say("CIS RM State: SAFConversationInfo for offer is null - returning true");
                        }
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    if (verbose) {
                        Verbose.say("CIS RM State: Caught exception " + throwable + " when geting conversation info for offer.\nReturning not expired");
                    }
                    return false;
                }
                if (verbose) {
                    Verbose.say("CIS RM State: Returning not expired");
                }
                return false;
            }
            if (verbose) {
                Verbose.say("CIS: RM state with no seqId: Returning not expired");
            }
            if (verbose) {
                Verbose.say("CIS RM State: Returning not expired");
            }
            return false;
        }
        if (this.absTimeout > 0L && this.absTimeout < System.currentTimeMillis()) {
            if (verbose) {
                Verbose.say("Non RM State: Timed out - returning expired");
            }
            return true;
        }
        if (verbose) {
            Verbose.say("Non RM State: Returning not expired");
        }
        return false;
    }

    public synchronized EndpointReference getEpr() {
        return this.epr;
    }

    public long getAbsTimeout() {
        return this.absTimeout;
    }

    public void setAbsTimeout(long l) {
        this.absTimeout = l;
    }

    public synchronized EndpointReference getEpr(int n) {
        if (this.epr != null) {
            return this.epr;
        }
        try {
            this.wait(n * 1000);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return this.epr;
    }

    public synchronized void setEpr(EndpointReference endpointReference) {
        this.epr = endpointReference;
        this.notify();
    }

    public String asString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ConvInvokeState: " + this);
        if (this.epr != null) {
            stringBuffer.append("\n\tEPR = " + this.epr);
        } else {
            stringBuffer.append("\n\tEPR = null");
        }
        stringBuffer.append("\n\tAbs timeout = " + this.absTimeout);
        stringBuffer.append("\n\tSequence ID = " + this.seqId);
        stringBuffer.append("\n\tRM CIS = " + this.rmState);
        stringBuffer.append("\n\tApp version = " + this.appVersion);
        return stringBuffer.toString();
    }
}

