/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.conversation;

import java.io.Serializable;
import java.util.Map;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.SOAPMessage;
import weblogic.wsee.addressing.MessageIdHeader;
import weblogic.wsee.addressing.ToHeader;
import weblogic.wsee.async.SOAPInvokeState;
import weblogic.wsee.cluster.ClusterService;
import weblogic.wsee.cluster.ClusterServiceException;
import weblogic.wsee.cluster.SerializableSOAPMessage;
import weblogic.wsee.connection.soap.SoapConnection;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.message.soap.SoapMsgHeaders;
import weblogic.wsee.server.rmi.RMISoapDispatcher;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsRegistry;

public class ConversationMsgClusterService
implements ClusterService {
    private static final boolean verbose = Verbose.isVerbose(ConversationMsgClusterService.class);
    public static final String TARGET_URI = "weblogic.wsee.conversation.msg.cluster.service";

    public String getTargetURI() {
        return TARGET_URI;
    }

    public Serializable dispatch(Serializable serializable) throws ClusterServiceException {
        if (!(serializable instanceof SOAPInvokeState)) {
            throw new ClusterServiceException("Invalid object type: " + serializable);
        }
        if (serializable == null) {
            throw new ClusterServiceException("Null object");
        }
        SOAPMessage sOAPMessage = ((SOAPInvokeState)serializable).getSOAPMessage();
        if (sOAPMessage == null) {
            throw new ClusterServiceException("Null SOAP message");
        }
        try {
            Object object;
            Object object2;
            Object object3;
            SoapMsgHeaders soapMsgHeaders = new SoapMsgHeaders(sOAPMessage);
            SOAPInvokeState sOAPInvokeState = (SOAPInvokeState)serializable;
            Map map = sOAPInvokeState.getMessageContextProperties();
            String string = sOAPInvokeState.getServiceURI();
            if (verbose) {
                object3 = (MessageIdHeader)soapMsgHeaders.getHeader(MessageIdHeader.TYPE);
                object2 = null;
                if (object3 != null) {
                    object2 = ((MessageIdHeader)object3).getMessageId();
                }
                object = (String)map.get("weblogic.wsee.conversation.ConversationId");
                Verbose.log("------------------------------");
                Verbose.log("Invoking conversation message cluster service for msg " + (String)object2 + " and conversation " + (String)object);
                Verbose.log("------------------------------");
                boolean bl = false;
                try {
                    bl = "http://www.w3.org/2003/05/soap-envelope".equals(sOAPMessage.getSOAPPart().getEnvelope().getNamespaceURI());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                SoapMessageContext soapMessageContext = new SoapMessageContext(bl);
                soapMessageContext.setMessage(sOAPMessage);
                for (Object k : map.keySet()) {
                    Object v = map.get(k);
                    soapMessageContext.setProperty((String)k, v);
                }
                SoapConnection.dumpSoapMsg(soapMessageContext, false);
            }
            if (string == null) {
                object3 = (ToHeader)soapMsgHeaders.getHeader(ToHeader.TYPE);
                if (object3 == null) {
                    throw new ClusterServiceException("Cannot find the TO WS-Addressing header");
                }
                string = ((ToHeader)object3).getAddress();
                string = string.substring(string.indexOf("/", string.indexOf("//") + 2));
            }
            if ((object3 = WsRegistry.getVersion(string)) == null && (object3 = (String)map.get("weblogic.wsee.cluster.forwarded_version")) == null) {
                object3 = (String)map.get("weblogic.wsee.version.appversion.id");
            }
            if ((object2 = WsRegistry.instance().lookup(string, (String)object3)) == null) {
                throw new JAXRPCException("No port found for " + string);
            }
            object = new RMISoapDispatcher((WsPort)object2);
            SOAPMessage sOAPMessage2 = ((RMISoapDispatcher)object).dispatch((SOAPInvokeState)serializable, string);
            if (sOAPMessage2 != null) {
                return new SerializableSOAPMessage(sOAPMessage2);
            }
            return null;
        }
        catch (MsgHeaderException msgHeaderException) {
            if (verbose) {
                Verbose.logException(msgHeaderException);
            }
            throw new ClusterServiceException(msgHeaderException);
        }
    }
}

