/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.conversation;

import java.io.Serializable;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.protocol.LocalServerIdentity;
import weblogic.wsee.addressing.AddressingProvider;
import weblogic.wsee.addressing.AddressingProviderFactory;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.addressing.ReplyToHeader;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.cluster.ServiceIdentityHeader;
import weblogic.wsee.conversation.ContinueHeader;
import weblogic.wsee.conversation.ConversationHandler;
import weblogic.wsee.conversation.ConversationPhase;
import weblogic.wsee.conversation.StartHeader;
import weblogic.wsee.handler.WLHandler;
import weblogic.wsee.jws.container.Container;
import weblogic.wsee.message.FreeStandingMsgHeaders;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.message.soap.SoapMsgHeaders;
import weblogic.wsee.util.Guid;
import weblogic.wsee.util.PathServiceUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.WLMessageFactory;
import weblogic.wsee.wsdl.WsdlBindingOperation;

public class ConversationServerHandler
extends ConversationHandler
implements WLHandler {
    private static final boolean verbose = Verbose.isVerbose(ConversationServerHandler.class);
    public static final String SERVER_ASSIGNED = "weblogic.wsee.conversation.IsServerAssigned";
    public static final String ASYNC_CONV_ID = "weblogic.wsee.conversation.AsyncConvId";
    public static final String CONV_ID_ACTION = "http://www.bea.com/wsee/ConversationId";
    public static final String CONVERSATION_ID_MSG = "weblogic.wsee.conversation.id.msg";

    public boolean handleRequest(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        ConversationPhase conversationPhase = this.getConversationPhase(wlMessageContext);
        if (conversationPhase == null || conversationPhase == ConversationPhase.NONE) {
            return true;
        }
        WsdlBindingOperation wsdlBindingOperation = wlMessageContext.getDispatcher().getBindingOperation();
        QName qName = wsdlBindingOperation.getName();
        if (verbose) {
            Verbose.log("** Handling method " + qName + " on conversation of phase: " + conversationPhase);
        }
        messageContext.setProperty("weblogic.wsee.conversation.ConversationPhase", (Object)conversationPhase);
        MsgHeaders msgHeaders = wlMessageContext.getHeaders();
        if (conversationPhase == ConversationPhase.START) {
            String string;
            ContinueHeader continueHeader = (ContinueHeader)msgHeaders.getHeader(ContinueHeader.TYPE);
            if (continueHeader != null) {
                throw new JAXRPCException("Cannot invoke start method ('" + qName + "') when conversation has already started.");
            }
            StartHeader startHeader = (StartHeader)msgHeaders.getHeader(StartHeader.TYPE);
            if (verbose && startHeader != null) {
                Verbose.log("Received StartHeader " + startHeader);
            }
            if (startHeader == null || StringUtil.isEmpty(startHeader.getConversationId())) {
                string = Guid.generateGuid();
                if (verbose) {
                    Verbose.log("Conversation server assigning conversation ID: " + string);
                }
                if (wlMessageContext.getDispatcher().getOperation().getType() != 0 || !"true".equals(messageContext.getProperty("weblogic.wsee.reply.anonymous"))) {
                    messageContext.setProperty(ASYNC_CONV_ID, (Object)"true");
                }
                messageContext.setProperty(SERVER_ASSIGNED, (Object)Boolean.TRUE);
                messageContext.setProperty("weblogic.wsee.conversation.ConversationId", (Object)string);
            } else if (!Boolean.TRUE.equals(messageContext.getProperty("weblogic.wsee.handler.wlw81BufferCompatFlat")) || !Boolean.TRUE.equals(messageContext.getProperty(SERVER_ASSIGNED))) {
                if (verbose) {
                    Verbose.log("Received 8.1 style: conversation id =  " + startHeader.getConversationId());
                }
                try {
                    PathServiceUtil.saveConversationIdMapping(startHeader.getConversationId());
                }
                catch (Throwable throwable) {
                    new JAXRPCException("Failed to access routing info from path service for method " + qName + " on conversation " + startHeader.getConversationId(), throwable);
                }
                messageContext.setProperty("weblogic.wsee.conversation.ConversationId", (Object)startHeader.getConversationId());
            }
            string = ApplicationVersionUtils.getCurrentVersionId();
            if (string != null) {
                messageContext.setProperty("weblogic.wsee.version.appversion.id", (Object)string);
            }
        } else {
            String string;
            ContinueHeader continueHeader = (ContinueHeader)msgHeaders.getHeader(ContinueHeader.TYPE);
            if (continueHeader == null) {
                throw new JAXRPCException("Incoming message for a " + conversationPhase + " operation ('" + qName + "') does not contain a ContinueHeader");
            }
            if (verbose) {
                Verbose.log("Received ContinueHeader for conversation " + continueHeader.getConversationId() + " hosted by server " + continueHeader.getServerName() + ": " + continueHeader.toString());
            }
            if ((string = continueHeader.getAppVersionId()) != null) {
                messageContext.setProperty("weblogic.wsee.version.appversion.id", (Object)string);
            }
            messageContext.setProperty("weblogic.wsee.conversation.ConversationId", (Object)continueHeader.getConversationId());
            messageContext.setProperty(SERVER_ASSIGNED, (Object)new Boolean(continueHeader.isServerAssigned()));
        }
        if (verbose) {
            Verbose.log("Leaving conversation server handleRequest with conversation ID: " + messageContext.getProperty("weblogic.wsee.conversation.ConversationId"));
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        ConversationPhase conversationPhase = (ConversationPhase)messageContext.getProperty("weblogic.wsee.conversation.ConversationPhase");
        if (conversationPhase == null || conversationPhase == ConversationPhase.NONE || conversationPhase == ConversationPhase.CONTINUE) {
            return true;
        }
        Container container = AsyncUtil.getContainer(messageContext);
        assert (container != null);
        if (conversationPhase == ConversationPhase.START && !container.isFinished()) {
            this.addContinueHeader(wlMessageContext);
        }
        return true;
    }

    protected void addContinueHeader(WlMessageContext wlMessageContext) {
        Serializable serializable;
        ReplyToHeader replyToHeader = (ReplyToHeader)wlMessageContext.getHeaders().getHeader(ReplyToHeader.TYPE);
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(wlMessageContext);
        String string = (String)wlMessageContext.getProperty("weblogic.wsee.addressing.To");
        if (replyToHeader == null) {
            serializable = addressingProvider.createEndpointReference(string);
            replyToHeader = addressingProvider.createReplyToHeader((EndpointReference)serializable);
        } else if (addressingProvider.isAnonymousReferenceURI(replyToHeader.getReference().getAddress())) {
            replyToHeader.getReference().setAddress(string);
        }
        if (replyToHeader.getReference().getReferenceParameters().getHeader(ServiceIdentityHeader.TYPE) == null) {
            serializable = new ServiceIdentityHeader();
            ((ServiceIdentityHeader)serializable).setServerName(LocalServerIdentity.getIdentity().getServerName());
            ((ServiceIdentityHeader)serializable).setServiceName("weblogic.wsee.conversation.msg.cluster.service");
            replyToHeader.getReference().getReferenceParameters().addHeader((MsgHeader)serializable);
        }
        if ((serializable = (Boolean)wlMessageContext.getProperty(SERVER_ASSIGNED)) != null && ((Boolean)serializable).booleanValue() && replyToHeader.getReference().getReferenceParameters().getHeader(ContinueHeader.TYPE) == null) {
            String string2 = (String)wlMessageContext.getProperty("weblogic.wsee.conversation.ConversationId");
            String string3 = ApplicationVersionUtils.getCurrentVersionId();
            if (verbose) {
                Verbose.log("Adding conv version " + string3);
            }
            ContinueHeader continueHeader = new ContinueHeader(string2, LocalServerIdentity.getIdentity().getServerName(), string3);
            replyToHeader.getReference().getReferenceParameters().addHeader(continueHeader);
        }
        ((SoapMsgHeaders)wlMessageContext.getHeaders()).replaceHeader(replyToHeader);
    }

    public boolean handleClosure(MessageContext messageContext) {
        if (!messageContext.containsProperty(ASYNC_CONV_ID)) {
            return true;
        }
        if (((WlMessageContext)messageContext).hasFault()) {
            return true;
        }
        this.constructMessage(messageContext);
        return true;
    }

    private void constructMessage(MessageContext messageContext) {
        Object object;
        Object object2;
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        try {
            object2 = WLMessageFactory.getInstance().getMessageFactory(((SoapMessageContext)wlMessageContext).isSoap12());
            object = object2.createMessage();
            sOAPMessageContext.setMessage(object);
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException((Throwable)sOAPException);
        }
        object2 = (EndpointReference)messageContext.getProperty("weblogic.wsee.addressing.ReplyTo");
        object = (String)messageContext.getProperty("weblogic.wsee.addressing.To");
        String string = (String)messageContext.getProperty("weblogic.wsee.conversation.ConversationId");
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(messageContext);
        EndpointReference endpointReference = addressingProvider.createEndpointReference();
        FreeStandingMsgHeaders freeStandingMsgHeaders = new FreeStandingMsgHeaders();
        String string2 = ApplicationVersionUtils.getCurrentVersionId();
        if (verbose) {
            Verbose.log("Adding conv version " + string2);
        }
        ContinueHeader continueHeader = new ContinueHeader(string, LocalServerIdentity.getIdentity().getServerName(), string2);
        ServiceIdentityHeader serviceIdentityHeader = new ServiceIdentityHeader();
        serviceIdentityHeader.setServerName(LocalServerIdentity.getIdentity().getServerName());
        serviceIdentityHeader.setServiceName("weblogic.wsee.conversation.msg.cluster.service");
        freeStandingMsgHeaders.addHeader(continueHeader);
        freeStandingMsgHeaders.addHeader(serviceIdentityHeader);
        endpointReference.setAddress((String)object);
        endpointReference.setReferenceParameters(freeStandingMsgHeaders);
        messageContext.setProperty("javax.xml.rpc.service.endpoint.address", (Object)((EndpointReference)object2).getAddress());
        Iterator iterator = ((EndpointReference)object2).getReferenceProperties().listHeaders();
        while (iterator.hasNext()) {
            wlMessageContext.getHeaders().addHeader((MsgHeader)iterator.next());
        }
        iterator = ((EndpointReference)object2).getReferenceParameters().listHeaders();
        while (iterator.hasNext()) {
            wlMessageContext.getHeaders().addHeader((MsgHeader)iterator.next());
        }
        wlMessageContext.getHeaders().addHeader(addressingProvider.createToHeader(((EndpointReference)object2).getAddress()));
        wlMessageContext.getHeaders().addHeader(addressingProvider.createReplyToHeader(endpointReference));
        wlMessageContext.getHeaders().addHeader(addressingProvider.createActionHeader(CONV_ID_ACTION));
        ((SOAPMessageContext)wlMessageContext).getMessage().getMimeHeaders().setHeader("SOAPAction", CONV_ID_ACTION);
        wlMessageContext.getHeaders().addHeader(addressingProvider.createMessageIdHeader(Guid.generateGuid()));
        wlMessageContext.setProperty(CONVERSATION_ID_MSG, "true");
    }
}

