/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.conversation;

import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Stub;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.store.PersistentStoreException;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.cluster.ServiceIdentityHeader;
import weblogic.wsee.conversation.ContinueHeader;
import weblogic.wsee.conversation.ConversationIdNotYetAvailableException;
import weblogic.wsee.conversation.ConversationInvokeState;
import weblogic.wsee.conversation.ConversationInvokeStateObjectHandler;
import weblogic.wsee.conversation.wsdl.ConversationWsdlPhase;
import weblogic.wsee.jaxrpc.WLStub;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.server.WsStorage;
import weblogic.wsee.server.WsStorageFactory;
import weblogic.wsee.util.ControlAPIUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingOperation;

public class ConversationUtils {
    private static final boolean verbose = Verbose.isVerbose(ConversationUtils.class);
    public static final String SERVER_NAME = "serverName";
    public static final String CONVERSATION_ID = "conversationId";

    public static String getConversationId(Stub stub) throws ConversationIdNotYetAvailableException {
        if (stub == null) {
            throw new JAXRPCException("Stub is null");
        }
        String string = (String)stub._getProperty("weblogic.wsee.conversation.ConversationId");
        if (string != null) {
            return string;
        }
        Map map = (Map)stub._getProperty("weblogic.wsee.invoke_properties");
        if (map == null) {
            return null;
        }
        string = (String)map.get("weblogic.wsee.conversation.ConversationId");
        if (string != null) {
            return string;
        }
        if (map.get("weblogic.wsee.conversation.started") == null) {
            return null;
        }
        String string2 = (String)map.get("weblogic.wsee.conversation.correlation.id");
        if (string2 != null) {
            WsStorage wsStorage = WsStorageFactory.getStorage("weblogic.wsee.conversation.store", new ConversationInvokeStateObjectHandler());
            ConversationInvokeState conversationInvokeState = null;
            try {
                conversationInvokeState = (ConversationInvokeState)wsStorage.persistentGet(string2);
                if (conversationInvokeState == null) {
                    throw new JAXRPCException("Internal error: cannot get conversation state.");
                }
            }
            catch (PersistentStoreException persistentStoreException) {
                throw new JAXRPCException("Internal error: error getting conversation state", (Throwable)persistentStoreException);
            }
            EndpointReference endpointReference = conversationInvokeState.getEpr();
            if (endpointReference != null) {
                ContinueHeader continueHeader = (ContinueHeader)endpointReference.getReferenceParameters().getHeader(ContinueHeader.TYPE);
                if (continueHeader == null) {
                    continueHeader = (ContinueHeader)endpointReference.getReferenceProperties().getHeader(ContinueHeader.TYPE);
                }
                if (continueHeader != null) {
                    return continueHeader.getConversationId();
                }
            }
        }
        throw new ConversationIdNotYetAvailableException("Conversation ID assigned by server has not yet reached the client.  Please wait and invoke this method later.");
    }

    public static void setConversationId(Stub stub, String string) {
        if (stub == null) {
            throw new JAXRPCException("Stub is null");
        }
        stub._setProperty("weblogic.wsee.conversation.ConversationId", (Object)string);
    }

    public static void setConversationVersionOne(Stub stub) {
        if (stub == null) {
            throw new JAXRPCException("Stub is null");
        }
        stub._setProperty("weblogic.wsee.conversation.ConversationVersion", (Object)WLStub.CONVERSATION_VERSION_ONE);
    }

    public static void setConversationVersionTwo(Stub stub) {
        if (stub == null) {
            throw new JAXRPCException("Stub is null");
        }
        stub._setProperty("weblogic.wsee.conversation.ConversationVersion", (Object)WLStub.CONVERSATION_VERSION_TWO);
    }

    public static Integer getConversationVersion(Stub stub) {
        if (stub == null) {
            throw new JAXRPCException("Stub is null");
        }
        Integer n = (Integer)stub._getProperty("weblogic.wsee.conversation.ConversationVersion");
        if (n == null) {
            n = WLStub.CONVERSATION_VERSION_TWO;
        }
        return n;
    }

    public static void setConversationMethodBlockTimeout(Stub stub, int n) {
        if (stub == null) {
            throw new JAXRPCException("Stub is null");
        }
        stub._setProperty("weblogic.wsee.conversation.method.block.timeout", (Object)new Integer(n));
    }

    public static int getConversationMethodBlockTimeout(Stub stub) {
        if (stub == null) {
            throw new JAXRPCException("Stub is null");
        }
        Integer n = (Integer)stub._getProperty("weblogic.wsee.conversation.method.block.timeout");
        if (n == null) {
            return 120;
        }
        return n;
    }

    public static boolean isConversational(WsPort wsPort) {
        boolean bl = ConversationUtils.isConversational(wsPort.getWsdlPort().getBinding());
        if (bl && verbose) {
            Verbose.log(wsPort.getWsdlPort().getName() + " is conversational");
        }
        return bl;
    }

    public static boolean isConversational(WsdlBinding wsdlBinding) {
        for (WsdlBindingOperation wsdlBindingOperation : wsdlBinding.getOperations().values()) {
            if (ConversationWsdlPhase.narrow(wsdlBindingOperation) == null) continue;
            return true;
        }
        return false;
    }

    public static String getConversationAppVersion(WlMessageContext wlMessageContext) {
        ContinueHeader continueHeader;
        MsgHeaders msgHeaders;
        String string = (String)wlMessageContext.getProperty("weblogic.wsee.version.appversion.id");
        if (string == null && (msgHeaders = wlMessageContext.getHeaders()) != null && (continueHeader = (ContinueHeader)msgHeaders.getHeader(ContinueHeader.TYPE)) != null) {
            string = continueHeader.getAppVersionId();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renewStub(Stub stub) {
        Map map = (Map)stub._getProperty("weblogic.wsee.invoke_properties");
        assert (map != null);
        Map map2 = map;
        synchronized (map2) {
            map.remove("weblogic.wsee.conversation.ConversationId");
            map.remove("weblogic.wsee.conversation.started");
            map.remove("weblogic.wsee.conversation.key");
            map.remove("weblogic.wsee.conversation.epr.set");
            map.remove("weblogic.wsee.conversation.correlation.id");
            map.remove("weblogic.wsee.addressing.Target");
        }
    }

    public static void continueConversation(Stub stub, Map map) {
        String string = (String)map.get(CONVERSATION_ID);
        if (string == null) {
            throw new JAXRPCException("No conversation id specified");
        }
        String string2 = (String)map.get(SERVER_NAME);
        if (string2 == null) {
            throw new JAXRPCException("No server name specified");
        }
        stub._setProperty("weblogic.wsee.complex", (Object)"true");
        stub._setProperty("weblogic.wsee.conversation.ConversationId", (Object)string);
        stub._setProperty("weblogic.wsee.conversation.started", (Object)Boolean.TRUE);
        ServiceIdentityHeader serviceIdentityHeader = new ServiceIdentityHeader();
        serviceIdentityHeader.setServerName(string2);
        serviceIdentityHeader.setServiceName("weblogic.wsee.conversation.msg.cluster.service");
        ContinueHeader continueHeader = new ContinueHeader(string, string2, null);
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JAXRPCException((Throwable)parserConfigurationException);
        }
        Element element = document.createElementNS(ContinueHeader.NAME.getNamespaceURI(), ContinueHeader.NAME.getPrefix() + ":" + ContinueHeader.NAME.getLocalPart());
        continueHeader.write(element);
        Element element2 = document.createElementNS(ServiceIdentityHeader.NAME.getNamespaceURI(), ServiceIdentityHeader.NAME.getPrefix() + ":" + ServiceIdentityHeader.NAME.getLocalPart());
        serviceIdentityHeader.write(element2);
        Element[] elementArray = new Element[]{element, element2};
        ControlAPIUtil.setOutputHeaders(stub, elementArray);
    }
}

