/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.conversation;

import java.util.HashMap;
import java.util.concurrent.Semaphore;
import weblogic.wsee.util.Verbose;

public class LockManager {
    private static LockManager instance = new LockManager();
    private final HashMap<String, Lock> locks = new HashMap();
    private static final boolean verbose = Verbose.isVerbose(LockManager.class);

    private LockManager() {
    }

    public static LockManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock lock(String string) throws InterruptedException {
        Lock lock;
        if (verbose) {
            Verbose.log("Attempting to lock conversation " + string);
        }
        HashMap<String, Lock> hashMap = this.locks;
        synchronized (hashMap) {
            lock = this.locks.get(string);
            if (lock == null) {
                lock = new Lock(string);
                this.locks.put(string, lock);
            }
        }
        lock.s.acquire();
        if (verbose) {
            Verbose.log("Successfully locked conversation " + string);
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(String string) {
        HashMap<String, Lock> hashMap = this.locks;
        synchronized (hashMap) {
            this.locks.remove(string);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        final LockManager lockManager = new LockManager();
        Runnable runnable = new Runnable(){
            private int count = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void run() {
                try {
                    while (true) {
                        Lock lock = lockManager.lock("1");
                        System.out.println("lock free");
                        Class<Runnable> clazz = Runnable.class;
                        // MONITORENTER : java.lang.Runnable.class
                        ++this.count;
                        if (this.count > 1) {
                            throw new IllegalStateException();
                        }
                        // MONITOREXIT : clazz
                        Thread.sleep(5L);
                        clazz = Runnable.class;
                        // MONITORENTER : java.lang.Runnable.class
                        --this.count;
                        lock.release();
                        System.out.println("released");
                        // MONITOREXIT : clazz
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    return;
                }
            }
        };
        Thread thread2 = new Thread(runnable);
        Thread thread3 = new Thread(runnable);
        Thread thread4 = new Thread(runnable);
        thread2.start();
        thread3.start();
        thread4.start();
    }

    public class Lock {
        private String id;
        private Semaphore s = new Semaphore(1, true);

        public Lock() {
        }

        public Lock(String string) {
            this.id = string;
        }

        public synchronized void release() {
            if (verbose) {
                Verbose.log("Releasing lock on conversation " + this.id);
            }
            this.s.release();
        }
    }
}

