/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.deploy;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import weblogic.application.AppDeploymentExtension;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.internal.ApplicationContextImpl;
import weblogic.management.DeploymentException;
import weblogic.wsee.deploy.WSEEModule;
import weblogic.wsee.util.Pair;

public class AppDeploymentExtensionFactory
implements weblogic.application.AppDeploymentExtensionFactory {
    public static final AppDeploymentExtensionFactory INSTANCE = new AppDeploymentExtensionFactory();
    private Map<ApplicationContext, Pair<Collection<WSEEModule>, State>> modules = new ConcurrentHashMap<ApplicationContext, Pair<Collection<WSEEModule>, State>>();

    private AppDeploymentExtensionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addModule(ApplicationContext applicationContext, WSEEModule wSEEModule) throws DeploymentException {
        Object object;
        Pair<Collection<WSEEModule>, State> pair = this.modules.get(applicationContext);
        if (pair == null) {
            object = State.NOT_PREPARED;
            if (((ApplicationContextImpl)applicationContext).getPartialRedeployURIs() != null) {
                object = State.PREPARED;
            }
            pair = new Pair(new ConcurrentLinkedQueue(), (State)((Object)object));
            this.modules.put(applicationContext, pair);
        }
        object = pair;
        synchronized (object) {
            switch (pair.getRight()) {
                case PREPARED: {
                    this.prepare(wSEEModule);
                    break;
                }
                case ACTIVE: {
                    this.prepare_and_activate(wSEEModule);
                }
            }
            pair.getLeft().add(wSEEModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeModule(ApplicationContext applicationContext, WSEEModule wSEEModule) throws DeploymentException {
        Pair<Collection<WSEEModule>, State> pair = this.modules.get(applicationContext);
        if (pair != null) {
            Pair<Collection<WSEEModule>, State> pair2 = pair;
            synchronized (pair2) {
                if (pair.getLeft().remove(wSEEModule)) {
                    switch (pair.getRight()) {
                        case PREPARED: {
                            this.unprepare(wSEEModule);
                            break;
                        }
                        case ACTIVE: {
                            this.deactivate_and_unprepare(wSEEModule);
                        }
                    }
                }
                if (pair.getLeft().isEmpty()) {
                    this.modules.remove(applicationContext);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare(WSEEModule wSEEModule) throws DeploymentException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = wSEEModule.getClassLoader();
        boolean bl = false;
        if (classLoader != classLoader2) {
            Thread.currentThread().setContextClassLoader(classLoader2);
            bl = true;
        }
        try {
            wSEEModule.prepare();
        }
        finally {
            if (bl) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare_and_activate(WSEEModule wSEEModule) throws DeploymentException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = wSEEModule.getClassLoader();
        boolean bl = false;
        if (classLoader != classLoader2) {
            Thread.currentThread().setContextClassLoader(classLoader2);
            bl = true;
        }
        try {
            wSEEModule.prepare();
            wSEEModule.activate();
        }
        finally {
            if (bl) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activate(WSEEModule wSEEModule) throws DeploymentException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = wSEEModule.getClassLoader();
        boolean bl = false;
        if (classLoader != classLoader2) {
            Thread.currentThread().setContextClassLoader(classLoader2);
            bl = true;
        }
        try {
            wSEEModule.activate();
        }
        finally {
            if (bl) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivate(WSEEModule wSEEModule) throws DeploymentException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = wSEEModule.getClassLoader();
        boolean bl = false;
        if (classLoader != classLoader2) {
            Thread.currentThread().setContextClassLoader(classLoader2);
            bl = true;
        }
        try {
            wSEEModule.deactivate();
        }
        finally {
            if (bl) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivate_and_unprepare(WSEEModule wSEEModule) throws DeploymentException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = wSEEModule.getClassLoader();
        boolean bl = false;
        if (classLoader != classLoader2) {
            Thread.currentThread().setContextClassLoader(classLoader2);
            bl = true;
        }
        try {
            wSEEModule.deactivate();
            wSEEModule.destroy();
        }
        finally {
            if (bl) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unprepare(WSEEModule wSEEModule) throws DeploymentException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = wSEEModule.getClassLoader();
        boolean bl = false;
        if (classLoader != classLoader2) {
            Thread.currentThread().setContextClassLoader(classLoader2);
            bl = true;
        }
        try {
            wSEEModule.destroy();
        }
        finally {
            if (bl) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    public AppDeploymentExtension createPostProcessorExtension() {
        return new AppDeploymentExtension(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void activate(ApplicationContextInternal applicationContextInternal) throws DeploymentException {
                Pair pair = (Pair)AppDeploymentExtensionFactory.this.modules.get(applicationContextInternal);
                if (pair != null) {
                    Pair pair2 = pair;
                    synchronized (pair2) {
                        if (pair.getRight() == State.NOT_PREPARED) {
                            pair.setRight(State.PREPARED);
                            for (WSEEModule wSEEModule : (Collection)pair.getLeft()) {
                                AppDeploymentExtensionFactory.this.prepare(wSEEModule);
                            }
                        }
                        pair.setRight(State.ACTIVE);
                        for (WSEEModule wSEEModule : (Collection)pair.getLeft()) {
                            AppDeploymentExtensionFactory.this.activate(wSEEModule);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void deactivate(ApplicationContextInternal applicationContextInternal) throws DeploymentException {
                Pair pair = (Pair)AppDeploymentExtensionFactory.this.modules.get(applicationContextInternal);
                if (pair != null) {
                    Pair pair2 = pair;
                    synchronized (pair2) {
                        pair.setRight(State.PREPARED);
                        for (WSEEModule wSEEModule : (Collection)pair.getLeft()) {
                            AppDeploymentExtensionFactory.this.deactivate(wSEEModule);
                        }
                    }
                }
            }

            public String getName() {
                return AppDeploymentExtension.class.getName();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void prepare(ApplicationContextInternal applicationContextInternal) throws DeploymentException {
                Pair pair = (Pair)AppDeploymentExtensionFactory.this.modules.get(applicationContextInternal);
                if (pair != null) {
                    Pair pair2 = pair;
                    synchronized (pair2) {
                        pair.setRight(State.PREPARED);
                        for (WSEEModule wSEEModule : (Collection)pair.getLeft()) {
                            AppDeploymentExtensionFactory.this.prepare(wSEEModule);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void unprepare(ApplicationContextInternal applicationContextInternal) throws DeploymentException {
                Pair pair = (Pair)AppDeploymentExtensionFactory.this.modules.remove(applicationContextInternal);
                if (pair != null) {
                    Pair pair2 = pair;
                    synchronized (pair2) {
                        pair.setRight(State.NOT_PREPARED);
                        for (WSEEModule wSEEModule : (Collection)pair.getLeft()) {
                            AppDeploymentExtensionFactory.this.unprepare(wSEEModule);
                        }
                    }
                }
            }

            public void init(ApplicationContextInternal applicationContextInternal) {
            }
        };
    }

    public AppDeploymentExtension createPreProcessorExtension() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NOT_PREPARED,
        PREPARED,
        ACTIVE;

    }
}

