/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.deploy;

import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceProvider;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.ejb.spi.DynamicEJBModule;
import weblogic.j2ee.ComponentRuntimeMBeanImpl;
import weblogic.j2ee.J2EEApplicationRuntimeMBeanImpl;
import weblogic.j2ee.descriptor.JavaWsdlMappingBean;
import weblogic.j2ee.descriptor.wl.PortComponentBean;
import weblogic.j2ee.descriptor.wl.WebservicePolicyRefBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.buffer.BufferManager;
import weblogic.wsee.jaxws.handler.BindingIdTranslator;
import weblogic.wsee.jaxws.handler.ServerHandlerChainsResolver;
import weblogic.wsee.jaxws.injection.WSEEComponentContributor;
import weblogic.wsee.jaxws.tubeline.standard.ClientContainerUtil;
import weblogic.wsee.monitoring.WseeRuntimeMBeanManager;
import weblogic.wsee.policy.deployment.WsdlPolicySubject;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsRegistry;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlImport;
import weblogic.wsee.wsdl.WsdlPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeployInfo {
    static boolean verbose = Verbose.isVerbose(DeployInfo.class);
    public static final String CATALOG = "jax-ws-catalog.xml";
    private JavaWsdlMappingBean mappingdd;
    private WsdlDefinitions wsdlDef;
    private weblogic.j2ee.descriptor.PortComponentBean portComp;
    private WebservicePolicyRefBean wpr;
    private PortComponentBean wlPortComp;
    private Class jwsClass;
    private WsdlPolicySubject policySubject;
    private String wssConfigMBeanName;
    private WssPolicyContext wssPolicyCtx;
    private List<DynamicEJBModule> dynamicEjbs;
    private List<String> bufferTargetURIs;
    private ApplicationContextInternal applicationCtx;
    private String contextPath = null;
    private String application = null;
    private String securityRealmName = null;
    private String serviceName;
    private String wdName = null;
    private WebServiceType webServicesType = null;
    private String version = null;
    protected String linkName = null;
    protected String moudleName = null;
    protected ServletContext servletContext;
    protected String[] serviceURIs;
    private ServletAdapterList adpaterList;
    private ServerHandlerChainsResolver handlerChainsResolver;

    protected DeployInfo() {
    }

    WebServiceType getWebServicesType() {
        if (this.webServicesType != null) {
            return this.webServicesType;
        }
        if (this.getJwsClass().getAnnotation(WebService.class) == null && this.getJwsClass().getAnnotation(WebServiceProvider.class) == null) {
            return WebServiceType.JAXRPC;
        }
        return WebServiceType.JAXWS;
    }

    void setWebServicesType(WebServiceType webServiceType) {
        this.webServicesType = webServiceType;
    }

    public List<DynamicEJBModule> getDynamicEjbs() {
        return this.dynamicEjbs;
    }

    public void setDynamicEjbs(List<DynamicEJBModule> list) {
        this.dynamicEjbs = list;
    }

    public List<String> getBufferTargetURIs() {
        return this.bufferTargetURIs;
    }

    public void setBufferTargetURIs(List<String> list) {
        this.bufferTargetURIs = list;
    }

    public JavaWsdlMappingBean getMappingdd() {
        return this.mappingdd;
    }

    void setMappingdd(JavaWsdlMappingBean javaWsdlMappingBean) {
        this.mappingdd = javaWsdlMappingBean;
    }

    public weblogic.j2ee.descriptor.PortComponentBean getPortComp() {
        return this.portComp;
    }

    void setPortComp(weblogic.j2ee.descriptor.PortComponentBean portComponentBean) {
        this.portComp = portComponentBean;
    }

    public WebservicePolicyRefBean getPolicyRef() {
        return this.wpr;
    }

    void setPolicyRef(WebservicePolicyRefBean webservicePolicyRefBean) {
        this.wpr = webservicePolicyRefBean;
    }

    public PortComponentBean getWlPortComp() {
        return this.wlPortComp;
    }

    void setWlPortComp(PortComponentBean portComponentBean) {
        this.wlPortComp = portComponentBean;
    }

    public WsdlDefinitions getWsdlDef() {
        return this.wsdlDef;
    }

    void setWsdlDef(WsdlDefinitions wsdlDefinitions) {
        this.wsdlDef = wsdlDefinitions;
        if (wsdlDefinitions != null) {
            this.policySubject = new WsdlPolicySubject(wsdlDefinitions);
        }
    }

    void setJwsClass(Class clazz) {
        this.jwsClass = clazz;
    }

    public Class getJwsClass() {
        return this.jwsClass;
    }

    public RuntimeMBean getParentRuntimeMBean() {
        return this.applicationCtx.getRuntime();
    }

    public void setWssConfigMBeanName(String string) {
        this.wssConfigMBeanName = string;
    }

    String getWssConfigMBeanName() {
        return this.wssConfigMBeanName;
    }

    void setWssPolicyContext(WssPolicyContext wssPolicyContext) {
        this.wssPolicyCtx = wssPolicyContext;
        if (this.policySubject != null) {
            this.wssPolicyCtx.getPolicyServer().addPolicies(this.policySubject.getPolicies());
        }
    }

    public WssPolicyContext getWssPolicyContext() {
        return this.wssPolicyCtx;
    }

    public String getContextPath() {
        if (this.contextPath == null) {
            if (this.servletContext instanceof WebAppServletContext) {
                return ((WebAppServletContext)this.servletContext).getContextPath();
            }
            throw new AssertionError((Object)"Unable to determine ContextPath from ServletContext");
        }
        return this.contextPath;
    }

    void setContextPath(String string) {
        this.contextPath = string;
    }

    public String getApplication() {
        return this.application;
    }

    void setApplication(String string) {
        this.application = string;
    }

    public String getSecurityRealmName() {
        return this.securityRealmName;
    }

    void setSecurityRealmName(String string) {
        this.securityRealmName = string;
    }

    void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    void setWebServiceDescriptionName(String string) {
        this.wdName = string;
    }

    public String getWebserviceDescriptionName() {
        return this.wdName;
    }

    void setApplicationContext(ApplicationContext applicationContext) {
        if (applicationContext instanceof ApplicationContextInternal) {
            this.applicationCtx = (ApplicationContextInternal)applicationContext;
        }
    }

    public ApplicationContextInternal getApplicationContext() {
        return this.applicationCtx;
    }

    public WsdlPolicySubject gePolicySubject() {
        return this.policySubject;
    }

    public NormalizedExpression getEndpointPolicy() throws PolicyException {
        QName qName = new QName(this.wsdlDef.getTargetNamespace(), this.serviceName);
        WsdlPort wsdlPort = this.wsdlDef.getPorts().get(qName);
        if (wsdlPort == null) {
            wsdlPort = this.getPortFromImportedDefinition(this.wsdlDef, this.wsdlDef.getImports(), this.serviceName);
        }
        return this.wssPolicyCtx.getPolicyServer().getEndpointPolicy(wsdlPort);
    }

    private WsdlPort getPortFromImportedDefinition(WsdlDefinitions wsdlDefinitions, List<? extends WsdlImport> list, String string) throws PolicyException {
        for (WsdlImport wsdlImport : list) {
            QName qName = new QName(wsdlImport.getNamespace(), string);
            WsdlPort wsdlPort = wsdlDefinitions.getPorts().get(qName);
            if (wsdlPort == null) continue;
            return wsdlPort;
        }
        throw new PolicyException("Fail to find port(" + string + ") from wsdl " + wsdlDefinitions.getWsdlLocation());
    }

    public String[] getServiceURIs() {
        return this.serviceURIs;
    }

    abstract WsService createWsService() throws WsException;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public ServletAdapterList getAdpaterList() {
        return this.adpaterList;
    }

    public void setAdpaterList(ServletAdapterList servletAdapterList) {
        this.adpaterList = servletAdapterList;
    }

    public void validate() throws WsException {
        if (verbose) {
            Verbose.log(this.toString());
        }
        if (this.serviceURIs == null) {
            throw new WsException("No Service URI specifed.");
        }
        if (this.getJwsClass().getPackage() == null) {
            throw new WsException("A jws [" + this.getJwsClass() + "] should have a package declaration.");
        }
        if (this.getWebServicesType() == WebServiceType.JAXRPC) {
            if (this.mappingdd == null) {
                throw new WsException("Required JAXRPC mapping file not found.");
            }
            if (this.wsdlDef == null) {
                throw new WsException("Required WSDL file entry in webservices.xml not found.");
            }
        }
    }

    public WsPort createWsPort() throws WsException {
        this.validate();
        WsService wsService = this.createWsService();
        WsPort wsPort = wsService.getPorts().next();
        WsRegistry wsRegistry = WsRegistry.instance();
        String[] stringArray = this.getServiceURIs();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = AsyncUtil.calculateServiceTargetURI(this.getContextPath(), stringArray[i]);
            wsRegistry.unregisterMBean(string, this.getVersion());
            wsRegistry.register(string, this.getVersion(), wsPort);
            stringBuilder.append(string);
            if (i + 1 >= stringArray.length) continue;
            stringBuilder.append(";");
        }
        String string = stringBuilder.toString();
        this.createMBean(wsService, string, this.getApplication(), this.getVersion());
        return wsPort;
    }

    public String getUri() {
        String[] stringArray = this.getServiceURIs();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(this.getContextPath());
            stringBuilder.append(stringArray[i]);
            if (i + 1 >= stringArray.length) continue;
            stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    private void createMBean(WsService wsService, String string, String string2, String string3) {
        try {
            WebAppServletContext webAppServletContext = (WebAppServletContext)this.servletContext;
            ApplicationContextInternal applicationContextInternal = webAppServletContext.getApplicationContext();
            J2EEApplicationRuntimeMBeanImpl j2EEApplicationRuntimeMBeanImpl = applicationContextInternal.getRuntime();
            String string4 = this.getModuleName();
            ComponentRuntimeMBeanImpl componentRuntimeMBeanImpl = ClientContainerUtil.getContainingComponentRuntimeByModuleName(string4);
            WseeRuntimeMBeanManager.createJaxRpcMBean(j2EEApplicationRuntimeMBeanImpl, componentRuntimeMBeanImpl, wsService, this, this.getWebserviceDescriptionName(), string, string2, string3);
        }
        catch (Throwable throwable) {
            Verbose.log(throwable);
        }
    }

    public void clean() {
        Object object;
        Iterator<String> iterator;
        if (this.getDynamicEjbs() != null) {
            iterator = this.getDynamicEjbs().iterator();
            while (iterator.hasNext()) {
                object = (String[])iterator.next();
                object.undeployDynamicEJB();
            }
            if (verbose) {
                Verbose.log("Undeployed dynamic MDBs");
            }
        }
        if (this.getBufferTargetURIs() != null) {
            iterator = this.getBufferTargetURIs().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (verbose) {
                    Verbose.log("Removed listener at: " + (String)object);
                }
                BufferManager.instance().removeMessageListener((String)object);
                BufferManager.instance().removeErrorListener((String)object);
                BufferManager.instance().removeRetryDelay((String)object);
            }
        }
        if ((iterator = this.getWssPolicyContext()) != null) {
            ((WssPolicyContext)((Object)iterator)).getWssConfiguration().destroy();
        }
        if ((object = this.getServiceURIs()) != null) {
            WsRegistry wsRegistry = WsRegistry.instance();
            for (String string : object) {
                wsRegistry.unregister(this.getContextPath() + string, this.getVersion());
            }
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public URL getCatalog() throws MalformedURLException {
        return this.getResource("/jax-ws-catalog.xml");
    }

    public URL getResource(String string) throws MalformedURLException {
        return this.servletContext.getResource(string);
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void setLinkName(String string) {
        this.linkName = string;
    }

    abstract String getServlet();

    abstract ServletAdapterList createServletAdapterList();

    public abstract InstanceResolver createInstanceResolver();

    public ServerHandlerChainsResolver createServerHandlerChainsResolver() {
        if (this.handlerChainsResolver == null) {
            weblogic.j2ee.descriptor.PortComponentBean portComponentBean = this.getPortComp();
            this.handlerChainsResolver = new ServerHandlerChainsResolver(portComponentBean.getWsdlService(), portComponentBean.getWsdlPort(), this.getProtocolBinding(), portComponentBean.getHandlerChains());
        }
        return this.handlerChainsResolver;
    }

    public String getProtocolBinding() {
        String string = this.getPortComp().getProtocolBinding();
        if (StringUtil.isEmpty(string = BindingIdTranslator.translate(string))) {
            string = "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        return string;
    }

    public abstract WSEEComponentContributor loadComponentContributor();

    public String getModuleName() {
        return this.moudleName;
    }

    void setModuleName(String string) {
        this.moudleName = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DeployInfo: \n");
        stringBuilder.append("  jwsClass=" + this.jwsClass + "\n");
        stringBuilder.append("  webServicesType=" + (Object)((Object)this.getWebServicesType()) + "\n");
        stringBuilder.append("  application=" + this.application + "\n");
        stringBuilder.append("  version=" + this.version + "\n");
        stringBuilder.append("  contextPath=" + this.getContextPath() + "\n");
        stringBuilder.append("  servletContext=" + this.servletContext + "\n");
        stringBuilder.append("  serviceName=" + this.serviceName + "\n");
        stringBuilder.append("  serviceURIs=" + Arrays.toString(this.serviceURIs) + "\n");
        stringBuilder.append("  wsdlDef=" + this.wsdlDef + "\n");
        stringBuilder.append("  mappingdd=" + this.mappingdd + "\n");
        stringBuilder.append("  portComp=" + this.portComp + "\n");
        stringBuilder.append("  wlPortComp=" + this.wlPortComp + "\n");
        stringBuilder.append("  policySubject=" + this.policySubject + "\n");
        stringBuilder.append("  wssConfigMBeanName=" + this.wssConfigMBeanName + "\n");
        stringBuilder.append("  securityRealmName=" + this.securityRealmName + "\n");
        stringBuilder.append("  wssPolicyCtx=" + this.wssPolicyCtx + "\n");
        stringBuilder.append("  dynamicEjbs=" + this.dynamicEjbs + "\n");
        stringBuilder.append("  bufferTargetURIs=" + this.bufferTargetURIs + "\n");
        stringBuilder.append("  linkName=" + this.linkName + "\n");
        stringBuilder.append("  componentName=" + this.getModuleName() + "\n");
        stringBuilder.append("  applicationCtx=" + this.applicationCtx + "\n\n");
        return stringBuilder.toString();
    }
}

