/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.deploy;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.SessionContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceException;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.MethodInfo;
import weblogic.ejb.spi.SessionBeanInfo;
import weblogic.ejb.spi.WSObjectFactory;
import weblogic.j2ee.descriptor.PortComponentHandlerBean;
import weblogic.j2ee.injection.PitchforkContext;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.jaxws.JAXWSEjbServlet;
import weblogic.wsee.jaxws.WLSEjbInstanceResolver;
import weblogic.wsee.jaxws.WLSServletAdapter;
import weblogic.wsee.jaxws.WLSServletAdapterList;
import weblogic.wsee.jaxws.injection.WSEEComponentContributor;
import weblogic.wsee.jaxws.injection.WSEEServerComponentContributor;
import weblogic.wsee.jws.JWSVisitor;
import weblogic.wsee.jws.VisitableJWSBuilder;
import weblogic.wsee.server.servlet.EjbWSServlet;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.ws.WsFactory;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlUtils;
import weblogic.wsee.wsdl.soap11.SoapAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBDeployInfo
extends DeployInfo {
    static final String EJB_SERVICE_URL = "weblogic.wsee.EJBServiceURL";
    public static final String ALL_OPERTION = "--*";
    private static final String EJB_DEPLOY_INFO = "weblogic.wsee.EJBDeployInfo";
    private WSObjectFactory beanFactory;
    private WLSEjbInstanceResolver resolver;
    private SessionBeanInfo sbi;
    private Map<String, Short> transactionAttributes;

    EJBDeployInfo() {
    }

    public String getEjbName() {
        return this.linkName;
    }

    public void setServiceURI(String string) {
        this.serviceURIs = new String[]{string};
    }

    public void setServiceURIs(String[] stringArray) {
        this.serviceURIs = stringArray;
    }

    public WSObjectFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(WSObjectFactory wSObjectFactory) {
        this.beanFactory = wSObjectFactory;
    }

    @Override
    public WsService createWsService() throws WsException {
        return WsFactory.instance().createServerService(this);
    }

    String getContextPathFromWsdl() {
        if (this.getWsdlDef() == null) {
            return this.getJwsClass().getSimpleName();
        }
        WsdlPort wsdlPort = this.getWsdlDef().getPorts().get(this.getPortComp().getWsdlPort());
        SoapAddress soapAddress = WsdlUtils.getSoapAddress(wsdlPort);
        if (soapAddress == null) {
            return null;
        }
        String string = soapAddress.getLocation();
        if (string == null) {
            return null;
        }
        if ("REPLACE_WITH_ACTUAL_URL".equals(string)) {
            return this.getJwsClass().getSimpleName();
        }
        try {
            URL uRL = new URL(string);
            if ("http".equalsIgnoreCase(uRL.getProtocol()) || "https".equalsIgnoreCase(uRL.getProtocol())) {
                return uRL.getPath();
            }
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return null;
    }

    @Override
    String getServlet() {
        if (this.getWebServicesType() == WebServiceType.JAXRPC) {
            return EjbWSServlet.class.getName();
        }
        return JAXWSEjbServlet.class.getName();
    }

    void store(String string, ServletContext servletContext) {
        servletContext.setAttribute(EJB_DEPLOY_INFO + string, (Object)this);
    }

    public static EJBDeployInfo load(HttpServlet httpServlet) {
        String string = httpServlet.getInitParameter(EJB_SERVICE_URL);
        ServletContext servletContext = httpServlet.getServletContext();
        EJBDeployInfo eJBDeployInfo = (EJBDeployInfo)servletContext.getAttribute(EJB_DEPLOY_INFO + string);
        assert (eJBDeployInfo != null);
        if (verbose) {
            Verbose.banner("Init virtual Web App for EJB: " + eJBDeployInfo.getEjbName());
            Verbose.log("Service uri" + string);
        }
        servletContext.removeAttribute(EJB_DEPLOY_INFO + string);
        return eJBDeployInfo;
    }

    public WLSEjbInstanceResolver createInstanceResolver() {
        if (this.resolver == null) {
            this.resolver = new WLSEjbInstanceResolver(this.getBeanFactory(), this.getJwsClass());
        }
        return this.resolver;
    }

    @Override
    ServletAdapterList createServletAdapterList() {
        return new WLSEjbServletAdapterList();
    }

    public void setEJBInfo(SessionBeanInfo sessionBeanInfo) {
        this.sbi = sessionBeanInfo;
    }

    public Map<String, Short> getTransactionAttributes() {
        ClientDrivenBeanInfo clientDrivenBeanInfo = (ClientDrivenBeanInfo)((Object)this.sbi);
        if (clientDrivenBeanInfo.usesBeanManagedTx()) {
            return null;
        }
        if (this.transactionAttributes == null) {
            this.transactionAttributes = new HashMap<String, Short>();
            Map<Method, String> map = this.buildOperationMap(clientDrivenBeanInfo);
            Collection collection = clientDrivenBeanInfo.getAllWebserviceMethodInfos();
            for (MethodInfo methodInfo : collection) {
                short s = methodInfo.getTransactionAttribute();
                String string = map.get(methodInfo.getMethod());
                boolean bl = string != null;
                if (!bl) continue;
                this.transactionAttributes.put(string, s);
            }
        }
        return this.transactionAttributes;
    }

    @Override
    public WSEEComponentContributor loadComponentContributor() {
        List<PortComponentHandlerBean> list = this.createServerHandlerChainsResolver().getMatchingHandlers();
        PitchforkContext pitchforkContext = new PitchforkContext(null);
        WSEEServerComponentContributor wSEEServerComponentContributor = new WSEEServerComponentContributor(list, pitchforkContext);
        try {
            wSEEServerComponentContributor.init();
        }
        catch (Throwable throwable) {
            throw new WebServiceException(throwable);
        }
        return wSEEServerComponentContributor;
    }

    @Override
    public URL getCatalog() throws MalformedURLException {
        return this.getResource("/META-INF" + File.separator + "jax-ws-catalog.xml");
    }

    private Map<Method, String> buildOperationMap(ClientDrivenBeanInfo clientDrivenBeanInfo) {
        final HashMap<Method, String> hashMap = new HashMap<Method, String>();
        JWSVisitor jWSVisitor = new JWSVisitor(){
            boolean isProviderBasedWS = false;

            @Override
            public void visitClass(JWSVisitor.JWSClass jWSClass) {
                if (jWSClass.isProviderBased()) {
                    Method method = jWSClass.getInvokeMethod();
                    hashMap.put(method, EJBDeployInfo.ALL_OPERTION);
                }
            }

            @Override
            public void visitMethod(JWSVisitor.WsMethod wsMethod) {
                hashMap.put(wsMethod.getSeiMethod(), wsMethod.getOperationName());
            }

            public Map<Method, String> getOperationsMap() {
                return hashMap;
            }
        };
        Class clazz = clientDrivenBeanInfo.getBeanClass();
        VisitableJWSBuilder.jaxws().sei(clientDrivenBeanInfo.getServiceEndpointClass()).impl(clazz).build().accept(jWSVisitor);
        return hashMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WLSEjbServletAdapterList
    extends WLSServletAdapterList {
        private SessionContext context;

        private WLSEjbServletAdapterList() {
        }

        @Override
        protected ServletAdapter createHttpAdapter(String string, String string2, WSEndpoint<?> wSEndpoint) {
            if (this.context == null) {
                this.context = EJBDeployInfo.this.createInstanceResolver().getContext();
            }
            return new WLSServletAdapter(string, string2, wSEndpoint, this){

                protected WSHTTPConnection createConnection(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
                    return new WLSServletAdapter.WLSServletConnection((WLSServletAdapter)this, servletContext, httpServletRequest, httpServletResponse){

                        public Principal getUserPrincipal(Packet packet) {
                            return WLSEjbServletAdapterList.this.context.getCallerPrincipal();
                        }

                        public boolean isUserInRole(Packet packet, String string) {
                            return WLSEjbServletAdapterList.this.context.isCallerInRole(string);
                        }
                    };
                }
            };
        }
    }
}

