/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.deploy;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.SecurityRole;
import weblogic.jws.CallbackMethod;
import weblogic.jws.security.CallbackRolesAllowed;
import weblogic.jws.security.RolesAllowed;
import weblogic.jws.security.RolesReferenced;
import weblogic.jws.security.SecurityRoleRef;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.ConsumptionException;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.service.WSPolicyConsumer;
import weblogic.security.service.WSPolicyHandler;
import weblogic.security.service.WSRoleConsumer;
import weblogic.security.service.WSRoleHandler;
import weblogic.security.service.WebServiceResource;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.deploy.WSEEServletEndpointException;
import weblogic.wsee.jws.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SecurityRoleAndPolicyHelper {
    private static final AuthenticatedSubject kernelId = SecurityRoleAndPolicyHelper.getKernelID();
    private static final String OLD_VERSION = "9.2.0.0";
    private static final String VERSION = "10.0.0.0";
    private static final boolean isInProductionMode = SecurityRoleAndPolicyHelper.isProduction();
    private static final SimpleDateFormat timeFormatter = SecurityRoleAndPolicyHelper.getTimeFormatter();
    private Class<?> webService;
    private Class<?> eiClass;
    private boolean policyConsumerEnabled = false;
    private WSPolicyConsumer policyConsumer;
    private WSPolicyHandler policyHandler;
    private boolean roleConsumerEnabled = false;
    private WSRoleConsumer roleConsumer;
    private WSRoleHandler roleHandler;
    private String serviceName;
    private String appName;
    private String contextPath;
    private ApplicationContextInternal appCtx;
    private boolean initted = false;

    SecurityRoleAndPolicyHelper(DeployInfo deployInfo) {
        this.appName = deployInfo.getApplication();
        this.serviceName = deployInfo.getServiceName();
        this.contextPath = deployInfo.getContextPath();
        this.webService = deployInfo.getJwsClass();
        this.appCtx = deployInfo.getApplicationContext();
        this.eiClass = Util.getEIClass(this.webService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploySecurityRolesAndPolicies() {
        try {
            this.deployWebMethodRolesAndPolicies();
            this.deployCallbackMethodRolesAndPolicies();
            Object var2_1 = null;
            this.cleanUp();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.cleanUp();
            throw throwable;
        }
    }

    private void init() {
        if (this.initted) {
            return;
        }
        try {
            WSPolicyHandler wSPolicyHandler;
            String string = timeFormatter.format(new Date());
            this.policyConsumer = SecurityServiceManager.getWSPolicyConsumer((AuthenticatedSubject)kernelId);
            if (this.policyConsumer != null) {
                this.policyConsumerEnabled = this.policyConsumer.isEnabled();
            }
            String string2 = this.appName + ":" + this.contextPath + ":" + this.serviceName;
            if (this.policyConsumerEnabled) {
                wSPolicyHandler = this.policyConsumer.getWSPolicyHandler(this.appName, OLD_VERSION, string);
                if (wSPolicyHandler != null) {
                    wSPolicyHandler.done();
                }
                this.policyHandler = this.policyConsumer.getWSPolicyHandler(string2, VERSION, string);
            }
            this.roleConsumer = SecurityServiceManager.getWSRoleConsumer((AuthenticatedSubject)kernelId);
            if (this.roleConsumer != null) {
                this.roleConsumerEnabled = this.roleConsumer.isEnabled();
            }
            if (this.roleConsumerEnabled) {
                wSPolicyHandler = this.roleConsumer.getWSRoleHandler(this.appName, OLD_VERSION, string);
                if (wSPolicyHandler != null) {
                    wSPolicyHandler.done();
                }
                this.roleHandler = this.roleConsumer.getWSRoleHandler(string2, VERSION, string);
            }
        }
        catch (ConsumptionException consumptionException) {
            throw new WSEEServletEndpointException(consumptionException);
        }
        this.initted = true;
    }

    private void deployWebMethodRolesAndPolicies() {
        Method[] methodArray;
        Map<String, String[]> map = SecurityRoleAndPolicyHelper.getRolesAllowed(this.webService);
        for (Method method : methodArray = this.webService.getMethods()) {
            if (!Util.isWebMethod(method, this.eiClass)) continue;
            Map<String, String[]> map2 = SecurityRoleAndPolicyHelper.getRolesAllowed(method);
            if (map2.size() == 0) {
                if (map.size() == 0) continue;
                map2 = map;
            }
            this.deployMethodRolesAndPolicies(method, map2);
        }
    }

    private void deployCallbackMethodRolesAndPolicies() {
        Method[] methodArray;
        for (Method method : methodArray = this.webService.getMethods()) {
            CallbackMethod callbackMethod = method.getAnnotation(CallbackMethod.class);
            if (callbackMethod == null) continue;
            Map<String, String[]> map = SecurityRoleAndPolicyHelper.getCallbackRolesAllowed(method);
            if (map.size() == 0) {
                try {
                    Field field = this.webService.getDeclaredField(callbackMethod.target());
                    map = SecurityRoleAndPolicyHelper.getCallbackRolesAllowed(field);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new WSEEServletEndpointException(noSuchFieldException);
                }
            }
            if (map.size() <= 0) continue;
            this.deployMethodRolesAndPolicies(method, map);
        }
    }

    private void deployMethodRolesAndPolicies(Method method, Map<String, String[]> map) {
        String string = method.getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        Class<?>[] classArray = method.getParameterTypes();
        for (Class<?> stringArray2 : classArray) {
            arrayList.add(stringArray2.getCanonicalName());
        }
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        WebServiceResource webServiceResource = SecurityRoleAndPolicyHelper.createWebServiceResource(this.appName, this.contextPath, this.serviceName, string, (String[])objectArray);
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            this.deployRole(webServiceResource, entry.getKey(), entry.getValue());
        }
        String[] stringArray = map.keySet().toArray(new String[map.size()]);
        this.deployPolicy(webServiceResource, stringArray);
    }

    private final void cleanUp() {
        try {
            if (this.policyConsumerEnabled && this.policyHandler != null) {
                this.policyHandler.done();
            }
            if (this.roleConsumerEnabled && this.roleHandler != null) {
                this.roleHandler.done();
            }
        }
        catch (ConsumptionException consumptionException) {
            throw new WSEEServletEndpointException(consumptionException);
        }
    }

    private void deployRole(WebServiceResource webServiceResource, String string, String[] stringArray) {
        SecurityRole securityRole;
        this.init();
        String[] stringArray2 = stringArray;
        if (stringArray2.length == 0 && this.appCtx != null && (securityRole = this.appCtx.getSecurityRole(string)) != null && !securityRole.isExternallyDefined() && (stringArray2 = securityRole.getPrincipalNames()) == null) {
            return;
        }
        if (stringArray2.length == 0) {
            return;
        }
        if (!this.roleConsumerEnabled) {
            if (isInProductionMode) {
                throw new WSEEServletEndpointException("Role consumer  is not supported");
            }
            return;
        }
        try {
            if (this.roleHandler != null) {
                this.roleHandler.setRole(webServiceResource, string, stringArray2);
            }
        }
        catch (ConsumptionException consumptionException) {
            throw new WSEEServletEndpointException(consumptionException);
        }
    }

    private void deployPolicy(WebServiceResource webServiceResource, String[] stringArray) {
        this.init();
        if (!this.policyConsumerEnabled) {
            if (isInProductionMode) {
                throw new WSEEServletEndpointException("Policy consumer is not supported");
            }
            return;
        }
        try {
            if (this.policyHandler != null) {
                this.policyHandler.setPolicy(webServiceResource, stringArray);
            }
        }
        catch (ConsumptionException consumptionException) {
            throw new WSEEServletEndpointException(consumptionException);
        }
    }

    private static final WebServiceResource createWebServiceResource(String string, String string2, String string3, String string4, String[] stringArray) {
        return new WebServiceResource(string, string2, string3, string4, stringArray);
    }

    private static Map<String, String[]> getRolesAllowed(AnnotatedElement annotatedElement) {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        RolesAllowed rolesAllowed = annotatedElement.getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            weblogic.jws.security.SecurityRole[] securityRoleArray;
            for (weblogic.jws.security.SecurityRole securityRole : securityRoleArray = rolesAllowed.value()) {
                hashMap.put(securityRole.role(), securityRole.mapToPrincipals());
            }
        }
        return hashMap;
    }

    private static Map<String, String[]> getCallbackRolesAllowed(AnnotatedElement annotatedElement) {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        CallbackRolesAllowed callbackRolesAllowed = annotatedElement.getAnnotation(CallbackRolesAllowed.class);
        if (callbackRolesAllowed != null) {
            weblogic.jws.security.SecurityRole[] securityRoleArray;
            for (weblogic.jws.security.SecurityRole securityRole : securityRoleArray = callbackRolesAllowed.value()) {
                hashMap.put(securityRole.role(), securityRole.mapToPrincipals());
            }
        }
        return hashMap;
    }

    private static Map<String, String> getRolesReferenced(AnnotatedElement annotatedElement) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        RolesReferenced rolesReferenced = annotatedElement.getAnnotation(RolesReferenced.class);
        if (rolesReferenced != null) {
            SecurityRoleRef[] securityRoleRefArray;
            for (SecurityRoleRef securityRoleRef : securityRoleRefArray = rolesReferenced.value()) {
                String string = securityRoleRef.role();
                String string2 = securityRoleRef.link();
                if (string2.length() == 0) {
                    string2 = string;
                }
                hashMap.put(string, string2);
            }
        }
        return hashMap;
    }

    private static AuthenticatedSubject getKernelID() {
        return (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    private static final boolean isProduction() {
        return ManagementService.getRuntimeAccess(kernelId).getDomain().isProductionModeEnabled();
    }

    private static final SimpleDateFormat getTimeFormatter() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat;
    }
}

