/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.deploy;

import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.xml.ws.WebServiceException;
import weblogic.j2ee.descriptor.PortComponentHandlerBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.injection.PitchforkContext;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.jaxws.JAXWSWebAppServlet;
import weblogic.wsee.jaxws.WLSServletAdapterList;
import weblogic.wsee.jaxws.WLSServletInstanceResolver;
import weblogic.wsee.jaxws.injection.WSEEComponentContributor;
import weblogic.wsee.jaxws.injection.WSEEWebComponentContributor;
import weblogic.wsee.server.servlet.WebappWSServlet;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.ws.WsFactory;
import weblogic.wsee.ws.WsService;

public class ServletDeployInfo
extends DeployInfo {
    private static final String SERVLET_DEPLOY_INFO = "weblogic.wsee.ServletDeployInfo";
    private WSEEComponentContributor cc;

    ServletDeployInfo() {
    }

    public void setServiceURIs(String[] stringArray) {
        this.serviceURIs = stringArray;
    }

    public String getApplication() {
        String string = super.getApplication();
        if (string != null) {
            return string;
        }
        if (this.servletContext instanceof WebAppServletContext) {
            return ((WebAppServletContext)this.servletContext).getApplicationId();
        }
        throw new AssertionError((Object)"Unable to determine Application from ServletContext");
    }

    public String getSecurityRealmName() {
        String string = super.getSecurityRealmName();
        if (string != null) {
            return null;
        }
        if (this.servletContext instanceof WebAppServletContext) {
            return ((WebAppServletContext)this.servletContext).getSecurityRealmName();
        }
        throw new AssertionError((Object)"Unable to determine security realm from ServletContext");
    }

    public String getContextPath() {
        String string = super.getContextPath();
        if (string != null) {
            return string;
        }
        if (this.servletContext instanceof WebAppServletContext) {
            return ((WebAppServletContext)this.servletContext).getContextPath();
        }
        throw new AssertionError((Object)"Unable to determine ContextPath from ServletContext");
    }

    String getServlet() {
        if (this.getWebServicesType() == WebServiceType.JAXWS) {
            return JAXWSWebAppServlet.class.getName();
        }
        return WebappWSServlet.class.getName();
    }

    public WsService createWsService() throws WsException {
        return WsFactory.instance().createServerService(this);
    }

    public void store(ServletContext servletContext) {
        servletContext.setAttribute(SERVLET_DEPLOY_INFO + this.linkName, (Object)this);
    }

    public static ServletDeployInfo load(HttpServlet httpServlet) {
        ServletContext servletContext = httpServlet.getServletContext();
        ServletDeployInfo servletDeployInfo = (ServletDeployInfo)servletContext.getAttribute(SERVLET_DEPLOY_INFO + httpServlet.getServletName());
        servletContext.removeAttribute(SERVLET_DEPLOY_INFO + httpServlet.getServletName());
        return servletDeployInfo;
    }

    ServletAdapterList createServletAdapterList() {
        return new WLSServletAdapterList();
    }

    public InstanceResolver createInstanceResolver() {
        return new WLSServletInstanceResolver(this.loadComponentContributor(), (WebAppServletContext)this.servletContext, this.getJwsClass());
    }

    public WSEEComponentContributor loadComponentContributor() {
        if (this.cc == null) {
            List<PortComponentHandlerBean> list = this.createServerHandlerChainsResolver().getMatchingHandlers();
            WebAppBean webAppBean = ((WebAppServletContext)this.servletContext).getWebAppModule().getWebAppBean();
            PitchforkContext pitchforkContext = new PitchforkContext(null);
            this.cc = new WSEEWebComponentContributor(webAppBean, this.getJwsClass(), list, pitchforkContext);
            try {
                this.cc.init();
            }
            catch (Throwable throwable) {
                throw new WebServiceException(throwable);
            }
        }
        return this.cc;
    }
}

