/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.deploy;

import weblogic.store.PersistentStoreException;
import weblogic.wsee.server.WsStorage;
import weblogic.wsee.server.WsStorageFactory;
import weblogic.wsee.util.Verbose;

public class VersioningHelper {
    private WsStorage storage = WsStorageFactory.getStorage("versioncount", null, false, true);
    private static final boolean verbose = Verbose.isVerbose(VersioningHelper.class);
    private static final VersioningHelper singleton = new VersioningHelper();

    public static void updateCount(String string, String string2, int n) {
        singleton.updateVersionCount(string, string2, n);
    }

    public static long getCount(String string, String string2) {
        return singleton.getVersionCount(string, string2);
    }

    public static void removeRecord(String string, String string2) {
        singleton.removeVersionRecord(string, string2);
    }

    private VersioningHelper() {
        if (verbose) {
            Verbose.log("Created version helper storage  class loader = " + this.storage.getClass().getClassLoader());
        }
    }

    private synchronized void updateVersionCount(String string, String string2, int n) {
        block8: {
            String string3 = string + "#" + (string2 == null ? "" : string2);
            if (verbose) {
                Verbose.log("Updating version count for " + string3 + " by " + n);
            }
            long l = this.getVersionCount(string, string2);
            l += (long)n;
            if (verbose) {
                Verbose.log("New count = " + l);
            }
            try {
                if (l <= 0L) {
                    if (verbose) {
                        Verbose.log("Removing key " + string3 + " from store");
                    }
                    this.storage.persistentRemove(string3);
                } else {
                    if (verbose) {
                        Verbose.log("Updating key " + string3 + " with count " + l);
                    }
                    this.storage.persistentPut(string3, new Long(l));
                }
            }
            catch (PersistentStoreException persistentStoreException) {
                if (!verbose) break block8;
                Verbose.log("Caught " + (Object)((Object)persistentStoreException) + " updating instance count of " + string3 + "by " + n);
            }
        }
    }

    private synchronized long getVersionCount(String string, String string2) {
        String string3 = string + "#" + (string2 == null ? "" : string2);
        if (verbose) {
            Verbose.log("Getting version count for " + string3);
        }
        try {
            Long l = (Long)this.storage.persistentGet(string3);
            long l2 = 0L;
            if (l != null && (l2 = l.longValue()) <= 0L) {
                l2 = 0L;
            }
            if (verbose) {
                Verbose.log("Returning count = " + l2 + " for key " + string3);
            }
            return l2;
        }
        catch (PersistentStoreException persistentStoreException) {
            if (verbose) {
                Verbose.log("Caught " + (Object)((Object)persistentStoreException) + "getting version count for " + string3);
            }
            return 0L;
        }
    }

    private synchronized void removeVersionRecord(String string, String string2) {
        block3: {
            String string3 = string + "#" + (string2 == null ? "" : string2);
            try {
                if (this.storage.persistentGet(string3) != null) {
                    this.storage.persistentRemove(string3);
                }
            }
            catch (PersistentStoreException persistentStoreException) {
                if (!verbose) break block3;
                Verbose.log("Caught " + (Object)((Object)persistentStoreException) + " removing version record for " + string3);
            }
        }
    }
}

