/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.deploy;

import com.bea.util.jam.JClass;
import com.bea.util.jam.JMethod;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.PortComponentBean;
import weblogic.j2ee.descriptor.ServiceImplBeanBean;
import weblogic.j2ee.descriptor.WebservicesBean;
import weblogic.j2ee.descriptor.wl.WSATConfigBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebservicesBean;
import weblogic.j2ee.descriptor.wl.WebserviceDescriptionBean;
import weblogic.jws.Policies;
import weblogic.jws.Policy;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.deploy.WSEEBaseModule;
import weblogic.wsee.deploy.WSEEModule;
import weblogic.wsee.jws.WebServiceRuntimeDecl;
import weblogic.wsee.policy.deployment.WsdlPolicySubject;
import weblogic.wsee.util.ClassLoaderUtil;
import weblogic.wsee.util.ClassUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wstx.wsat.config.DDHelper;

public class WSEEAnnotationProcessor {
    private static boolean verbose = Verbose.isVerbose(WSEEAnnotationProcessor.class);
    private Map<String, PortComponentBean> portMap = new HashMap<String, PortComponentBean>();
    private Map<String, weblogic.j2ee.descriptor.wl.PortComponentBean> wlJwsPortMapForJAXWS = new HashMap<String, weblogic.j2ee.descriptor.wl.PortComponentBean>();
    private Map<String, weblogic.j2ee.descriptor.WebserviceDescriptionBean> serviceMapForJAXWS = new HashMap<String, weblogic.j2ee.descriptor.WebserviceDescriptionBean>();
    private Map<String, String> serviceLinkMap = new HashMap<String, String>();
    private Map<String, WebserviceDescriptionBean> wlServiceMapForJAXWS = new HashMap<String, WebserviceDescriptionBean>();
    private Set<String> jaxRpcPorts = new HashSet<String>();

    public WebservicesBean process(WebservicesBean webservicesBean, WeblogicWebservicesBean weblogicWebservicesBean, WSEEBaseModule wSEEBaseModule) throws WsException {
        return this.process(webservicesBean, weblogicWebservicesBean, wSEEBaseModule, null);
    }

    public WebservicesBean process(WebservicesBean webservicesBean, WeblogicWebservicesBean weblogicWebservicesBean, WSEEBaseModule wSEEBaseModule, ClassLoader classLoader) throws WsException {
        WebservicesBean webservicesBean2 = webservicesBean;
        this.loadWLServiceAndPorts(weblogicWebservicesBean);
        this.load(webservicesBean, wSEEBaseModule);
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        Map<String, Class> map = wSEEBaseModule.getLinkMap();
        for (String string : map.keySet()) {
            Class clazz = map.get(string);
            if (!ClassUtil.isWebService(clazz)) continue;
            webservicesBean2 = this.getWebServicesBean(webservicesBean2);
            weblogicWebservicesBean = WSEEAnnotationProcessor.getWeblogicWebServicesBean(weblogicWebservicesBean);
            try {
                weblogic.j2ee.descriptor.wl.PortComponentBean portComponentBean;
                Object object;
                Object object2;
                if (classLoader != null) {
                    object2 = new ClassLoaderUtil.DelegatingLoader(clazz.getClassLoader(), classLoader);
                    if (classLoader2 != null) {
                        object2 = new ClassLoaderUtil.DelegatingLoader((ClassLoader)object2, classLoader2);
                    }
                    Thread.currentThread().setContextClassLoader((ClassLoader)object2);
                }
                object2 = new WebServiceRuntimeDecl(WebServiceType.JAXWS, clazz);
                PortComponentBean portComponentBean2 = this.portMap.get(string);
                if (portComponentBean2 == null) {
                    object = this.createWebserviceDescriptionBeanForJAXWS(webservicesBean2, (WebServiceRuntimeDecl)object2);
                    portComponentBean2 = object.createPortComponent();
                    this.portMap.put(string, portComponentBean2);
                    this.serviceLinkMap.put(string, object.getWebserviceDescriptionName());
                    if (!StringUtil.isEmpty(object.getWsdlFile()) && this.isWsdlHasPolicy(wSEEBaseModule, object.getWsdlFile())) {
                        portComponentBean = ((WebServiceRuntimeDecl)object2).getJClass();
                        if (portComponentBean != null && (this.isAnnotationPresent((JClass)portComponentBean, Policy.class) || this.isAnnotationPresent((JClass)portComponentBean, Policies.class))) {
                            throw new WsException("The Policy and Policies annotations are not allowed on JWS '" + portComponentBean.getQualifiedName() + "' when a wsdl which contains WS-Policy is specified by webservices.xml or WebService annotation. Please remove the annotations and use the policy reference descriptor file to attach policy to endpoint");
                        }
                        portComponentBean = ((WebServiceRuntimeDecl)object2).getEIClass();
                        if (portComponentBean != null && (this.isAnnotationPresent((JClass)portComponentBean, Policy.class) || this.isAnnotationPresent((JClass)portComponentBean, Policies.class))) {
                            throw new WsException("The Policy and Policies annotations are not allowed on endpoint interface '" + portComponentBean.getQualifiedName() + "' when a wsdl which contains WS-Policy is specified by webservices.xml or WebService annotation. Please remove the annotations and use the policy reference descriptor file to attach policy to endpoint");
                        }
                    }
                }
                object = this.serviceLinkMap.get(string);
                if (this.jaxRpcPorts.contains(portComponentBean2.getPortComponentName())) continue;
                this.merge(wSEEBaseModule, portComponentBean2, (WebServiceRuntimeDecl)object2, string);
                portComponentBean = this.createWLComponentBeanForJAXWS((WebServiceRuntimeDecl)object2, weblogicWebservicesBean, portComponentBean2, (String)object);
                WSATConfigBean wSATConfigBean = portComponentBean.getWSATConfig();
                String string2 = ((WebServiceRuntimeDecl)object2).getEndPointInterface();
                Class clazz2 = StringUtil.isEmpty(string2) ? null : ClassUtil.loadClass(string2);
                boolean bl = wSEEBaseModule instanceof WSEEModule;
                DDHelper.populateServiceDDFromJWS(clazz2, clazz, portComponentBean, bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WebServiceException((Throwable)classNotFoundException);
            }
            finally {
                if (classLoader == null) continue;
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
        }
        if (webservicesBean2 != null) {
            this.checkWsdlPortNames(webservicesBean2);
        }
        return webservicesBean2;
    }

    private void checkWsdlPortNames(WebservicesBean webservicesBean) throws WsException {
        for (weblogic.j2ee.descriptor.WebserviceDescriptionBean webserviceDescriptionBean : webservicesBean.getWebserviceDescriptions()) {
            HashSet<QName> hashSet = new HashSet<QName>(2);
            for (PortComponentBean portComponentBean : webserviceDescriptionBean.getPortComponents()) {
                if (hashSet.add(portComponentBean.getWsdlPort())) continue;
                throw new WsException("Two port in the " + webserviceDescriptionBean.getWebserviceDescriptionName() + "(WebserviceDescriptionBean) has the same name " + portComponentBean.getWsdlPort().toString() + ". ");
            }
        }
    }

    private weblogic.j2ee.descriptor.wl.PortComponentBean createWLComponentBeanForJAXWS(WebServiceRuntimeDecl webServiceRuntimeDecl, WeblogicWebservicesBean weblogicWebservicesBean, PortComponentBean portComponentBean, String string) {
        weblogic.j2ee.descriptor.wl.PortComponentBean portComponentBean2 = this.wlJwsPortMapForJAXWS.get(portComponentBean.getPortComponentName());
        if (portComponentBean2 == null) {
            WebserviceDescriptionBean webserviceDescriptionBean = this.createWebserviceDescriptionBeanForJAXWS(weblogicWebservicesBean, string);
            portComponentBean2 = webserviceDescriptionBean.createPortComponent();
            portComponentBean2.setPortComponentName(portComponentBean.getPortComponentName());
            this.wlJwsPortMapForJAXWS.put(portComponentBean2.getPortComponentName(), portComponentBean2);
        }
        return portComponentBean2;
    }

    weblogic.j2ee.descriptor.WebserviceDescriptionBean createWebserviceDescriptionBeanForJAXWS(WebservicesBean webservicesBean, WebServiceRuntimeDecl webServiceRuntimeDecl) {
        weblogic.j2ee.descriptor.WebserviceDescriptionBean webserviceDescriptionBean = this.serviceMapForJAXWS.get(webServiceRuntimeDecl.getServiceName());
        if (webserviceDescriptionBean == null) {
            webserviceDescriptionBean = webservicesBean.createWebserviceDescription();
            if (!this.isSet("WebserviceDescriptionName", webserviceDescriptionBean)) {
                webserviceDescriptionBean.setWebserviceDescriptionName(webServiceRuntimeDecl.getServiceName());
            }
            if (!this.isSet("WsdlFile", webserviceDescriptionBean) && !StringUtil.isEmpty(webServiceRuntimeDecl.getWsdlLocation())) {
                webserviceDescriptionBean.setWsdlFile(webServiceRuntimeDecl.getWsdlLocation());
            }
            this.serviceMapForJAXWS.put(webServiceRuntimeDecl.getServiceName(), webserviceDescriptionBean);
        }
        return webserviceDescriptionBean;
    }

    WebserviceDescriptionBean createWebserviceDescriptionBeanForJAXWS(WeblogicWebservicesBean weblogicWebservicesBean, String string) {
        WebserviceDescriptionBean webserviceDescriptionBean = this.wlServiceMapForJAXWS.get(string);
        if (webserviceDescriptionBean == null) {
            webserviceDescriptionBean = weblogicWebservicesBean.createWebserviceDescription();
            if (!this.isSet("WebserviceDescriptionName", webserviceDescriptionBean)) {
                webserviceDescriptionBean.setWebserviceDescriptionName(string);
            }
            webserviceDescriptionBean.setWebserviceType("JAXWS");
            this.wlServiceMapForJAXWS.put(string, webserviceDescriptionBean);
        }
        return webserviceDescriptionBean;
    }

    private void loadWLServiceAndPorts(WeblogicWebservicesBean weblogicWebservicesBean) {
        WebserviceDescriptionBean[] webserviceDescriptionBeanArray;
        if (weblogicWebservicesBean != null && (webserviceDescriptionBeanArray = weblogicWebservicesBean.getWebserviceDescriptions()) != null) {
            for (WebserviceDescriptionBean webserviceDescriptionBean : webserviceDescriptionBeanArray) {
                weblogic.j2ee.descriptor.wl.PortComponentBean[] portComponentBeanArray;
                String string = webserviceDescriptionBean.getWebserviceType();
                if (StringUtil.isEmpty(string) || WebServiceType.valueOf(string) == WebServiceType.JAXRPC) {
                    portComponentBeanArray = webserviceDescriptionBean.getPortComponents();
                    if (portComponentBeanArray == null) continue;
                    for (weblogic.j2ee.descriptor.wl.PortComponentBean portComponentBean : portComponentBeanArray) {
                        this.jaxRpcPorts.add(portComponentBean.getPortComponentName());
                    }
                    continue;
                }
                this.wlServiceMapForJAXWS.put(webserviceDescriptionBean.getWebserviceDescriptionName(), webserviceDescriptionBean);
                portComponentBeanArray = webserviceDescriptionBean.getPortComponents();
                if (portComponentBeanArray == null) continue;
                for (weblogic.j2ee.descriptor.wl.PortComponentBean portComponentBean : portComponentBeanArray) {
                    this.wlJwsPortMapForJAXWS.put(portComponentBean.getPortComponentName(), portComponentBean);
                }
            }
        }
    }

    private void merge(WSEEBaseModule wSEEBaseModule, PortComponentBean portComponentBean, WebServiceRuntimeDecl webServiceRuntimeDecl, String string) {
        ServiceImplBeanBean serviceImplBeanBean;
        if (!this.isSet("PortComponentName", portComponentBean)) {
            portComponentBean.setPortComponentName(webServiceRuntimeDecl.getPortComponentName());
        }
        if (!this.isSet("WsdlService", portComponentBean)) {
            portComponentBean.setWsdlService(webServiceRuntimeDecl.getServiceQName());
        }
        if (!this.isSet("WsdlPort", portComponentBean)) {
            portComponentBean.setWsdlPort(webServiceRuntimeDecl.getPortQName());
        }
        if (!this.isSet("ProtocolBinding", portComponentBean)) {
            portComponentBean.setProtocolBinding(webServiceRuntimeDecl.getProtocolBinding());
        }
        if (!this.isSet("EnableMtom", portComponentBean)) {
            portComponentBean.setEnableMtom(webServiceRuntimeDecl.isMtomEnabled());
        }
        if ((serviceImplBeanBean = portComponentBean.getServiceImplBean()) == null) {
            serviceImplBeanBean = portComponentBean.createServiceImplBean();
        }
        wSEEBaseModule.setLinkName(serviceImplBeanBean, string);
        webServiceRuntimeDecl.getHandlerChainDecl().populatePort(portComponentBean, wSEEBaseModule.getEnvEntries(serviceImplBeanBean));
    }

    protected boolean isSet(String string, Object object) {
        return ((DescriptorBean)object).isSet(string);
    }

    private WebservicesBean getWebServicesBean(WebservicesBean webservicesBean) {
        WebservicesBean webservicesBean2 = webservicesBean;
        if (webservicesBean2 == null) {
            if (verbose) {
                Verbose.log("Creating web services bean.");
            }
            EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
            webservicesBean2 = (WebservicesBean)editableDescriptorManager.createDescriptorRoot(WebservicesBean.class).getRootBean();
            webservicesBean2.setVersion("1.2");
        }
        return webservicesBean2;
    }

    private static WeblogicWebservicesBean getWeblogicWebServicesBean(WeblogicWebservicesBean weblogicWebservicesBean) {
        if (weblogicWebservicesBean == null) {
            if (verbose) {
                Verbose.log("Creating weblogic web services bean.");
            }
            EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
            weblogicWebservicesBean = (WeblogicWebservicesBean)editableDescriptorManager.createDescriptorRoot(WeblogicWebservicesBean.class).getRootBean();
            weblogicWebservicesBean.setVersion("1.2");
        }
        return weblogicWebservicesBean;
    }

    private void load(WebservicesBean webservicesBean, WSEEBaseModule wSEEBaseModule) {
        weblogic.j2ee.descriptor.WebserviceDescriptionBean[] webserviceDescriptionBeanArray;
        if (webservicesBean != null && (webserviceDescriptionBeanArray = webservicesBean.getWebserviceDescriptions()) != null) {
            for (weblogic.j2ee.descriptor.WebserviceDescriptionBean webserviceDescriptionBean : webserviceDescriptionBeanArray) {
                String string = webserviceDescriptionBean.getWebserviceDescriptionName();
                if (!StringUtil.isEmpty(string) && this.wlServiceMapForJAXWS.get(string) != null) {
                    this.serviceMapForJAXWS.put(webserviceDescriptionBean.getWebserviceDescriptionName(), webserviceDescriptionBean);
                }
                this.loadPorts(webserviceDescriptionBean, wSEEBaseModule);
            }
        }
    }

    private void loadPorts(weblogic.j2ee.descriptor.WebserviceDescriptionBean webserviceDescriptionBean, WSEEBaseModule wSEEBaseModule) {
        PortComponentBean[] portComponentBeanArray = webserviceDescriptionBean.getPortComponents();
        if (portComponentBeanArray != null) {
            Map<String, Class> map = null;
            for (PortComponentBean portComponentBean : portComponentBeanArray) {
                Class clazz;
                ServiceImplBeanBean serviceImplBeanBean = portComponentBean.getServiceImplBean();
                if (serviceImplBeanBean == null) continue;
                String string = wSEEBaseModule.getLinkName(serviceImplBeanBean);
                if (map == null) {
                    map = wSEEBaseModule.getLinkMap();
                }
                if ((clazz = map.get(string)) == null) {
                    throw new IllegalArgumentException("Class not found for link: " + string + ":\t avaialbe:" + map);
                }
                this.portMap.put(string, portComponentBean);
                this.serviceLinkMap.put(string, webserviceDescriptionBean.getWebserviceDescriptionName());
            }
        }
    }

    private boolean isAnnotationPresent(JClass jClass, Class clazz) {
        if (jClass.getAnnotation(clazz) != null) {
            return true;
        }
        JMethod[] jMethodArray = jClass.getMethods();
        for (int i = 0; i < jMethodArray.length; ++i) {
            if (jMethodArray[i].getAnnotation(clazz) == null) continue;
            return true;
        }
        return false;
    }

    private boolean isWsdlHasPolicy(WSEEBaseModule wSEEBaseModule, String string) throws WsException {
        WSEEModule wSEEModule;
        WsdlDefinitions wsdlDefinitions;
        boolean bl = false;
        if (wSEEBaseModule instanceof WSEEModule && (wsdlDefinitions = (wSEEModule = (WSEEModule)wSEEBaseModule).loadWsdl(string)) != null) {
            bl = new WsdlPolicySubject(wsdlDefinitions).getPolicies().size() != 0;
        }
        return bl;
    }
}

