/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.deploy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.application.descriptor.ReaderEvent2;
import weblogic.application.descriptor.ReaderEventInfo;
import weblogic.application.descriptor.VersionMunger;
import weblogic.deploy.internal.DeploymentPlanDescriptorLoader;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.j2ee.descriptor.WebservicesBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebservicesBean;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public class WSEEDescriptor {
    private static final String JAVAEE_NAMESPACE_URI = "http://java.sun.com/xml/ns/javaee";
    private static final String J2EE_NAMESPACE_URI = "http://java.sun.com/xml/ns/j2ee";
    public static final String WSEE_WAR_XML_URI = "WEB-INF/webservices.xml";
    public static final String WL_WSEE_WAR_XML_URI = "WEB-INF/weblogic-webservices.xml";
    public static final String WSEE_JAR_XML_URI = "META-INF/webservices.xml";
    public static final String WL_WSEE_JAR_XML_URI = "META-INF/weblogic-webservices.xml";
    private MyWSEEDescriptor wseeDescriptor;
    private MyWlsWSEEDescriptor wlsWseeDescriptor;

    public WSEEDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, boolean bl) {
        this.wseeDescriptor = new MyWSEEDescriptor(virtualJarFile, file, deploymentPlanBean, string, bl);
        this.wlsWseeDescriptor = new MyWlsWSEEDescriptor(virtualJarFile, file, deploymentPlanBean, string, bl);
    }

    public WSEEDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
        this.wseeDescriptor = new MyWSEEDescriptor(virtualJarFile, file, deploymentPlanBean, string);
        this.wlsWseeDescriptor = new MyWlsWSEEDescriptor(virtualJarFile, file, deploymentPlanBean, string);
    }

    WSEEDescriptor(WebAppServletContext webAppServletContext, File file, DeploymentPlanBean deploymentPlanBean, String string) throws IOException, XMLStreamException {
        this.wseeDescriptor = new MyWSEEDescriptor(webAppServletContext, file, deploymentPlanBean, string);
        this.wlsWseeDescriptor = new MyWlsWSEEDescriptor(webAppServletContext, file, deploymentPlanBean, string);
        this.mergeWebServicesDescriptors(webAppServletContext.getResourceFinder("/"));
        this.mergeWeblogicWebServicesDescriptor(webAppServletContext.getResourceFinder("/"));
    }

    public WSEEDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
        if (file.getPath().endsWith("weblogic-webservices.xml")) {
            this.wlsWseeDescriptor = new MyWlsWSEEDescriptor(file, file2, deploymentPlanBean, string);
        } else {
            this.wseeDescriptor = new MyWSEEDescriptor(file, file2, deploymentPlanBean, string);
        }
    }

    public WSEEDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string, boolean bl) {
        this.wseeDescriptor = new MyWSEEDescriptor(descriptorManager, genericClassLoader, bl);
        this.wlsWseeDescriptor = new MyWlsWSEEDescriptor(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, bl);
    }

    public void mergeWebServicesDescriptors(ClassFinder classFinder) throws IOException, XMLStreamException {
        String string = "/WEB-INF/webservices.xml";
        Enumeration enumeration = classFinder.getSources(string);
        Object[] objectArray = Collections.list(enumeration).toArray();
        if (objectArray.length > 1) {
            this.wseeDescriptor.mergeDescriptors(objectArray);
        }
    }

    public void mergeWeblogicWebServicesDescriptor(ClassFinder classFinder) throws IOException, XMLStreamException {
        String string = "/WEB-INF/weblogic-webservices.xml";
        Enumeration enumeration = classFinder.getSources(string);
        Object[] objectArray = Collections.list(enumeration).toArray();
        if (objectArray.length > 1) {
            this.wlsWseeDescriptor.mergeDescriptors(objectArray);
        }
    }

    public DeploymentPlanBean getDeploymentPlan() {
        return this.wseeDescriptor.getDeploymentPlan();
    }

    public WebservicesBean getWebservicesBean() throws IOException, XMLStreamException {
        return (WebservicesBean)this.wseeDescriptor.loadDescriptorBean();
    }

    public WeblogicWebservicesBean getWeblogicWebservicesBean() throws IOException, XMLStreamException {
        return (WeblogicWebservicesBean)this.wlsWseeDescriptor.loadDescriptorBean();
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        File file;
        if (stringArray.length < 1) {
            WSEEDescriptor.usage();
        }
        if ((file = new File(string = stringArray[0])).getName().endsWith(".war") || file.getName().endsWith(".jar")) {
            File file2;
            JarFile jarFile = new JarFile(string);
            VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((JarFile)jarFile);
            System.out.println("\n\n... getting WebservicesBean:");
            WSEEDescriptor wSEEDescriptor = new WSEEDescriptor(virtualJarFile, null, null, null);
            WebservicesBean webservicesBean = wSEEDescriptor.getWebservicesBean();
            ((DescriptorBean)webservicesBean).getDescriptor().toXML((OutputStream)System.out);
            System.out.println("\n\n... getting WeblogicWebservicesBean:");
            WeblogicWebservicesBean weblogicWebservicesBean = new WSEEDescriptor(virtualJarFile, null, null, null).getWeblogicWebservicesBean();
            if (weblogicWebservicesBean != null) {
                ((DescriptorBean)weblogicWebservicesBean).getDescriptor().toXML((OutputStream)System.out);
            } else {
                System.out.println("... WeblogicWebservicesBean is null");
            }
            if (stringArray.length > 1 && (file2 = new File(stringArray[1])).getPath().endsWith("plan.xml")) {
                System.out.println("\n\n... plan:");
                DeploymentPlanDescriptorLoader deploymentPlanDescriptorLoader = new DeploymentPlanDescriptorLoader(file2);
                DeploymentPlanBean deploymentPlanBean = deploymentPlanDescriptorLoader.getDeploymentPlanBean();
                ((DescriptorBean)deploymentPlanBean).getDescriptor().toXML((OutputStream)System.out);
                System.out.println("\n\nConfig root = " + deploymentPlanBean.getConfigRoot());
                System.out.println("\nApplication name = " + deploymentPlanBean.getApplicationName());
                WSEEDescriptor wSEEDescriptor2 = new WSEEDescriptor(virtualJarFile, new File(deploymentPlanBean.getConfigRoot()), deploymentPlanBean, string);
                System.out.println("\n\n... plan merged WeblogicWebservicesBean with :");
                if (wSEEDescriptor2.getWeblogicWebservicesBean() != null) {
                    ((DescriptorBean)wSEEDescriptor2.getWeblogicWebservicesBean()).getDescriptor().toXML((OutputStream)System.out);
                } else {
                    System.out.println("... WeblogicWebservicesBean is null");
                }
                System.out.println("\n\n... plan merged WebservicesBean with :");
                ((DescriptorBean)wSEEDescriptor2.getWebservicesBean()).getDescriptor().toXML((OutputStream)System.out);
            }
        } else if (file.getPath().endsWith("weblogic-webservices.xml")) {
            File file3;
            System.out.println("\n\n... getting WeblogicWebservicesBean from: " + file);
            WeblogicWebservicesBean weblogicWebservicesBean = new WSEEDescriptor(file, null, null, null).getWeblogicWebservicesBean();
            ((DescriptorBean)weblogicWebservicesBean).getDescriptor().toXML((OutputStream)System.out);
            if (stringArray.length > 1 && (file3 = new File(stringArray[1])).getPath().endsWith("plan.xml")) {
                System.out.println("\n\n... plan:");
                DeploymentPlanDescriptorLoader deploymentPlanDescriptorLoader = new DeploymentPlanDescriptorLoader(file3);
                DeploymentPlanBean deploymentPlanBean = deploymentPlanDescriptorLoader.getDeploymentPlanBean();
                ((DescriptorBean)deploymentPlanBean).getDescriptor().toXML((OutputStream)System.out);
                WSEEDescriptor wSEEDescriptor = new WSEEDescriptor(file, new File(deploymentPlanBean.getConfigRoot()), deploymentPlanBean, deploymentPlanBean.getApplicationName());
                System.out.println("\n\n... plan merged WeblogicWebservicesBean with :");
                ((DescriptorBean)wSEEDescriptor.getWeblogicWebservicesBean()).getDescriptor().toXML((OutputStream)System.out);
            }
        } else if (file.getPath().endsWith("webservices.xml")) {
            File file4;
            System.out.println("\n\n... getting WebservicesBean:");
            WebservicesBean webservicesBean = new WSEEDescriptor(file, null, null, null).getWebservicesBean();
            ((DescriptorBean)webservicesBean).getDescriptor().toXML((OutputStream)System.out);
            if (stringArray.length > 1 && (file4 = new File(stringArray[1])).getPath().endsWith("plan.xml")) {
                System.out.println("\n\n... plan:");
                DeploymentPlanDescriptorLoader deploymentPlanDescriptorLoader = new DeploymentPlanDescriptorLoader(file4);
                DeploymentPlanBean deploymentPlanBean = deploymentPlanDescriptorLoader.getDeploymentPlanBean();
                ((DescriptorBean)deploymentPlanBean).getDescriptor().toXML((OutputStream)System.out);
                WSEEDescriptor wSEEDescriptor = new WSEEDescriptor(file, new File(deploymentPlanBean.getConfigRoot()), deploymentPlanBean, deploymentPlanBean.getApplicationName());
                System.out.println("\n\n... plan merged WebservicesBean with :");
                ((DescriptorBean)wSEEDescriptor.getWebservicesBean()).getDescriptor().toXML((OutputStream)System.out);
            }
        } else {
            System.out.println("\n\n... neither webservices.xml nor weblogic-webservices.xml specified");
        }
    }

    private static void usage() {
        System.err.println("usage: java weblogic.wsee.deploy.WSEEDescriptor <descriptor file name>");
        System.err.println("\n\n example:\n java weblogic.wsee.deploy.WSEEDescriptor jar or altDD file name ");
        System.exit(0);
    }

    public static class MyWlsWSEEDescriptor
    extends MyAbstractDescriptorLoader {
        private MyWlsWSEEDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(virtualJarFile, file, deploymentPlanBean, string);
        }

        private MyWlsWSEEDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, boolean bl) {
            super(virtualJarFile, file, deploymentPlanBean, string);
            this.useWarPath = bl;
        }

        private MyWlsWSEEDescriptor(WebAppServletContext webAppServletContext, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(webAppServletContext, file, deploymentPlanBean, string);
        }

        private MyWlsWSEEDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
            super(file, file2, deploymentPlanBean, string);
        }

        private MyWlsWSEEDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string, boolean bl) {
            super(descriptorManager, genericClassLoader, file, deploymentPlanBean, string);
            this.useWarPath = bl;
        }

        public MyWlsWSEEDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(file, file2, deploymentPlanBean, string);
        }

        public String getDocumentURI() {
            if (this.useWarPath) {
                return WSEEDescriptor.WL_WSEE_WAR_XML_URI;
            }
            return WSEEDescriptor.WL_WSEE_JAR_XML_URI;
        }

        protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
            String string = "weblogic.j2ee.descriptor.wl.WeblogicWebservicesBeanImpl$SchemaHelper2";
            return new VersionMunger(inputStream, (AbstractDescriptorLoader2)this, string, "http://xmlns.oracle.com/weblogic/weblogic-webservices");
        }
    }

    public static class MyWSEEDescriptor
    extends MyAbstractDescriptorLoader {
        private MyWSEEDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(virtualJarFile, file, deploymentPlanBean, string);
        }

        private MyWSEEDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, boolean bl) {
            super(virtualJarFile, file, deploymentPlanBean, string);
            this.useWarPath = bl;
        }

        private MyWSEEDescriptor(WebAppServletContext webAppServletContext, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(webAppServletContext, file, deploymentPlanBean, string);
        }

        private MyWSEEDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
            super(file, file2, deploymentPlanBean, string);
        }

        private MyWSEEDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, boolean bl) {
            super(descriptorManager, genericClassLoader);
            this.useWarPath = bl;
        }

        public MyWSEEDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(file, file2, deploymentPlanBean, string);
        }

        public String getDocumentURI() {
            if (this.useWarPath) {
                return WSEEDescriptor.WSEE_WAR_XML_URI;
            }
            return WSEEDescriptor.WSEE_JAR_XML_URI;
        }

        protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
            return new VersionMunger(inputStream, this, "weblogic.j2ee.descriptor.WebservicesBeanImpl$SchemaHelper2"){

                public String getDtdNamespaceURI() {
                    return WSEEDescriptor.JAVAEE_NAMESPACE_URI;
                }

                protected boolean isOldSchema() {
                    String string = this.getNamespaceURI();
                    return string != null && string.indexOf("j2ee") != -1;
                }

                private void transform(String string, ReaderEvent2 readerEvent2) {
                    ReaderEventInfo readerEventInfo = readerEvent2.getReaderEventInfo();
                    int n = readerEventInfo.getNamespaceCount();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (int i = 0; i < n; ++i) {
                        String string2 = readerEventInfo.getNamespaceURI(i);
                        if (WSEEDescriptor.J2EE_NAMESPACE_URI.equals(string2)) {
                            string2 = string;
                        }
                        String string3 = readerEventInfo.getNamespacePrefix(i);
                        hashMap.put(string3, string2);
                    }
                    this.setNamespaces(readerEvent2, hashMap);
                }

                private void setNamespaces(ReaderEvent2 readerEvent2, Map map) {
                    ReaderEventInfo readerEventInfo = readerEvent2.getReaderEventInfo();
                    readerEventInfo.clearNamespaces();
                    readerEventInfo.setNamespaceCount(map.size());
                    for (Object object : map.keySet()) {
                        Object object2 = (String)map.get(object);
                        if (((String)object2).equals(WSEEDescriptor.JAVAEE_NAMESPACE_URI) && object != null) {
                            readerEventInfo.setPrefix((String)object);
                        }
                        readerEventInfo.setNamespaceURI((String)object, (String)object2);
                    }
                    for (Object object2 : readerEvent2.getChildren()) {
                        this.setNamespaces((ReaderEvent2)object2, map);
                    }
                }

                protected void transformOldSchema() {
                    if (this.currentEvent.getElementName().equals("webservices")) {
                        int n = this.currentEvent.getReaderEventInfo().getAttributeCount();
                        for (int i = 0; i < n; ++i) {
                            String string;
                            String string2 = this.currentEvent.getReaderEventInfo().getAttributeLocalName(i);
                            if (string2 == null || !string2.equals("version") || !(string = this.currentEvent.getReaderEventInfo().getAttributeValue(i)).equals("1.1")) continue;
                            this.versionInfo = string;
                            this.currentEvent.getReaderEventInfo().setAttributeValue("1.2", i);
                        }
                        this.transform(WSEEDescriptor.JAVAEE_NAMESPACE_URI, this.currentEvent);
                    }
                    this.tranformedNamespace = WSEEDescriptor.JAVAEE_NAMESPACE_URI;
                }
            };
        }
    }

    private static abstract class MyAbstractDescriptorLoader
    extends AbstractDescriptorLoader2 {
        boolean useWarPath = false;
        WebAppServletContext svltCtx;

        private MyAbstractDescriptorLoader(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(virtualJarFile, file, deploymentPlanBean, string, null);
            if (virtualJarFile.getName().endsWith(".war")) {
                this.useWarPath = true;
            }
        }

        private MyAbstractDescriptorLoader(WebAppServletContext webAppServletContext, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super((VirtualJarFile)null, file, deploymentPlanBean, string, null);
            this.useWarPath = true;
            this.svltCtx = webAppServletContext;
        }

        private MyAbstractDescriptorLoader(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
            super(file, file2, deploymentPlanBean, string, null);
        }

        private MyAbstractDescriptorLoader(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
            super(descriptorManager, genericClassLoader, null);
        }

        private MyAbstractDescriptorLoader(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, null);
        }

        public InputStream getInputStream() throws IOException {
            if (this.svltCtx != null) {
                return this.svltCtx.getResourceAsStream(this.getDocumentURI());
            }
            return super.getInputStream();
        }
    }
}

