/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.deploy;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ApplicationContext;
import weblogic.application.ModuleException;
import weblogic.ejb.spi.BeanInfo;
import weblogic.ejb.spi.DeploymentInfo;
import weblogic.ejb.spi.EJBDeploymentException;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.SessionBeanInfo;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb.spi.WSObjectFactory;
import weblogic.j2ee.descriptor.EnvEntryBean;
import weblogic.j2ee.descriptor.JavaWsdlMappingBean;
import weblogic.j2ee.descriptor.ServiceImplBeanBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.j2ee.descriptor.WebserviceDescriptionBean;
import weblogic.j2ee.descriptor.WebservicesBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.PortComponentBean;
import weblogic.management.DeploymentException;
import weblogic.wsee.async.AsyncResponseBean;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.deploy.EJBDeployInfo;
import weblogic.wsee.deploy.JavaWsdlMappingDescriptor;
import weblogic.wsee.deploy.WSEEDescriptor;
import weblogic.wsee.deploy.WSEEModule;
import weblogic.wsee.deploy.WSEEProperties;
import weblogic.wsee.deploy.WsdlAddressInfo;
import weblogic.wsee.deploy.WseeWebappModule;
import weblogic.wsee.jws.container.JWSSessionBean;
import weblogic.wsee.policy.deployment.WsPolicyDescriptor;
import weblogic.wsee.policy.runtime.PolicyFinder;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlFactory;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSEEEjbModule
extends WSEEModule {
    public static final String EJB_WRAPPER_LEGACY_DEPLOY_MSG = "9.0 and 9.1 compliled WLS Web Services need to be recompiled for deployment \n if the JWS contains any of the following annotations.\n\nweblogic.jws.Conversation\nweblogic.jws.Conversational\nweblogic.jws.Context\nweblogic.jws.Callback\nweblogic.jws.ServiceClient\norg.apache.beehive.controls.api.bean.Control\nPlease note that the defaults for weblogic.jws.Conversational.runAsStartUser and weblogic.jws.Conversational.singlePrincipal have changed to false.\n";
    private String moduleName = null;
    private DeploymentInfo ejbDeploymentInfo = null;
    private EjbDescriptorBean ejbDescriptor = null;
    private List<WseeWebappModule> wseeWebappModules = new LinkedList<WseeWebappModule>();

    WSEEEjbModule(String string, ApplicationContext applicationContext) {
        super(applicationContext);
        this.moduleName = string;
    }

    @Override
    DeployInfo createDeployInfo() {
        return new EJBDeployInfo();
    }

    @Override
    String getModuleName() {
        return this.moduleName;
    }

    void setEjbDeploymentInfo(DeploymentInfo deploymentInfo) {
        this.ejbDeploymentInfo = deploymentInfo;
    }

    void setEjbDescriptorBean(EjbDescriptorBean ejbDescriptorBean) {
        this.ejbDescriptor = ejbDescriptorBean;
    }

    @Override
    WSEEDescriptor loadDescriptor(File file, DeploymentPlanBean deploymentPlanBean) throws IOException, XMLStreamException {
        return new WSEEDescriptor(this.ejbDeploymentInfo.getVirtualJarFile(), file, deploymentPlanBean, this.moduleName);
    }

    @Override
    WsPolicyDescriptor loadWsPolicyDescriptor(File file, DeploymentPlanBean deploymentPlanBean) throws IOException, XMLStreamException {
        return new WsPolicyDescriptor(this.ejbDeploymentInfo.getVirtualJarFile(), file, deploymentPlanBean, this.moduleName);
    }

    @Override
    protected Map<String, Class> getLinkMap() {
        HashMap<String, Class> hashMap = new HashMap<String, Class>();
        for (BeanInfo beanInfo : this.ejbDeploymentInfo.getBeanInfos()) {
            SessionBeanInfo sessionBeanInfo;
            if (!(beanInfo instanceof SessionBeanInfo) || (sessionBeanInfo = (SessionBeanInfo)beanInfo).isStateful()) continue;
            hashMap.put(sessionBeanInfo.getEJBName(), sessionBeanInfo.getBeanClass());
        }
        return hashMap;
    }

    @Override
    protected String getLinkName(ServiceImplBeanBean serviceImplBeanBean) {
        return serviceImplBeanBean.getEjbLink();
    }

    @Override
    protected void setLinkName(ServiceImplBeanBean serviceImplBeanBean, String string) {
        serviceImplBeanBean.setEjbLink(string);
    }

    @Override
    protected EnvEntryBean[] getEnvEntries(ServiceImplBeanBean serviceImplBeanBean) {
        SessionBeanBean[] sessionBeanBeanArray = this.ejbDescriptor.getEjbJarBean().getEnterpriseBeans().getSessions();
        for (int i = 0; i < sessionBeanBeanArray.length; ++i) {
            if (!sessionBeanBeanArray[i].getEjbName().equals(serviceImplBeanBean.getEjbLink())) continue;
            return sessionBeanBeanArray[i].getEnvEntries();
        }
        return null;
    }

    @Override
    WsdlDefinitions loadWsdlDefinitions(String string) throws WsException {
        URL uRL = this.ejbDeploymentInfo.getVirtualJarFile().getResource(string);
        if (uRL == null && !string.toUpperCase(Locale.ENGLISH).startsWith("META-INF")) {
            uRL = this.ejbDeploymentInfo.getVirtualJarFile().getResource("META-INF" + (string.startsWith("/") ? "" : "/") + string);
        }
        if (uRL == null && string.startsWith("/")) {
            string = string.substring(1);
            uRL = this.ejbDeploymentInfo.getVirtualJarFile().getResource(string);
        }
        if (uRL == null) {
            throw new WsException("wsdl \"" + string + "\" is not found in the deployment " + this.ejbDeploymentInfo.getVirtualJarFile());
        }
        try {
            return WsdlFactory.getInstance().parse(uRL.toString());
        }
        catch (WsdlException wsdlException) {
            throw new WsException(wsdlException.getMessage(), wsdlException);
        }
    }

    @Override
    JavaWsdlMappingBean loadMappingFile(String string) throws WsException {
        Object object;
        File file = null;
        DeploymentPlanBean deploymentPlanBean = null;
        if (this.appCtx != null) {
            object = this.appCtx.getAppDeploymentMBean();
            deploymentPlanBean = object.getDeploymentPlanDescriptor();
            if (object.getPlanDir() != null) {
                file = new File(object.getLocalPlanDir());
            }
        }
        object = new JavaWsdlMappingDescriptor(this.ejbDeploymentInfo.getVirtualJarFile(), file, deploymentPlanBean, this.moduleName, string);
        try {
            return ((JavaWsdlMappingDescriptor)object).getJavaWsdlMappingBean();
        }
        catch (Exception exception) {
            throw new WsException("Failed to load Jaxrp mapping file \"" + string + "\" " + "in " + this.ejbDeploymentInfo.getVirtualJarFile() + " " + exception, exception);
        }
    }

    @Override
    void loadModulePolicies(PolicyServer policyServer) throws Exception {
        PolicyFinder.loadPolicies(this.ejbDeploymentInfo.getVirtualJarFile(), policyServer);
    }

    @Override
    void registerEndpoint(WebservicesBean webservicesBean) throws Exception {
        WebserviceDescriptionBean[] webserviceDescriptionBeanArray;
        this.verifyEjbDD();
        for (WebserviceDescriptionBean webserviceDescriptionBean : webserviceDescriptionBeanArray = webservicesBean.getWebserviceDescriptions()) {
            WsdlAddressInfo wsdlAddressInfo = new WsdlAddressInfo();
            weblogic.j2ee.descriptor.PortComponentBean[] portComponentBeanArray = webserviceDescriptionBean.getPortComponents();
            WsdlDefinitions wsdlDefinitions = null;
            for (weblogic.j2ee.descriptor.PortComponentBean portComponentBean : portComponentBeanArray) {
                WsdlAddressInfo.PortAddress portAddress = wsdlAddressInfo.addWsdlPort(portComponentBean.getWsdlPort());
                String string = portComponentBean.getServiceImplBean().getEjbLink();
                EJBDeployInfo eJBDeployInfo = (EJBDeployInfo)this.deployInfoMap.get(string);
                String string2 = null;
                if (portComponentBean.getWsdlService() != null) {
                    string2 = portComponentBean.getWsdlService().getLocalPart();
                }
                this.registerContext(eJBDeployInfo, portAddress, string2);
                wsdlDefinitions = eJBDeployInfo.getWsdlDef();
                if (wsdlDefinitions == null) continue;
                this.bindInternalPort(eJBDeployInfo, portComponentBean, wsdlDefinitions.getPorts().get(portComponentBean.getWsdlPort()));
            }
            if (wsdlDefinitions == null) continue;
            WsdlUtils.updateAddress(wsdlDefinitions, wsdlAddressInfo);
        }
    }

    private void verifyEjbDD() throws EJBDeploymentException {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.deployInfoMap.keySet());
        for (BeanInfo beanInfo : this.ejbDeploymentInfo.getBeanInfos()) {
            if (!(beanInfo instanceof SessionBeanInfo)) continue;
            SessionBeanInfo sessionBeanInfo = (SessionBeanInfo)beanInfo;
            String string = sessionBeanInfo.getEJBName();
            if (sessionBeanInfo.getBeanClass().getSuperclass().equals(JWSSessionBean.class)) {
                throw new EJBDeploymentException(string, this.moduleName, new WLDeploymentException(EJB_WRAPPER_LEGACY_DEPLOY_MSG));
            }
            WSObjectFactory wSObjectFactory = sessionBeanInfo.getWSObjectFactory();
            if (wSObjectFactory == null) {
                if (!hashSet.contains(string)) continue;
                throw new EJBDeploymentException(string, this.moduleName, new WLDeploymentException("ejb \"" + string + "\" " + "doesn't have a web service view in ejb-jar.xml."));
            }
            assert (!sessionBeanInfo.isStateful());
            if (hashSet.size() == 0) {
                throw new EJBDeploymentException(string, this.moduleName, new WLDeploymentException("ejb \"" + string + "\" has a web service view in ejb-jar.xml, but webservices.xml " + "file is not found."));
            }
            EJBDeployInfo eJBDeployInfo = (EJBDeployInfo)this.deployInfoMap.get(string);
            if (eJBDeployInfo == null) {
                throw new EJBDeploymentException(string, this.moduleName, new WLDeploymentException("ejb \"" + string + "\" " + "is not defined as web service in webservices.xml."));
            }
            eJBDeployInfo.setBeanFactory(wSObjectFactory);
            eJBDeployInfo.setJwsClass(sessionBeanInfo.getBeanClass());
            eJBDeployInfo.setEJBInfo(sessionBeanInfo);
            hashSet.remove(string);
        }
        if (hashSet.size() != 0) {
            throw new EJBDeploymentException(this.moduleName, this.moduleName, new WLDeploymentException("<ejb-link> \"" + hashSet + "\" " + "defined in webservices.xml don't exist or don't have a valid " + "web service view in ejb-jar.xml."));
        }
    }

    private void bindInternalPort(EJBDeployInfo eJBDeployInfo, weblogic.j2ee.descriptor.PortComponentBean portComponentBean, WsdlPort wsdlPort) throws EJBDeploymentException {
        String string = "wsee/" + this.moduleName + "#" + portComponentBean.getPortComponentName();
        try {
            Context context = this.appCtx.getEnvContext();
            context.bind(string, (Object)wsdlPort);
        }
        catch (NamingException namingException) {
            throw new EJBDeploymentException(eJBDeployInfo.getEjbName(), this.moduleName, new WsException("Failed to bind wsdl port to internal name " + string + " " + namingException, namingException));
        }
    }

    private void registerContext(EJBDeployInfo eJBDeployInfo, WsdlAddressInfo.PortAddress portAddress, String string) throws EJBDeploymentException {
        Object object;
        String string2 = null;
        String string3 = null;
        PortComponentBean portComponentBean = eJBDeployInfo.getWlPortComp();
        if (portComponentBean != null && (object = portComponentBean.getServiceEndpointAddress()) != null) {
            string2 = object.getWebserviceContextpath();
            string3 = object.getWebserviceServiceuri();
        }
        if (string2 == null) {
            string2 = eJBDeployInfo.getContextPathFromWsdl();
        } else if (eJBDeployInfo.getJwsClass() != null && eJBDeployInfo.getJwsClass().getName().equals(AsyncResponseBean.class.getName())) {
            try {
                object = new WSEEProperties(this.ejbDeploymentInfo.getModuleClassLoader());
                string2 = ((WSEEProperties)object).getNormalizedProperty("AsyncResponseBean.contextPath", string2);
                string3 = ((WSEEProperties)object).getNormalizedProperty("AsyncResponseBean.serviceUri", string3);
            }
            catch (IOException iOException) {
                throw new EJBDeploymentException(eJBDeployInfo.getEjbName(), this.moduleName, iOException);
            }
        }
        if (string2 == null) {
            throw new EJBDeploymentException(eJBDeployInfo.getEjbName(), this.moduleName, new WLDeploymentException("please specify contextpath and serviceURI information using weblogic-webservices.xml."));
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        eJBDeployInfo.setContextPath(string2);
        eJBDeployInfo.setApplication(this.ejbDeploymentInfo.getApplicationId());
        eJBDeployInfo.setSecurityRealmName(this.ejbDeploymentInfo.getSecurityRealmName());
        object = string2;
        if (string3 == null) {
            if (string != null) {
                string3 = "/" + string;
                object = string2 + string3;
                eJBDeployInfo.setServiceURIs(new String[]{string3, "/"});
            } else {
                string3 = "/";
                object = string2;
                eJBDeployInfo.setServiceURI(string3);
            }
        } else {
            if (!string3.startsWith("/")) {
                string3 = "/" + string3;
            }
            object = string2 + string3;
            eJBDeployInfo.setServiceURI(string3);
        }
        if (verbose) {
            Verbose.banner("Deploy Web Service EJB: " + eJBDeployInfo.getEjbName());
            Verbose.log("context path:" + string2);
            Verbose.log("service URI:" + string3);
        }
        WseeWebappModule wseeWebappModule = new WseeWebappModule(this.appCtx, this.getModuleName(), string2, (String)object, eJBDeployInfo, portComponentBean, this.ejbDeploymentInfo);
        this.wseeWebappModules.add(wseeWebappModule);
        if (this.sslRequired(portComponentBean)) {
            portAddress.setProtocol("https");
        } else {
            portAddress.setProtocol("http");
        }
        portAddress.setServiceuri((String)object);
    }

    private boolean sslRequired(PortComponentBean portComponentBean) {
        String string;
        return portComponentBean != null && (string = portComponentBean.getTransportGuarantee()) != null && ("INTEGRAL".equals(string = string.trim()) || "CONFIDENTIAL".equals(string));
    }

    @Override
    void activate() throws EJBDeploymentException {
        try {
            for (WseeWebappModule wseeWebappModule : this.wseeWebappModules) {
                wseeWebappModule.activate();
            }
        }
        catch (DeploymentException deploymentException) {
            throw new EJBDeploymentException(this.moduleName, this.moduleName, (Throwable)((Object)deploymentException));
        }
    }

    @Override
    void deactivate() {
        try {
            for (WseeWebappModule wseeWebappModule : this.wseeWebappModules) {
                wseeWebappModule.deactivate();
            }
        }
        catch (ModuleException moduleException) {
            moduleException.printStackTrace();
        }
    }

    @Override
    void destroy() throws DeploymentException {
        try {
            for (WseeWebappModule wseeWebappModule : this.wseeWebappModules) {
                wseeWebappModule.removeWebApp();
            }
        }
        catch (ModuleException moduleException) {
            moduleException.printStackTrace();
        }
        this.wseeWebappModules.clear();
        super.destroy();
    }

    @Override
    protected ClassLoader getClassLoader() {
        return this.ejbDeploymentInfo.getModuleClassLoader();
    }
}

