/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.deploy;

import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ApplicationContext;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.JavaWsdlMappingBean;
import weblogic.j2ee.descriptor.ServiceImplBeanBean;
import weblogic.j2ee.descriptor.WebservicesBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.OwsmSecurityPolicyBean;
import weblogic.j2ee.descriptor.wl.PortComponentBean;
import weblogic.j2ee.descriptor.wl.PortPolicyBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebservicesBean;
import weblogic.j2ee.descriptor.wl.WebserviceDescriptionBean;
import weblogic.j2ee.descriptor.wl.WebservicePolicyRefBean;
import weblogic.j2ee.descriptor.wl.WebserviceSecurityBean;
import weblogic.jws.security.WssConfiguration;
import weblogic.management.DeploymentException;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.deploy.SecurityRoleAndPolicyHelper;
import weblogic.wsee.deploy.WSEEAnnotationProcessor;
import weblogic.wsee.deploy.WSEEBaseModule;
import weblogic.wsee.deploy.WSEEDescriptor;
import weblogic.wsee.deploy.WsdlFilePublishHelper;
import weblogic.wsee.jws.VisitableJWS;
import weblogic.wsee.jws.VisitableJWSBuilder;
import weblogic.wsee.policy.deployment.PolicyBeanVisitor;
import weblogic.wsee.policy.deployment.PolicyDeployUtils;
import weblogic.wsee.policy.deployment.WsPolicyDescriptor;
import weblogic.wsee.policy.runtime.PolicyFinder;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.util.ClassUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlPort;

abstract class WSEEModule
extends WSEEBaseModule {
    static boolean verbose = Verbose.isVerbose(WSEEModule.class);
    Map<String, DeployInfo> deployInfoMap = new HashMap<String, DeployInfo>();
    Map serviceAndPorts = new HashMap();
    private Map loadedWsdl = new HashMap();
    ApplicationContext appCtx = null;
    private Map<String, Class> linkMap = new HashMap<String, Class>();
    private Map<String, String> endpointInterfaceMap = new HashMap<String, String>();
    private WsdlFilePublishHelper filePublish;

    abstract DeployInfo createDeployInfo();

    abstract String getModuleName();

    abstract WSEEDescriptor loadDescriptor(File var1, DeploymentPlanBean var2) throws IOException, XMLStreamException;

    abstract WsPolicyDescriptor loadWsPolicyDescriptor(File var1, DeploymentPlanBean var2) throws IOException, XMLStreamException;

    abstract void registerEndpoint(WebservicesBean var1) throws Exception;

    void wrapContextListeners() {
    }

    protected WSEEModule(ApplicationContext applicationContext) {
        this.appCtx = applicationContext;
    }

    void prepare() throws DeploymentException {
        try {
            Object object;
            Object object2;
            this.linkMap = this.getLinkMap();
            File file = null;
            DeploymentPlanBean deploymentPlanBean = null;
            if (this.appCtx != null) {
                object2 = this.appCtx.getAppDeploymentMBean();
                deploymentPlanBean = object2.getDeploymentPlanDescriptor();
                if (object2.getPlanDir() != null) {
                    file = new File(object2.getLocalPlanDir());
                }
            }
            object2 = this.getModuleName();
            WSEEDescriptor wSEEDescriptor = this.loadDescriptor(file, deploymentPlanBean);
            WebservicesBean webservicesBean = wSEEDescriptor.getWebservicesBean();
            WeblogicWebservicesBean weblogicWebservicesBean = wSEEDescriptor.getWeblogicWebservicesBean();
            if (weblogicWebservicesBean == null) {
                object = new EditableDescriptorManager();
                weblogicWebservicesBean = (WeblogicWebservicesBean)object.createDescriptorRoot(WeblogicWebservicesBean.class).getRootBean();
                weblogicWebservicesBean.setVersion("1.2");
            }
            if (this.noWebService(webservicesBean = ((WSEEAnnotationProcessor)(object = new WSEEAnnotationProcessor())).process(webservicesBean, weblogicWebservicesBean, this))) {
                return;
            }
            if (verbose) {
                Verbose.banner("Starting Deployment for " + this.getModuleName());
            }
            WsPolicyDescriptor wsPolicyDescriptor = this.loadWsPolicyDescriptor(file, deploymentPlanBean);
            WebservicePolicyRefBean webservicePolicyRefBean = wsPolicyDescriptor.getWebservicesPolicyBean();
            this.verifyWsdd(webservicesBean, webservicePolicyRefBean);
            if (verbose) {
                Verbose.log("Web Services Version: " + webservicesBean.getVersion());
                Verbose.log((String)object2 + "#weblogic-webservices.xml bean is " + weblogicWebservicesBean);
            }
            if (weblogicWebservicesBean != null) {
                this.verifyWlwsdd(weblogicWebservicesBean);
            }
            this.verifyOWSMPolicyWithJAXRPC(webservicePolicyRefBean, webservicesBean);
            this.wrapContextListeners();
            if (webservicesBean != null) {
                this.registerEndpoint(webservicesBean);
            }
            if (weblogicWebservicesBean != null && webservicesBean != null) {
                this.publishWsdlFile(webservicesBean, weblogicWebservicesBean);
            }
            String string = this.updateWssConfigInfo(weblogicWebservicesBean);
            this.deployRolesAndPolicy();
            this.loadPolicies(string);
        }
        catch (WsException wsException) {
            throw new DeploymentException("Error encountered during prepare phase of deploying WebService module '" + this.getModuleName() + "'. " + wsException.getMessage(), wsException);
        }
        catch (Exception exception) {
            throw new DeploymentException("Error encountered during prepare phase of deploying WebService module '" + this.getModuleName() + "'. " + exception.getMessage(), exception);
        }
    }

    protected abstract ClassLoader getClassLoader();

    private boolean noWebService(WebservicesBean webservicesBean) {
        return webservicesBean == null || webservicesBean.getWebserviceDescriptions() == null || webservicesBean.getWebserviceDescriptions().length == 0;
    }

    private void verifyWsdd(WebservicesBean webservicesBean, WebservicePolicyRefBean webservicePolicyRefBean) throws Exception {
        weblogic.j2ee.descriptor.WebserviceDescriptionBean[] webserviceDescriptionBeanArray;
        ServletAdapterList servletAdapterList = null;
        for (weblogic.j2ee.descriptor.WebserviceDescriptionBean webserviceDescriptionBean : webserviceDescriptionBeanArray = webservicesBean.getWebserviceDescriptions()) {
            weblogic.j2ee.descriptor.PortComponentBean[] portComponentBeanArray;
            WsdlDefinitions wsdlDefinitions = this.loadWsdl(webserviceDescriptionBean.getWsdlFile());
            JavaWsdlMappingBean javaWsdlMappingBean = this.loadMappingFile(webserviceDescriptionBean);
            String string = webserviceDescriptionBean.getWebserviceDescriptionName();
            HashMap<String, weblogic.j2ee.descriptor.PortComponentBean> hashMap = new HashMap<String, weblogic.j2ee.descriptor.PortComponentBean>();
            if (this.serviceAndPorts.containsKey(string)) {
                throw new WsException("Error encountered while deploying WebService module '" + this.getModuleName() + "'.  In webservices.xml, " + "webservice-description-name " + string + " is not unique within webservices.");
            }
            this.serviceAndPorts.put(string, hashMap);
            for (weblogic.j2ee.descriptor.PortComponentBean portComponentBean : portComponentBeanArray = webserviceDescriptionBean.getPortComponents()) {
                String string2 = portComponentBean.getPortComponentName();
                if (hashMap.containsKey(string2)) {
                    throw new WsException("Error encountered while deploying WebService module '" + this.getModuleName() + "'.  In webservices.xml, port-component-name " + string2 + "is not unique within webservice-description " + string);
                }
                hashMap.put(string2, portComponentBean);
                String string3 = portComponentBean.getServiceEndpointInterface();
                ServiceImplBeanBean serviceImplBeanBean = portComponentBean.getServiceImplBean();
                if (this.getLinkName(serviceImplBeanBean) != null) {
                    String string4 = this.getLinkName(serviceImplBeanBean);
                    if (this.deployInfoMap.keySet().contains(string4)) {
                        if (string3.equals(this.endpointInterfaceMap.get(string4))) continue;
                        throw new WsException("Error encountered while deploying WebService module '" + this.getModuleName() + "'.  Link: " + string4 + " is linked to multiple port-component.");
                    }
                    QName qName = portComponentBean.getWsdlPort();
                    if (verbose) {
                        Verbose.log("Deploying to " + qName);
                    }
                    DeployInfo deployInfo = this.createDeployInfo();
                    deployInfo.setServiceName(qName.getLocalPart());
                    deployInfo.setWebServiceDescriptionName(string);
                    deployInfo.setMappingdd(javaWsdlMappingBean);
                    deployInfo.setPortComp(portComponentBean);
                    deployInfo.setPolicyRef(webservicePolicyRefBean);
                    deployInfo.setWsdlDef(wsdlDefinitions);
                    deployInfo.setApplicationContext(this.appCtx);
                    deployInfo.setJwsClass(this.linkMap.get(string4));
                    deployInfo.setLinkName(string4);
                    deployInfo.setModuleName(this.getModuleName());
                    if (deployInfo.getWebServicesType() == WebServiceType.JAXWS) {
                        if (servletAdapterList == null) {
                            servletAdapterList = deployInfo.createServletAdapterList();
                        }
                        deployInfo.setAdpaterList(servletAdapterList);
                    }
                    WebservicePolicyRefBean webservicePolicyRefBean2 = webservicePolicyRefBean;
                    if (javaWsdlMappingBean == null && wsdlDefinitions != null) {
                        boolean bl;
                        boolean bl2 = bl = webservicePolicyRefBean2 == null || webservicePolicyRefBean2.getOperationPolicy().length == 0 && webservicePolicyRefBean2.getPortPolicy().length == 0;
                        if (bl) {
                            PolicyBeanVisitor policyBeanVisitor = new PolicyBeanVisitor();
                            Class clazz = string3 == null ? null : ClassUtil.loadClass(string3);
                            VisitableJWS visitableJWS = VisitableJWSBuilder.jaxws().sei(clazz).impl(deployInfo.getJwsClass()).portName(qName).build();
                            visitableJWS.accept(policyBeanVisitor);
                            webservicePolicyRefBean2 = policyBeanVisitor.getPolicyRefBean();
                        }
                    }
                    this.verifyWsPolicyRefBean(webservicePolicyRefBean2, deployInfo.getWebServicesType());
                    if (wsdlDefinitions != null) {
                        WsdlPort wsdlPort = wsdlDefinitions.getPorts().get(qName);
                        if (wsdlPort == null) {
                            throw new WsException("Error encountered while deploying WebService module '" + this.getModuleName() + "'.  port component '" + portComponentBean.getPortComponentName() + "'  - wsdl port:" + qName + " is not found in wsdl.");
                        }
                        if (webservicePolicyRefBean2 != null) {
                            PolicyDeployUtils.attachPolicy(webservicePolicyRefBean2, wsdlDefinitions, wsdlPort, string4);
                        }
                    }
                    this.deployInfoMap.put(string4, deployInfo);
                    this.endpointInterfaceMap.put(string4, string3);
                    continue;
                }
                throw new WsException("Error encountered while deploying WebService module '" + this.getModuleName() + "'.  Link not found for port:" + string2 + " in webservices.xml.");
            }
        }
    }

    private void verifyWlwsdd(WeblogicWebservicesBean weblogicWebservicesBean) throws WsException {
        WebserviceDescriptionBean[] webserviceDescriptionBeanArray = weblogicWebservicesBean.getWebserviceDescriptions();
        HashSet<String> hashSet = new HashSet<String>();
        for (WebserviceDescriptionBean webserviceDescriptionBean : webserviceDescriptionBeanArray) {
            PortComponentBean[] portComponentBeanArray = webserviceDescriptionBean.getPortComponents();
            String string = webserviceDescriptionBean.getWebserviceDescriptionName();
            if (!hashSet.add(string)) {
                throw new WsException("Error encountered while deploying WebService module '" + this.getModuleName() + "'.  In weblogic-webservices.xml, webservice-description-name " + string + " is not unique within weblogic-webservices");
            }
            Map map = (Map)this.serviceAndPorts.get(string);
            if (map == null) {
                throw new WsException("Error encountered while deploying WebService module '" + this.getModuleName() + "'.  webservice-description-name " + string + " referenced in weblogic-webservices.xml doesn't exist in webservices.xml.");
            }
            HashSet<String> hashSet2 = new HashSet<String>();
            for (PortComponentBean portComponentBean : portComponentBeanArray) {
                String string2 = portComponentBean.getPortComponentName();
                if (!hashSet2.add(string2)) {
                    throw new WsException("Error encountered while deploying WebService module '" + this.getModuleName() + "'. In weblogic-webservices.xml, port-component-name " + string2 + " is not unique within webservice-description " + string);
                }
                weblogic.j2ee.descriptor.PortComponentBean portComponentBean2 = (weblogic.j2ee.descriptor.PortComponentBean)map.get(string2);
                if (portComponentBean2 == null) {
                    throw new WsException("Error encountered while deploying WebService module '" + this.getModuleName() + "'. port-component-name " + string2 + " referenced in weblogic-webservices.xml doesn't exist in webservices.xml.");
                }
                String string3 = this.getLinkName(portComponentBean2.getServiceImplBean());
                DeployInfo deployInfo = this.deployInfoMap.get(string3);
                assert (deployInfo != null);
                deployInfo.setWebServicesType(this.getWebServiceType(webserviceDescriptionBean));
                deployInfo.setWlPortComp(portComponentBean);
            }
        }
    }

    private WebServiceType getWebServiceType(WebserviceDescriptionBean webserviceDescriptionBean) {
        String string = webserviceDescriptionBean.getWebserviceType();
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        return WebServiceType.valueOf(string);
    }

    private JavaWsdlMappingBean loadMappingFile(weblogic.j2ee.descriptor.WebserviceDescriptionBean webserviceDescriptionBean) throws WsException {
        String string = webserviceDescriptionBean.getJaxrpcMappingFile();
        JavaWsdlMappingBean javaWsdlMappingBean = null;
        if (!StringUtil.isEmpty(string)) {
            javaWsdlMappingBean = this.loadMappingFile(string);
        }
        return javaWsdlMappingBean;
    }

    WsdlDefinitions loadWsdl(String string) throws WsException {
        if (string == null) {
            return null;
        }
        WsdlDefinitions wsdlDefinitions = (WsdlDefinitions)this.loadedWsdl.get(string);
        if (wsdlDefinitions == null) {
            wsdlDefinitions = this.loadWsdlDefinitions(string);
            if (wsdlDefinitions == null) {
                return null;
            }
            this.loadedWsdl.put(string, wsdlDefinitions);
        }
        return wsdlDefinitions;
    }

    abstract WsdlDefinitions loadWsdlDefinitions(String var1) throws WsException;

    abstract JavaWsdlMappingBean loadMappingFile(String var1) throws WsException;

    private void publishWsdlFile(WebservicesBean webservicesBean, WeblogicWebservicesBean weblogicWebservicesBean) throws WsException {
        weblogic.j2ee.descriptor.WebserviceDescriptionBean[] webserviceDescriptionBeanArray;
        this.filePublish = new WsdlFilePublishHelper(weblogicWebservicesBean);
        for (weblogic.j2ee.descriptor.WebserviceDescriptionBean webserviceDescriptionBean : webserviceDescriptionBeanArray = webservicesBean.getWebserviceDescriptions()) {
            weblogic.j2ee.descriptor.PortComponentBean[] portComponentBeanArray = webserviceDescriptionBean.getPortComponents();
            String string = this.getLinkName(portComponentBeanArray[0].getServiceImplBean());
            DeployInfo deployInfo = this.deployInfoMap.get(string);
            WsdlDefinitions wsdlDefinitions = deployInfo.getWsdlDef();
            if (wsdlDefinitions == null) continue;
            try {
                String string2 = webserviceDescriptionBean.getWsdlFile();
                this.filePublish.publish(webserviceDescriptionBean.getWebserviceDescriptionName(), string2, wsdlDefinitions);
            }
            catch (IOException iOException) {
                throw new WsException("Error encountered while deploying WebService module '" + this.getModuleName() + "'.  Failed to publish wsdl " + iOException, iOException);
            }
        }
    }

    private String updateWssConfigInfo(WeblogicWebservicesBean weblogicWebservicesBean) {
        WebserviceSecurityBean webserviceSecurityBean = weblogicWebservicesBean != null ? weblogicWebservicesBean.getWebserviceSecurity() : null;
        String string = null;
        if (webserviceSecurityBean != null) {
            string = webserviceSecurityBean.getMbeanName();
        }
        for (DeployInfo deployInfo : this.deployInfoMap.values()) {
            WssConfiguration wssConfiguration;
            Class clazz;
            if (string == null && (clazz = deployInfo.getJwsClass()) != null && (wssConfiguration = clazz.getAnnotation(WssConfiguration.class)) != null) {
                string = wssConfiguration.value();
            }
            if (string == null) continue;
            deployInfo.setWssConfigMBeanName(string);
        }
        return string;
    }

    private void deployRolesAndPolicy() {
        for (DeployInfo deployInfo : this.deployInfoMap.values()) {
            SecurityRoleAndPolicyHelper securityRoleAndPolicyHelper = new SecurityRoleAndPolicyHelper(deployInfo);
            securityRoleAndPolicyHelper.deploySecurityRolesAndPolicies();
        }
    }

    abstract void loadModulePolicies(PolicyServer var1) throws Exception;

    private void loadPolicies(String string) throws Exception {
        WssPolicyContext wssPolicyContext = new WssPolicyContext(string);
        PolicyServer policyServer = wssPolicyContext.getPolicyServer();
        PolicyFinder.loadPolicies(Thread.currentThread().getContextClassLoader().getResource("policies"), policyServer);
        this.loadModulePolicies(policyServer);
        for (DeployInfo deployInfo : this.deployInfoMap.values()) {
            deployInfo.setWssPolicyContext(wssPolicyContext);
        }
    }

    void destroy() throws DeploymentException {
        if (this.filePublish != null) {
            this.filePublish.unpublishAll();
        }
        for (DeployInfo deployInfo : this.deployInfoMap.values()) {
            deployInfo.clean();
        }
    }

    void activate() throws DeploymentException {
    }

    void deactivate() throws DeploymentException {
    }

    private void verifyWsPolicyRefBean(WebservicePolicyRefBean webservicePolicyRefBean, WebServiceType webServiceType) throws Exception {
        if (webservicePolicyRefBean == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        block0: for (PortPolicyBean portPolicyBean : webservicePolicyRefBean.getPortPolicy()) {
            if (portPolicyBean.getOwsmSecurityPolicy() != null && portPolicyBean.getOwsmSecurityPolicy().length > 0) {
                for (OwsmSecurityPolicyBean owsmSecurityPolicyBean : portPolicyBean.getOwsmSecurityPolicy()) {
                    if (!owsmSecurityPolicyBean.getStatus().equals("enabled")) continue;
                    bl2 = true;
                    break;
                }
            }
            if (portPolicyBean.getWsPolicy() == null || portPolicyBean.getWsPolicy().length <= 0) continue;
            for (OwsmSecurityPolicyBean owsmSecurityPolicyBean : portPolicyBean.getWsPolicy()) {
                if (!owsmSecurityPolicyBean.getStatus().equals("enabled")) continue;
                bl = true;
                continue block0;
            }
        }
        for (PortPolicyBean portPolicyBean : webservicePolicyRefBean.getOperationPolicy()) {
            if (portPolicyBean.getWsPolicy() == null || portPolicyBean.getWsPolicy().length <= 0) continue;
            bl = true;
        }
        if (WebServiceType.JAXRPC == webServiceType & bl2) {
            throw new WsException("Error encountered while deploying WebService module '" + this.getModuleName() + "'.  OWSM Security Policy can not be used to a JAX-RPC WebService Endpoint.");
        }
        if (bl & bl2) {
            throw new WsException("Error encountered while deploying WebService module '" + this.getModuleName() + "'.  OWSM Security Policy and WebLogic WebServices Policy can not be attached to a WebService Endpoint at the same time.");
        }
    }

    private void verifyOWSMPolicyWithJAXRPC(WebservicePolicyRefBean webservicePolicyRefBean, WebservicesBean webservicesBean) throws Exception {
        for (weblogic.j2ee.descriptor.WebserviceDescriptionBean webserviceDescriptionBean : webservicesBean.getWebserviceDescriptions()) {
            for (weblogic.j2ee.descriptor.PortComponentBean portComponentBean : webserviceDescriptionBean.getPortComponents()) {
                for (PortPolicyBean portPolicyBean : webservicePolicyRefBean.getPortPolicy()) {
                    if (portPolicyBean.getPortName() == null || !portPolicyBean.getPortName().equals(portComponentBean.getPortComponentName()) || portPolicyBean.getOwsmSecurityPolicy() == null || portPolicyBean.getOwsmSecurityPolicy().length <= 0 || WebServiceType.JAXRPC != this.deployInfoMap.get(this.getLinkName(portComponentBean.getServiceImplBean())).getWebServicesType()) continue;
                    throw new WsException("Error encountered while deploying WebService module '" + this.getModuleName() + "'.  " + "OWSM Security Policy can not be used with a JAX-RPC WebService Endpoint.");
                }
            }
        }
    }
}

