/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import weblogic.wsee.util.Verbose;

public class WSEEProperties {
    public static final String NAME = "app-weblogic-webservices.xml";
    public static final String ASYNC_CP = "AsyncResponseBean.contextPath";
    public static final String ASYNC_SU = "AsyncResponseBean.serviceUri";
    private Properties props = new Properties();
    private static boolean verbose = Verbose.isVerbose(WSEEProperties.class);

    public WSEEProperties(ClassLoader classLoader) throws IOException {
        InputStream inputStream = classLoader.getResourceAsStream(NAME);
        if (inputStream != null) {
            this.load(inputStream);
        } else if (verbose) {
            Verbose.log("app-weblogic-webservices.xml was not found in the given classLoader: " + classLoader.toString());
        }
    }

    public WSEEProperties(File file) throws IOException {
        File file2 = this.buildFile(file);
        if (file2.exists()) {
            this.load(new FileInputStream(file2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(InputStream inputStream) throws IOException {
        try {
            this.props.loadFromXML(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public void setProperty(String string, String string2) {
        this.props.setProperty(string, string2);
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        File file2 = this.buildFile(file);
        if (file2.exists() && !file2.delete()) {
            throw new IOException("Unable to delete app-weblogic-webservices.xml");
        }
        file.mkdirs();
        file2.createNewFile();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
            this.props.storeToXML(fileOutputStream, "Created by WebLogic. Do not edit.");
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    private File buildFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("dir is null");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("dir must be a directory");
        }
        return new File(file, NAME);
    }

    public String getNormalizedProperty(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (string2 == null) {
            return null;
        }
        if (verbose) {
            Verbose.log("Getting deployment property: " + string);
        }
        String string3 = this.props.getProperty(string, "");
        if (verbose) {
            Verbose.log(string + " value = " + string3);
        }
        return string2.replace("@" + string + "@", string3);
    }
}

