/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.deploy;

import com.bea.objectweb.asm.ClassWriter;
import com.bea.objectweb.asm.FieldVisitor;
import com.bea.objectweb.asm.Label;
import com.bea.objectweb.asm.MethodVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.xml.stream.XMLStreamException;
import weblogic.descriptor.DescriptorManager;
import weblogic.j2ee.descriptor.EnvEntryBean;
import weblogic.j2ee.descriptor.JavaWsdlMappingBean;
import weblogic.j2ee.descriptor.ListenerBean;
import weblogic.j2ee.descriptor.PortComponentBean;
import weblogic.j2ee.descriptor.ServiceImplBeanBean;
import weblogic.j2ee.descriptor.ServletBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.WebserviceDescriptionBean;
import weblogic.j2ee.descriptor.WebservicesBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.management.DeploymentException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.runtime.ServletRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.servlet.internal.WarSource;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.security.Utils;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.deploy.ServletContextRelativeResourceResolver;
import weblogic.wsee.deploy.ServletDeployInfo;
import weblogic.wsee.deploy.WSEEDescriptor;
import weblogic.wsee.deploy.WSEEModule;
import weblogic.wsee.deploy.WSEEServletEndpointException;
import weblogic.wsee.deploy.WsdlAddressInfo;
import weblogic.wsee.policy.deployment.WsPolicyDescriptor;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyFinder;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlFactory;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlUtils;
import weblogic.xml.schema.binding.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WSEEWebModule
extends WSEEModule {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private WebAppServletContext svltCtx = null;
    private static final Method defineClass;
    private static final Method resolveClass;

    WSEEWebModule(WebAppServletContext webAppServletContext) {
        super(webAppServletContext.getApplicationContext());
        this.svltCtx = webAppServletContext;
    }

    @Override
    DeployInfo createDeployInfo() {
        ServletDeployInfo servletDeployInfo = new ServletDeployInfo();
        servletDeployInfo.setServletContext(this.svltCtx);
        return servletDeployInfo;
    }

    @Override
    String getModuleName() {
        return this.svltCtx.getWebAppModule().getModuleURI();
    }

    @Override
    WSEEDescriptor loadDescriptor(File file, DeploymentPlanBean deploymentPlanBean) throws IOException, XMLStreamException {
        return new WSEEDescriptor(this.svltCtx, file, deploymentPlanBean, this.getModuleName());
    }

    @Override
    WsPolicyDescriptor loadWsPolicyDescriptor(File file, DeploymentPlanBean deploymentPlanBean) throws IOException, XMLStreamException {
        return new WsPolicyDescriptor(this.svltCtx, file, deploymentPlanBean, this.getModuleName());
    }

    @Override
    protected String getLinkName(ServiceImplBeanBean serviceImplBeanBean) {
        return serviceImplBeanBean.getServletLink();
    }

    @Override
    protected void setLinkName(ServiceImplBeanBean serviceImplBeanBean, String string) {
        serviceImplBeanBean.setServletLink(string);
    }

    @Override
    protected EnvEntryBean[] getEnvEntries(ServiceImplBeanBean serviceImplBeanBean) {
        return this.svltCtx.getWebAppModule().getWebAppBean().getEnvEntries();
    }

    @Override
    protected Map<String, Class> getLinkMap() {
        HashMap<String, Class> hashMap = new HashMap<String, Class>();
        ServletBean[] servletBeanArray = this.svltCtx.getWebAppModule().getWebAppBean().getServlets();
        if (servletBeanArray != null) {
            for (ServletBean servletBean : servletBeanArray) {
                try {
                    String string = servletBean.getServletClass();
                    if (StringUtil.isEmpty(string)) continue;
                    hashMap.put(servletBean.getServletName(), ClassUtil.loadClass((String)string));
                }
                catch (Exception exception) {
                    System.err.println("When processing WebService module '" + this.getModuleName() + "'.  Failed to load servlet Class: " + servletBean.getServletClass());
                    System.err.println("Ignoring: " + exception.getMessage() + " at: " + exception.getStackTrace()[0].toString());
                }
            }
        }
        return hashMap;
    }

    @Override
    WsdlDefinitions loadWsdlDefinitions(String string) throws WsException {
        URL uRL;
        WarSource warSource = this.svltCtx.getResourceAsSource(string);
        if (warSource == null && !string.startsWith("/")) {
            warSource = this.svltCtx.getResourceAsSource("/" + string);
        }
        if (warSource == null && !string.toUpperCase(Locale.ENGLISH).startsWith("/WEB-INF")) {
            warSource = this.svltCtx.getResourceAsSource("/WEB-INF" + (string.startsWith("/") ? "" : "/") + string);
        }
        URL uRL2 = uRL = warSource == null ? this.svltCtx.getServletClassLoader().getResource(string) : warSource.getURL();
        if (uRL == null && string.toUpperCase(Locale.ENGLISH).startsWith("/WEB-INF/")) {
            uRL = this.svltCtx.getServletClassLoader().getResource(string.substring(8));
        }
        if (uRL == null && string.toUpperCase(Locale.ENGLISH).startsWith("WEB-INF/")) {
            uRL = this.svltCtx.getServletClassLoader().getResource(string.substring(7));
        }
        if (uRL == null) {
            return null;
        }
        try {
            return WsdlFactory.getInstance().parse(uRL.toString(), new ServletContextRelativeResourceResolver(this.svltCtx));
        }
        catch (WsdlException wsdlException) {
            throw new WsException("While deploying WebService module '" + this.getModuleName() + "'.  Error encountered while attempting to Load WSDL Definitions for WSDL: '" + uRL.toString() + "'.  " + wsdlException.getMessage(), wsdlException);
        }
    }

    @Override
    JavaWsdlMappingBean loadMappingFile(String string) throws WsException {
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        InputStream inputStream = this.svltCtx.getResourceAsStream(string);
        if (inputStream == null) {
            return null;
        }
        try {
            JavaWsdlMappingBean javaWsdlMappingBean;
            DescriptorManager descriptorManager = new DescriptorManager();
            JavaWsdlMappingBean javaWsdlMappingBean2 = javaWsdlMappingBean = (JavaWsdlMappingBean)descriptorManager.createDescriptor(inputStream).getRootBean();
            return javaWsdlMappingBean2;
        }
        catch (IOException iOException) {
            throw new WsException("While deploying WebService module '" + this.getModuleName() + "'.  Error encountered while attemping to load Java-WSDL mapping file: '" + string + "'.  " + iOException.getMessage(), iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    @Override
    void wrapContextListeners() {
        ListenerBean[] listenerBeanArray;
        WebAppBean webAppBean;
        boolean bl = false;
        if (this.deployInfoMap != null) {
            webAppBean = this.deployInfoMap.values().iterator();
            while (webAppBean.hasNext()) {
                listenerBeanArray = (ListenerBean[])webAppBean.next();
                if (listenerBeanArray.getWebServicesType() != WebServiceType.JAXWS) continue;
                bl = true;
                break;
            }
        }
        if (bl && (webAppBean = this.svltCtx.getWebAppModule().getWebAppBean()) != null && (listenerBeanArray = webAppBean.getListeners()) != null) {
            for (ListenerBean listenerBean : listenerBeanArray) {
                if (!"org.springframework.web.context.ContextLoaderListener".equals(listenerBean.getListenerClass())) continue;
                listenerBean.setListenerClass(this.createListenerClassWrapper(listenerBean.getListenerClass()));
            }
        }
    }

    @Override
    void registerEndpoint(WebservicesBean webservicesBean) throws Exception {
        this.swapServlets();
        this.updateAddress(webservicesBean);
        this.setInfoAsAttribute();
    }

    private void setInfoAsAttribute() {
        for (Map.Entry entry : this.deployInfoMap.entrySet()) {
            ServletDeployInfo servletDeployInfo = (ServletDeployInfo)entry.getValue();
            servletDeployInfo.store(this.svltCtx);
        }
    }

    private void swapServlets() throws ServletException {
        for (DeployInfo deployInfo : this.deployInfoMap.values()) {
            String string = deployInfo.getServlet();
            this.svltCtx.swapServlet(deployInfo.getLinkName(), string, null);
            if (!verbose) continue;
            Verbose.log("Swapping in " + string + " for " + deployInfo.getLinkName());
        }
    }

    private void bindInternalPort(WebAppServletContext webAppServletContext, PortComponentBean portComponentBean, WsdlPort wsdlPort) throws WsException {
        String string = webAppServletContext.getWebAppModule().getId();
        String string2 = "wsee/" + string + "#" + portComponentBean.getPortComponentName();
        try {
            Context context = webAppServletContext.getApplicationContext().getEnvContext();
            context.bind(string2, (Object)wsdlPort);
        }
        catch (NamingException namingException) {
            throw new WsException("While deploying WebService module '" + this.getModuleName() + "'.  Failed to bind wsdl port to internal name " + string2 + " " + namingException, namingException);
        }
    }

    private void updateAddress(WebservicesBean webservicesBean) throws WsException {
        ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        String string = "" + serverRuntimeMBean.getSSLListenPort();
        for (WebserviceDescriptionBean webserviceDescriptionBean : webservicesBean.getWebserviceDescriptions()) {
            WsdlDefinitions wsdlDefinitions = null;
            WsdlAddressInfo wsdlAddressInfo = new WsdlAddressInfo();
            for (PortComponentBean portComponentBean : webserviceDescriptionBean.getPortComponents()) {
                WsdlPort wsdlPort;
                WsdlAddressInfo.PortAddress portAddress = wsdlAddressInfo.addWsdlPort(portComponentBean.getWsdlPort());
                String string2 = portComponentBean.getServiceImplBean().getServletLink();
                ServletDeployInfo servletDeployInfo = (ServletDeployInfo)this.deployInfoMap.get(string2);
                String[] stringArray = this.getUrlPattern(this.svltCtx, string2);
                if (servletDeployInfo != null) {
                    servletDeployInfo.setServiceURIs(stringArray);
                    wsdlDefinitions = servletDeployInfo.getWsdlDef();
                }
                if (wsdlDefinitions == null) continue;
                String string3 = this.svltCtx.getContextPath();
                String string4 = stringArray[0];
                String string5 = AsyncUtil.calculateServiceTargetURI(string3, string4);
                portAddress.setServiceuri(string5);
                if (verbose) {
                    Verbose.say("Updated service URI in address of port component " + portComponentBean.getWsdlPort() + " to: " + string5);
                }
                if ((wsdlPort = wsdlDefinitions.getPorts().get(portComponentBean.getWsdlPort())).getTransport().startsWith("http")) {
                    if (this.isSSLRequired(this.svltCtx, servletDeployInfo)) {
                        portAddress.setProtocol("https");
                        portAddress.setListenPort(string);
                    } else {
                        portAddress.setProtocol("http");
                    }
                } else {
                    portAddress.setProtocol(wsdlPort.getTransport());
                }
                wsdlPort.setPortAddress(portAddress);
                this.bindInternalPort(this.svltCtx, portComponentBean, wsdlPort);
            }
            if (wsdlDefinitions == null) continue;
            WsdlUtils.updateAddress(wsdlDefinitions, wsdlAddressInfo);
        }
    }

    private String[] getUrlPattern(WebAppServletContext webAppServletContext, String string) {
        ServletRuntimeMBean[] servletRuntimeMBeanArray = webAppServletContext.getServletRuntimeMBeans();
        for (int i = 0; i < servletRuntimeMBeanArray.length; ++i) {
            if (!servletRuntimeMBeanArray[i].getServletName().equals(string)) continue;
            String[] stringArray = servletRuntimeMBeanArray[i].getURLPatterns();
            if (stringArray.length == 0) {
                stringArray = new String[]{"/"};
            }
            return stringArray;
        }
        throw new WSEEServletEndpointException("While deploying WebService module '" + this.getModuleName() + "'. Internal error, failed to find " + "ServletRuntimeMBean for servlet " + string);
    }

    private boolean isSSLRequired(WebAppServletContext webAppServletContext, ServletDeployInfo servletDeployInfo) {
        String[] stringArray = servletDeployInfo.getServiceURIs();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!Utils.isSSLRequired(webAppServletContext, string, "POST")) continue;
            return true;
        }
        return false;
    }

    @Override
    void destroy() throws DeploymentException {
        super.destroy();
        this.unbindInternalPorts(this.svltCtx);
    }

    @Override
    protected ClassLoader getClassLoader() {
        return this.svltCtx.getWebAppModule().getClassLoader();
    }

    @Override
    void loadModulePolicies(PolicyServer policyServer) throws MalformedURLException, PolicyException {
        URL uRL = this.svltCtx.getResource("/WEB-INF/policies");
        PolicyFinder.loadPolicies(uRL, policyServer);
    }

    private void unbindInternalPorts(WebAppServletContext webAppServletContext) throws DeploymentException {
        String string = webAppServletContext.getWebAppModule().getId();
        Context context = webAppServletContext.getApplicationContext().getEnvContext();
        for (Map map : this.serviceAndPorts.values()) {
            for (PortComponentBean portComponentBean : map.values()) {
                String string2 = "wsee/" + string + "#" + portComponentBean.getPortComponentName();
                try {
                    context.unbind(string2);
                }
                catch (NamingException namingException) {
                    throw new DeploymentException("While deploying WebService module '" + this.getModuleName() + "'.  Failed to unbind wsdl port named " + string2 + " " + namingException, namingException);
                }
            }
        }
    }

    private String createListenerClassWrapper(String string) {
        try {
            ClassLoader classLoader = this.svltCtx.getServletClassLoader();
            Class<?> clazz = classLoader.loadClass(string);
            String string2 = "com.oracle.weblogic.wsee.wrapper." + string;
            ClassWriter classWriter = new ClassWriter(0);
            HashSet<String> hashSet = new HashSet<String>();
            Class<?> clazz2 = clazz;
            do {
                for (Class<?> object2 : clazz2.getInterfaces()) {
                    hashSet.add(WSEEWebModule.replaceDotWithSlash(object2.getName()));
                }
            } while ((clazz2 = clazz2.getSuperclass()) != null);
            classWriter.visit(49, 33, WSEEWebModule.replaceDotWithSlash(string2), null, "java/lang/Object", hashSet.toArray(new String[hashSet.size()]));
            FieldVisitor fieldVisitor = classWriter.visitField(2, "target", "L" + WSEEWebModule.replaceDotWithSlash(string) + ";", null, null);
            fieldVisitor.visitEnd();
            fieldVisitor = classWriter.visitField(2, "factory", "Lweblogic/wsee/util/JAXWSClassLoaderFactory;", null, null);
            fieldVisitor.visitEnd();
            MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitTypeInsn(187, WSEEWebModule.replaceDotWithSlash(string));
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(183, WSEEWebModule.replaceDotWithSlash(string), "<init>", "()V");
            methodVisitor.visitFieldInsn(181, WSEEWebModule.replaceDotWithSlash(string2), "target", "L" + WSEEWebModule.replaceDotWithSlash(string) + ";");
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(184, "weblogic/wsee/util/JAXWSClassLoaderFactory", "getInstance", "()Lweblogic/wsee/util/JAXWSClassLoaderFactory;");
            methodVisitor.visitFieldInsn(181, WSEEWebModule.replaceDotWithSlash(string2), "factory", "Lweblogic/wsee/util/JAXWSClassLoaderFactory;");
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(3, 1);
            methodVisitor.visitEnd();
            HashSet<Method> hashSet2 = new HashSet<Method>();
            clazz2 = clazz;
            do {
                for (Class<?> clazz3 : clazz2.getInterfaces()) {
                    for (Method method : clazz3.getMethods()) {
                        hashSet2.add(method);
                    }
                }
            } while ((clazz2 = clazz2.getSuperclass()) != null);
            for (Method method : hashSet2) {
                methodVisitor = classWriter.visitMethod(1, method.getName(), "(L" + WSEEWebModule.replaceDotWithSlash(method.getParameterTypes()[0].getName()) + ";)V", null, null);
                methodVisitor.visitCode();
                Label label = new Label();
                Label label2 = new Label();
                Label label3 = new Label();
                methodVisitor.visitTryCatchBlock(label, label2, label3, null);
                Label label4 = new Label();
                methodVisitor.visitTryCatchBlock(label3, label4, label3, null);
                methodVisitor.visitMethodInsn(184, "java/lang/Thread", "currentThread", "()Ljava/lang/Thread;");
                methodVisitor.visitMethodInsn(182, "java/lang/Thread", "getContextClassLoader", "()Ljava/lang/ClassLoader;");
                methodVisitor.visitVarInsn(58, 2);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, WSEEWebModule.replaceDotWithSlash(string2), "factory", "Lweblogic/wsee/util/JAXWSClassLoaderFactory;");
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(182, "weblogic/wsee/util/JAXWSClassLoaderFactory", "setContextLoader", "(Ljava/lang/ClassLoader;)V");
                methodVisitor.visitLabel(label);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, WSEEWebModule.replaceDotWithSlash(string2), "target", "L" + WSEEWebModule.replaceDotWithSlash(string) + ";");
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitMethodInsn(182, WSEEWebModule.replaceDotWithSlash(string), method.getName(), "(L" + WSEEWebModule.replaceDotWithSlash(method.getParameterTypes()[0].getName()) + ";)V");
                methodVisitor.visitLabel(label2);
                methodVisitor.visitMethodInsn(184, "java/lang/Thread", "currentThread", "()Ljava/lang/Thread;");
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(182, "java/lang/Thread", "setContextClassLoader", "(Ljava/lang/ClassLoader;)V");
                Label label5 = new Label();
                methodVisitor.visitJumpInsn(167, label5);
                methodVisitor.visitLabel(label3);
                methodVisitor.visitVarInsn(58, 3);
                methodVisitor.visitLabel(label4);
                methodVisitor.visitMethodInsn(184, "java/lang/Thread", "currentThread", "()Ljava/lang/Thread;");
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(182, "java/lang/Thread", "setContextClassLoader", "(Ljava/lang/ClassLoader;)V");
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitInsn(191);
                methodVisitor.visitLabel(label5);
                methodVisitor.visitInsn(177);
                methodVisitor.visitMaxs(2, 4);
                methodVisitor.visitEnd();
            }
            classWriter.visitEnd();
            byte[] byArray = classWriter.toByteArray();
            Class clazz4 = (Class)defineClass.invoke((Object)classLoader, string2, byArray, 0, byArray.length, clazz.getProtectionDomain());
            resolveClass.invoke((Object)classLoader, clazz4);
            return string2;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return string;
    }

    private static String replaceDotWithSlash(String string) {
        return string.replace('.', '/');
    }

    static {
        try {
            defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
            resolveClass = ClassLoader.class.getDeclaredMethod("resolveClass", Class.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                defineClass.setAccessible(true);
                resolveClass.setAccessible(true);
                return null;
            }
        });
    }
}

