/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.deploy;

import javax.naming.Context;
import weblogic.application.ApplicationContext;
import weblogic.ejb.spi.DeploymentInfo;
import weblogic.ejb.spi.EJBDeployListener;
import weblogic.ejb.spi.EJBDeploymentException;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.EJBComponentMBean;
import weblogic.wsee.deploy.AppDeploymentExtensionFactory;
import weblogic.wsee.deploy.WSEEEjbModule;

public class WsEJBDeployListener
implements EJBDeployListener {
    private WSEEEjbModule wseeEjbModule;
    private boolean prepared = false;
    private ApplicationContext appCtx;

    public void init(ApplicationContext applicationContext, EJBComponentMBean eJBComponentMBean) throws EJBDeploymentException {
        String string = null;
        if (eJBComponentMBean != null) {
            string = eJBComponentMBean.getURI();
        }
        this.appCtx = applicationContext;
        this.wseeEjbModule = new WSEEEjbModule(string, applicationContext);
    }

    public void prepare(DeploymentInfo deploymentInfo, EjbDescriptorBean ejbDescriptorBean, ApplicationContext applicationContext) throws EJBDeploymentException {
        this.wseeEjbModule.setEjbDeploymentInfo(deploymentInfo);
        this.wseeEjbModule.setEjbDescriptorBean(ejbDescriptorBean);
        try {
            AppDeploymentExtensionFactory.INSTANCE.addModule(applicationContext, this.wseeEjbModule);
        }
        catch (DeploymentException deploymentException) {
            throw new RuntimeException((Throwable)((Object)deploymentException));
        }
        this.prepared = true;
    }

    public void activate(EjbDescriptorBean ejbDescriptorBean, ClassLoader classLoader, Context context) throws EJBDeploymentException {
    }

    public void deactivate() {
    }

    public void unprepare() {
        if (this.prepared) {
            try {
                AppDeploymentExtensionFactory.INSTANCE.removeModule(this.appCtx, this.wseeEjbModule);
            }
            catch (DeploymentException deploymentException) {
                throw new RuntimeException((Throwable)((Object)deploymentException));
            }
            this.wseeEjbModule = null;
            this.appCtx = null;
            this.prepared = false;
        }
    }
}

