/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.deploy;

import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryProvider;
import weblogic.j2ee.descriptor.PortComponentBean;
import weblogic.j2ee.descriptor.WebserviceDescriptionBean;
import weblogic.j2ee.descriptor.WebservicesBean;
import weblogic.jws.Callback;
import weblogic.jws.Conversation;
import weblogic.jws.Conversational;
import weblogic.jws.ServiceClient;
import weblogic.jws.WLJmsTransport;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.reliability.policy.ReliabilityPolicyAssertionsFactory;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPort;

public class WsVersionChecker {
    private static boolean verbose = Verbose.isVerbose(WsVersionChecker.class);
    private static boolean DEBUG = false;
    private static boolean EXTRADEBUG = false;
    private static final String CONTROL_ANNOTATION = "org.apache.beehive.controls.api.bean.Control";
    private static final String ASYNCEJBLIB_REFERENCE_NAME = "bea_wls_async_response";

    private static void p(String string) {
        System.out.println(string);
        System.out.flush();
    }

    private static boolean referencesAsyncEJB(ApplicationContextInternal applicationContextInternal) {
        LibraryProvider libraryProvider = applicationContextInternal.getLibraryProvider(null);
        String string = applicationContextInternal.getAppDeploymentMBean().getName();
        if (libraryProvider != null) {
            Library[] libraryArray = libraryProvider.getReferencedLibraries();
            for (int i = 0; i < libraryArray.length; ++i) {
                if (!libraryArray[i].getName().equals(ASYNCEJBLIB_REFERENCE_NAME)) continue;
                if (verbose) {
                    Verbose.log("Application " + string + " references the async response EJB");
                }
                return true;
            }
        }
        if (verbose) {
            Verbose.log("Application " + string + " does not reference the async response EJB");
        }
        return false;
    }

    private static void printAllAnnotations(Class clazz, PrintWriter printWriter) {
        Annotation[] annotationArray = clazz.getAnnotations();
        printWriter.println("Annotations for class " + clazz.getName());
        if (annotationArray.length != 0) {
            printWriter.println("Class Annotations: ");
            for (int i = 0; i < annotationArray.length; ++i) {
                printWriter.println("\nclass annotation[" + i + "]");
                printWriter.println("\t" + annotationArray[i]);
            }
        }
        printWriter.println("\n\n");
        printWriter.println("Method Annotations:");
        Method[] methodArray = clazz.getMethods();
        if (methodArray.length == 0) {
            printWriter.println("\tNo methods");
        } else {
            for (int i = 0; i < methodArray.length; ++i) {
                Annotation[] annotationArray2 = methodArray[i].getAnnotations();
                if (annotationArray2.length == 0) continue;
                printWriter.println("\nMethod " + methodArray[i].getName());
                for (int j = 0; j < annotationArray2.length; ++j) {
                    printWriter.println("\n\tMethod annotation[" + j + "]");
                    printWriter.println("\t" + annotationArray2[j]);
                }
            }
        }
        printWriter.println("\n\n");
        printWriter.println("Field Annotations:");
        Field[] fieldArray = clazz.getFields();
        if (fieldArray.length == 0) {
            printWriter.println("\tNo fields");
        } else {
            for (int i = 0; i < fieldArray.length; ++i) {
                Annotation[] annotationArray3 = fieldArray[i].getAnnotations();
                if (annotationArray3.length == 0) continue;
                printWriter.println("\nField " + fieldArray[i].getName());
                for (int j = 0; j < annotationArray3.length; ++j) {
                    printWriter.println("\n\tField annotation[" + j + "]");
                    printWriter.println("\t" + annotationArray[j]);
                }
            }
        }
    }

    public static boolean check901SBSCompatibility(ApplicationContextInternal applicationContextInternal, Map map, WebservicesBean webservicesBean, boolean bl) throws PolicyException {
        Object object;
        PortComponentBean[] portComponentBeanArray;
        if (verbose) {
            Verbose.log("Checking 901 restricted SBS compliance");
        }
        assert (!map.isEmpty()) : "deploy info map is empty";
        for (DeployInfo deployInfo : map.values()) {
            portComponentBeanArray = deployInfo.getJwsClass();
            String string = portComponentBeanArray.getName();
            if (DEBUG) {
                WsVersionChecker.p("Analyzing .. " + string);
            }
            object = portComponentBeanArray.getAnnotations();
            assert (((Annotation[])object).length > 0) : "No annotations in " + string;
            if (EXTRADEBUG) {
                WsVersionChecker.printAllAnnotations((Class)portComponentBeanArray, new PrintWriter(System.out, true));
            }
            if (WsVersionChecker.isConversational((Class)portComponentBeanArray)) {
                if (DEBUG || verbose) {
                    Verbose.log(string + " has conversation annotations");
                }
                return false;
            }
            if (WsVersionChecker.hasServiceClient((Class)portComponentBeanArray) && WsVersionChecker.referencesAsyncEJB(applicationContextInternal)) {
                if (DEBUG || verbose) {
                    Verbose.log(string + " has service client annotations and also references async library ");
                }
                return false;
            }
            if (WsVersionChecker.hasControl((Class)portComponentBeanArray)) {
                if (DEBUG || verbose) {
                    Verbose.log(string + " has control annotations");
                }
                return false;
            }
            if (!WsVersionChecker.hasJMSTransport((Class)portComponentBeanArray)) continue;
            if (DEBUG || verbose) {
                Verbose.log(string + " uses JMS transport");
            }
            return false;
        }
        if (DEBUG) {
            WsVersionChecker.p("Now analyzing Webservice descriptions for RM policies");
        }
        WebserviceDescriptionBean[] webserviceDescriptionBeanArray = webservicesBean.getWebserviceDescriptions();
        for (int i = 0; i < webserviceDescriptionBeanArray.length; ++i) {
            if (DEBUG) {
                WsVersionChecker.p("Analyzing description " + webserviceDescriptionBeanArray[i].getWebserviceDescriptionName());
            }
            portComponentBeanArray = webserviceDescriptionBeanArray[i].getPortComponents();
            if (DEBUG) {
                WsVersionChecker.p("Port components = " + portComponentBeanArray.length);
            }
            for (int j = 0; j < portComponentBeanArray.length; ++j) {
                DeployInfo deployInfo;
                if (bl) {
                    object = portComponentBeanArray[j].getServiceImplBean().getServletLink();
                    if (DEBUG) {
                        WsVersionChecker.p("servlet name = " + (String)object);
                    }
                } else {
                    object = portComponentBeanArray[j].getServiceImplBean().getEjbLink();
                    if (DEBUG) {
                        WsVersionChecker.p("ejb name = " + (String)object);
                    }
                }
                if ((deployInfo = (DeployInfo)map.get(object)) == null) continue;
                WsdlDefinitions wsdlDefinitions = deployInfo.getWsdlDef();
                WsdlPort wsdlPort = wsdlDefinitions.getPorts().get(deployInfo.getPortComp().getWsdlPort());
                for (WsdlOperation wsdlOperation : wsdlPort.getPortType().getOperations().values()) {
                    WssPolicyContext wssPolicyContext;
                    PolicyServer policyServer;
                    WsdlBindingOperation wsdlBindingOperation;
                    NormalizedExpression normalizedExpression = PolicyContext.getRequestEffectivePolicy(wsdlPort, wsdlOperation, wsdlBindingOperation = wsdlPort.getBinding().getOperations().get(wsdlOperation.getName()), policyServer = (wssPolicyContext = new WssPolicyContext(deployInfo.getWssConfigMBeanName())).getPolicyServer(), policyServer.getCachedPolicies());
                    if (ReliabilityPolicyAssertionsFactory.hasRMPolicy(normalizedExpression)) {
                        if (DEBUG || verbose) {
                            Verbose.log(wsdlPort.getService() + ":" + wsdlOperation.getName() + " has RM policy assertions");
                        }
                        return false;
                    }
                    if (!DEBUG && !verbose) continue;
                    Verbose.log(wsdlPort.getService() + ":" + wsdlOperation.getName() + " does not have RM policy assertions");
                }
            }
        }
        return true;
    }

    public static boolean isConversational(Class clazz) {
        boolean bl = false;
        if (clazz == null) {
            return false;
        }
        if (clazz.getAnnotation(Conversational.class) != null) {
            if (DEBUG) {
                WsVersionChecker.p("Class " + clazz.getName() + " has conversational annotations");
            }
            bl = true;
        } else {
            AnnotatedElement[] annotatedElementArray = clazz.getMethods();
            bl = WsVersionChecker.hasAnnotation(annotatedElementArray, Conversation.class);
        }
        return bl;
    }

    private static boolean hasAnnotation(AnnotatedElement[] annotatedElementArray, Class clazz) {
        if (annotatedElementArray == null) {
            return false;
        }
        for (AnnotatedElement annotatedElement : annotatedElementArray) {
            if (annotatedElement.getAnnotation(clazz) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnnotation(AnnotatedElement[] annotatedElementArray, String string) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
            return WsVersionChecker.hasAnnotation(annotatedElementArray, clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static boolean hasJMSTransport(Class clazz) {
        return WsVersionChecker.hasAnnotation(new AnnotatedElement[]{clazz}, WLJmsTransport.class);
    }

    private static boolean hasServiceClient(Class clazz) {
        return WsVersionChecker.hasAnnotation((AnnotatedElement[])clazz.getFields(), ServiceClient.class);
    }

    private static boolean hasCallback(Class clazz) {
        return WsVersionChecker.hasAnnotation((AnnotatedElement[])clazz.getFields(), Callback.class);
    }

    private static boolean hasControl(Class clazz) {
        return WsVersionChecker.hasAnnotation((AnnotatedElement[])clazz.getFields(), CONTROL_ANNOTATION);
    }
}

