/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.deploy;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import weblogic.j2ee.descriptor.wl.WeblogicWebservicesBean;
import weblogic.j2ee.descriptor.wl.WebserviceDescriptionBean;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.internal.WsdlDefinitionsImpl;

public class WsdlFilePublishHelper {
    private static final boolean verbose = Verbose.isVerbose(WsdlFilePublishHelper.class);
    private Set wsdlFiles = new HashSet();
    private Map fileNames = new HashMap();

    public WsdlFilePublishHelper(WeblogicWebservicesBean weblogicWebservicesBean) {
        if (weblogicWebservicesBean == null) {
            return;
        }
        WebserviceDescriptionBean[] webserviceDescriptionBeanArray = weblogicWebservicesBean.getWebserviceDescriptions();
        for (int i = 0; i < webserviceDescriptionBeanArray.length; ++i) {
            String string = webserviceDescriptionBeanArray[i].getWsdlPublishFile();
            if (string == null) continue;
            this.fileNames.put(webserviceDescriptionBeanArray[i].getWebserviceDescriptionName(), string);
        }
    }

    public void publish(String string, String string2, WsdlDefinitions wsdlDefinitions) throws IOException {
        String string3 = (String)this.fileNames.get(string);
        if (string3 == null) {
            return;
        }
        if (string2.startsWith("META-INF/wsdl")) {
            string3 = string3 + string2.substring(13);
        } else if (string2.startsWith("WEB-INF/wsdl")) {
            string3 = string3 + string2.substring(12);
        } else {
            throw new IOException("Wsdl file should be placed at META-INF/wsdl, or WEB-INF/wsdl");
        }
        File file = new File(string3);
        this.wsdlFiles.add(file);
        try {
            if (verbose) {
                Verbose.log("writing wsdl " + file.getAbsolutePath());
            }
            if (wsdlDefinitions instanceof WsdlDefinitionsImpl) {
                ((WsdlDefinitionsImpl)wsdlDefinitions).writeToFile(file);
            }
        }
        catch (WsdlException wsdlException) {
            throw new IOException("Failed to write WSDL: " + wsdlException);
        }
    }

    public void unpublishAll() {
    }
}

