/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.deploy;

import java.util.HashMap;
import weblogic.application.ApplicationContext;
import weblogic.application.ModuleException;
import weblogic.application.UpdateListener;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.ejb.spi.DeploymentInfo;
import weblogic.ejb.spi.EJBDeploymentException;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.j2ee.descriptor.LoginConfigBean;
import weblogic.j2ee.descriptor.ParamValueBean;
import weblogic.j2ee.descriptor.SecurityConstraintBean;
import weblogic.j2ee.descriptor.ServletBean;
import weblogic.j2ee.descriptor.UserDataConstraintBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.WebResourceCollectionBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.PortComponentBean;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.WebAppModule;
import weblogic.servlet.internal.WebAppParser;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.WebService;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.wsee.deploy.EJBDeployInfo;
import weblogic.wsee.deploy.WseeWebappParser;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsRegistry;

class WseeWebappModule {
    static boolean verbose = Verbose.isVerbose(WseeWebappModule.class);
    private static final String SERVLET_NAME = "WSEE_SERVLET";
    private ApplicationContext appCtx;
    private VirtualWebApp virtualWebApp;
    private String contextPath;
    private String serviceUrl;
    private EJBDeployInfo deployInfo;
    private String version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WseeWebappModule(ApplicationContext applicationContext, String string, String string2, String string3, EJBDeployInfo eJBDeployInfo, PortComponentBean portComponentBean, DeploymentInfo deploymentInfo) throws EJBDeploymentException {
        this.appCtx = applicationContext;
        this.contextPath = string2;
        this.serviceUrl = string3;
        this.deployInfo = eJBDeployInfo;
        HttpServer httpServer = WebService.defaultHttpServer();
        ApplicationContext applicationContext2 = applicationContext;
        synchronized (applicationContext2) {
            WebAppServletContext webAppServletContext = httpServer.getServletContextManager().getContextForContextPath(string2, applicationContext.getAppDeploymentMBean().getVersionIdentifier());
            if (webAppServletContext != null) {
                AppDeploymentMBean appDeploymentMBean;
                WebAppServletContext webAppServletContext2 = webAppServletContext;
                if (applicationContext != webAppServletContext2.getApplicationContext()) {
                    throw new EJBDeploymentException(this.deployInfo.getEjbName(), string, new WLDeploymentException("contextpath " + string2 + " is " + "used in other web application. Please specify a different one."));
                }
                if (WseeWebappModule.hasSecurity(portComponentBean)) {
                    throw new EJBDeploymentException(this.deployInfo.getEjbName(), string, new WLDeploymentException("contextpath " + string2 + " is " + "used in other web application. Please specify a different one."));
                }
                if (verbose) {
                    Verbose.log("using existing web app with context path:" + webAppServletContext2.getContextPath());
                }
                if ((appDeploymentMBean = applicationContext.getAppDeploymentMBean()) != null) {
                    this.version = appDeploymentMBean.getVersionIdentifier();
                }
            } else {
                this.createVirtualWebApp(httpServer, portComponentBean, deploymentInfo);
            }
        }
    }

    private static boolean hasSecurity(PortComponentBean portComponentBean) {
        if (portComponentBean != null) {
            String string = portComponentBean.getTransportGuarantee();
            LoginConfigBean loginConfigBean = portComponentBean.getLoginConfig();
            if (loginConfigBean != null) {
                return true;
            }
            if (string != null && !"NONE".equals(string = string.trim())) {
                return true;
            }
        }
        return false;
    }

    void activate() throws ModuleException, DeploymentException {
        WebAppServletContext webAppServletContext;
        if (this.virtualWebApp != null) {
            this.virtualWebApp.activate();
        }
        if ((webAppServletContext = WebService.defaultHttpServer().getServletContextManager().getContextForContextPath(this.contextPath, this.appCtx.getAppDeploymentMBean().getVersionIdentifier())) == null) {
            throw new AssertionError((Object)("In webservice EJB activate, servlet context with contextpath " + this.contextPath + " is not found."));
        }
        this.deployInfo.store(this.serviceUrl, webAppServletContext);
        if (this.virtualWebApp != null) {
            this.virtualWebApp.start();
        } else {
            String[] stringArray = this.deployInfo.getServiceURIs();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("weblogic.wsee.EJBServiceURL", this.serviceUrl);
            int n = 1;
            webAppServletContext.registerServlet(this.deployInfo.getServiceURIs()[0], this.deployInfo.getServlet(), stringArray, hashMap, n);
        }
    }

    void deactivate() throws ModuleException {
        if (this.virtualWebApp != null) {
            this.virtualWebApp.deactivate();
        }
    }

    void removeWebApp() throws ModuleException {
        if (this.virtualWebApp != null) {
            this.virtualWebApp.unprepare();
            this.virtualWebApp.destroy(UpdateListener.Registration.NOOP);
            this.virtualWebApp.remove();
        }
        WsRegistry.instance().unregister(this.serviceUrl, this.version);
    }

    private void createVirtualWebApp(HttpServer httpServer, PortComponentBean portComponentBean, DeploymentInfo deploymentInfo) throws EJBDeploymentException {
        this.virtualWebApp = new VirtualWebApp("", this.contextPath, deploymentInfo);
        try {
            this.virtualWebApp.createWebDD(portComponentBean, this.serviceUrl, this.deployInfo);
            this.virtualWebApp.initUsingLoader(this.appCtx, (GenericClassLoader)deploymentInfo.getModuleClassLoader(), UpdateListener.Registration.NOOP);
            this.virtualWebApp.prepare();
            WebAppServletContext webAppServletContext = httpServer.getServletContextManager().getContextForContextPath(this.contextPath, this.appCtx.getAppDeploymentMBean().getVersionIdentifier());
            if (webAppServletContext == null) {
                throw new AssertionError((Object)("Webapp context for context-root=" + this.contextPath + " is null after creating"));
            }
        }
        catch (ModuleException moduleException) {
            throw new EJBDeploymentException(this.deployInfo.getEjbName(), this.deployInfo.getEjbName(), (Throwable)((Object)moduleException));
        }
    }

    private static class VirtualWebApp
    extends WebAppModule {
        private WebAppParser webAppParser;
        private DeploymentInfo ejbDeploymentInfo;
        static final String DISPATCH_POLICY = "wl-dispatch-policy";

        private VirtualWebApp(String string, String string2, DeploymentInfo deploymentInfo) {
            this(string, string2);
            this.ejbDeploymentInfo = deploymentInfo;
        }

        VirtualWebApp(String string, String string2) {
            super(string, string2);
        }

        protected WebAppParser getWebAppParser(VirtualJarFile virtualJarFile, DeploymentPlanBean deploymentPlanBean) {
            return this.webAppParser;
        }

        public void createWebDD(PortComponentBean portComponentBean, String string, EJBDeployInfo eJBDeployInfo) {
            ParamValueBean paramValueBean;
            String string2;
            Object object;
            DescriptorBean descriptorBean = new DescriptorManager().createDescriptorRoot(WebAppBean.class).getRootBean();
            WebAppBean webAppBean = (WebAppBean)descriptorBean;
            ServletBean servletBean = webAppBean.createServlet();
            servletBean.setServletName(WseeWebappModule.SERVLET_NAME);
            servletBean.setServletClass(eJBDeployInfo.getServlet());
            servletBean.setLoadOnStartup("1");
            ParamValueBean paramValueBean2 = servletBean.createInitParam();
            paramValueBean2.setParamName("weblogic.wsee.EJBServiceURL");
            paramValueBean2.setParamValue(string);
            String string3 = eJBDeployInfo.getEjbName();
            if (this.ejbDeploymentInfo != null && (object = ((weblogic.ejb.container.interfaces.DeploymentInfo)this.ejbDeploymentInfo).getBeanInfo(string3)) != null && (string2 = object.getDispatchPolicy()) != null) {
                paramValueBean = servletBean.createInitParam();
                paramValueBean.setParamName(DISPATCH_POLICY);
                paramValueBean.setParamValue(string2);
            }
            object = webAppBean.createServletMapping();
            object.setServletName(WseeWebappModule.SERVLET_NAME);
            object.setUrlPatterns(eJBDeployInfo.getServiceURIs());
            string2 = eJBDeployInfo.getServiceURIs()[0];
            if (portComponentBean != null) {
                String string4;
                paramValueBean = portComponentBean.getLoginConfig();
                if (paramValueBean != null) {
                    this.copyLoginConfig((LoginConfigBean)paramValueBean, webAppBean.createLoginConfig());
                }
                if ((string4 = portComponentBean.getTransportGuarantee()) != null) {
                    SecurityConstraintBean securityConstraintBean = webAppBean.createSecurityConstraint();
                    WebResourceCollectionBean webResourceCollectionBean = securityConstraintBean.createWebResourceCollection();
                    webResourceCollectionBean.setWebResourceName("WSEE_SERVLETResource");
                    webResourceCollectionBean.setUrlPatterns(new String[]{string2});
                    webResourceCollectionBean.setHttpMethods(new String[]{"POST", "GET", "PUT"});
                    UserDataConstraintBean userDataConstraintBean = securityConstraintBean.createUserDataConstraint();
                    userDataConstraintBean.setTransportGuarantee(string4);
                }
            }
            this.webAppParser = new WseeWebappParser(webAppBean, null);
        }

        protected boolean isDeployedLocally() {
            return true;
        }

        protected void initPersistenceMBean() {
        }

        protected void setupPersistenceUnitRegistry() {
        }

        private void copyLoginConfig(LoginConfigBean loginConfigBean, LoginConfigBean loginConfigBean2) {
            loginConfigBean2.setAuthMethod(loginConfigBean.getAuthMethod());
            loginConfigBean2.setRealmName(loginConfigBean.getRealmName());
        }
    }
}

