/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.handler;

import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPConstants;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.conversation.ConversationCMPHandler;
import weblogic.wsee.conversation.ConversationPhase;
import weblogic.wsee.conversation.LockManager;
import weblogic.wsee.handler.DirectInvokeData;
import weblogic.wsee.handler.WLHandler;
import weblogic.wsee.jaxrpc.soapfault.SOAPFaultUtil;
import weblogic.wsee.jws.container.Container;
import weblogic.wsee.jws.container.ContainerDispatcher;
import weblogic.wsee.jws.container.ContainerDispatcherImpl;
import weblogic.wsee.jws.container.Request;
import weblogic.wsee.jws.container.Response;
import weblogic.wsee.jws.conversation.ConversationState;
import weblogic.wsee.jws.conversation.Store;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.security.AuthorizationContext;
import weblogic.wsee.security.DirectInvokeAuthorizer;
import weblogic.wsee.util.AccessException;
import weblogic.wsee.util.Verbose;

public class DirectInvokeHandler
extends ConversationCMPHandler
implements WLHandler,
SOAPConstants {
    private static final boolean verbose = Verbose.isVerbose(DirectInvokeHandler.class);
    public static final String DIRECT_INVOKE_DATA_PROP = "weblogic.wsee.direct.invoke.data.prop";
    public static final String DIRECT_INVOKE_RESPONSE_PROP = "weblogic.wsee.direct.invoke.response.prop";
    public static final String SECURITY_REALM = "__SECURITY_REALM__";
    public static final String CONTEXT_PATH = "__CONTEXT_PATH__";
    public static final String APPLICATION_ID = "__APPLICATION_ID__";
    private static final QName AUTHENTICATION_FAILURE = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client.Authentication", "env");
    private String actorOrRole = null;
    private DirectInvokeAuthorizer authorizer;

    public void init(HandlerInfo handlerInfo) {
    }

    public boolean handleRequest(MessageContext messageContext) {
        WlMessageContext wlMessageContext;
        Object object;
        if (this.authorizer == null) {
            this.authorizer = new DirectInvokeAuthorizer(new AuthorizationContext((String)messageContext.getProperty("weblogic.wsee.application_id"), (String)messageContext.getProperty("weblogic.wsee.context_path"), (String)messageContext.getProperty("weblogic.wsee.security_realm")));
        }
        if ((object = (wlMessageContext = WlMessageContext.narrow(messageContext)).getProperty(DIRECT_INVOKE_DATA_PROP)) == null || !(object instanceof DirectInvokeData)) {
            return true;
        }
        try {
            this.checkRole(wlMessageContext);
            DirectInvokeData directInvokeData = (DirectInvokeData)object;
            String string = directInvokeData.getConversationId();
            if (string != null) {
                this.handleConversationalDirectInvoke(wlMessageContext, string);
            }
            this.handleDirectInvoke(wlMessageContext, directInvokeData);
        }
        catch (Throwable throwable) {
            if (verbose) {
                Verbose.logException(throwable);
            }
            wlMessageContext.setProperty("weblogic.wsee.local.invoke.throwable", throwable);
        }
        return false;
    }

    private void handleConversationalDirectInvoke(WlMessageContext wlMessageContext, String string) {
        Object object;
        try {
            object = LockManager.getInstance().lock(string);
            wlMessageContext.setProperty("weblogic.wsee.conversation.ConversationId", string);
            wlMessageContext.setProperty("weblogic.wsee.conversation.Lock", object);
        }
        catch (InterruptedException interruptedException) {
            throw new JAXRPCException((Throwable)interruptedException);
        }
        object = this.getStore(string, wlMessageContext);
        ConversationState conversationState = DirectInvokeHandler.loadState(wlMessageContext, (Store)object, string);
        wlMessageContext.setProperty("weblogic.wsee.jws.container", conversationState);
        wlMessageContext.setProperty("weblogic.wsee.ejb.altRunAs", conversationState.getAltAuthenticatedSubject());
    }

    private void handleDirectInvoke(WlMessageContext wlMessageContext, DirectInvokeData directInvokeData) throws Exception {
        Request request = directInvokeData.getRequest();
        ContainerDispatcher containerDispatcher = ContainerDispatcher.getInstance();
        Response response = ((ContainerDispatcherImpl)containerDispatcher).dispatch(wlMessageContext, request, directInvokeData.getContext());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(DIRECT_INVOKE_RESPONSE_PROP, response.retval);
        wlMessageContext.setProperty("weblogic.wsee.local.invoke.response", hashMap);
    }

    public boolean handleResponse(MessageContext messageContext) {
        return this.finish(messageContext);
    }

    public boolean handleClosure(MessageContext messageContext) {
        return this.finish(messageContext);
    }

    public boolean handleFault(MessageContext messageContext) {
        return this.finish(messageContext);
    }

    private boolean finish(MessageContext messageContext) {
        LockManager.Lock lock;
        Object object = messageContext.getProperty(DIRECT_INVOKE_DATA_PROP);
        if (object == null || !(object instanceof DirectInvokeData)) {
            return true;
        }
        String string = (String)messageContext.getProperty("weblogic.wsee.conversation.ConversationId");
        if (string == null) {
            return true;
        }
        ConversationPhase conversationPhase = (ConversationPhase)messageContext.getProperty("weblogic.wsee.conversation.ConversationPhase");
        Container container = AsyncUtil.getContainer(messageContext);
        if (ConversationPhase.FINISH.equals(conversationPhase) || container == null || container.isFinished()) {
            LockManager.getInstance().destroy(string);
        }
        if ((lock = (LockManager.Lock)messageContext.getProperty("weblogic.wsee.conversation.Lock")) != null) {
            lock.release();
        }
        return true;
    }

    private void checkRole(WlMessageContext wlMessageContext) {
        if (this.authorizer == null) {
            throw new RuntimeException("Authorization did not initialize properly");
        }
        if (!this.authorizer.isAccessAllowed(wlMessageContext)) {
            throw new SOAPFaultException(AUTHENTICATION_FAILURE, "Access Denied to callback method.", this.actorOrRole, SOAPFaultUtil.newDetail((Throwable)new AccessException("Access Denied to callback method."), false));
        }
    }
}

