/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.handler;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.management.descriptors.webservice.HandlerChainMBean;
import weblogic.management.descriptors.webservice.HandlerChainMBeanImpl;
import weblogic.management.descriptors.webservice.HandlerChainsMBean;
import weblogic.management.descriptors.webservice.HandlerChainsMBeanImpl;
import weblogic.management.descriptors.webservice.HandlerMBean;
import weblogic.management.descriptors.webservice.HandlerMBeanImpl;
import weblogic.management.descriptors.webservice.InboundHandlerChainMBean;
import weblogic.management.descriptors.webservice.InboundHandlerChainMBeanImpl;
import weblogic.management.descriptors.webservice.InitParamMBean;
import weblogic.management.descriptors.webservice.InitParamMBeanImpl;
import weblogic.management.descriptors.webservice.InitParamsMBean;
import weblogic.management.descriptors.webservice.InitParamsMBeanImpl;
import weblogic.management.descriptors.webservice.OutboundHandlerChainMBean;
import weblogic.management.descriptors.webservice.OutboundHandlerChainMBeanImpl;
import weblogic.management.descriptors.webservice.ServerHandlerChainMBean;
import weblogic.management.descriptors.webservice.ServerHandlerChainMBeanImpl;
import weblogic.wsee.handler.DDProcessingException;
import weblogic.wsee.handler.ParsingHelper;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsException;
import weblogic.xml.schema.binding.util.ClassUtil;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;
import weblogic.xml.stream.XMLStreamException;

public class GlobalHandlerChainHelper {
    private static final boolean verbose = Verbose.isVerbose(GlobalHandlerChainHelper.class);
    private static final String SHC_DD_FILE = "server-handler-chain.xml";
    private static final String SYSTEM_SHC_DD_FILE = GlobalHandlerChainHelper.getSHCDDFileProp();
    private static final String SERVER_HANDLER_CHAIN = "server-handler-chain";
    private static final String INBOUND_HANDLER_CHAIN = "inbound-handler-chain";
    private static final String OUTBOUND_HANDLER_CHAIN = "outbound-handler-chain";
    private static final String HANDLER_CHAINS = "handler-chains";
    private static final String HANDLER_CHAIN = "handler-chain";
    private static final String NAME = "name";
    private static final String HANDLER = "handler";
    private static final String INIT_PARAMS = "init-params";
    private static final String INIT_PARAM = "init-param";
    private static final String PARAM = "param";
    private static final String VALUE = "value";
    private static final String CLASS_NAME = "class-name";
    private ServerHandlerChainMBean serverHandlerChain = null;
    private List inboundHandlerInfoList = new ArrayList();
    private boolean loadedInboundHandlerInfos = false;
    private List outboundHandlerInfoList = new ArrayList();
    private boolean loadedOutboundHandlerInfos = false;
    private boolean noGlobalHandlerChainConfigured = false;
    private static GlobalHandlerChainHelper theInstance = null;

    private static String getSHCDDFileProp() {
        return System.getProperty("weblogic.wsee.ServerHandlerChainConfig");
    }

    private GlobalHandlerChainHelper() {
        try {
            this.loadConfig();
        }
        catch (DDProcessingException dDProcessingException) {
            Verbose.log((Object)dDProcessingException);
            this.noGlobalHandlerChainConfigured = false;
        }
    }

    private void loadConfig() throws DDProcessingException {
        DDLoader dDLoader = new DDLoader();
        this.serverHandlerChain = dDLoader.load();
        if (this.serverHandlerChain == null) {
            this.noGlobalHandlerChainConfigured = true;
        }
    }

    private ServerHandlerChainMBean getServerHandlerChain() {
        if (this.noGlobalHandlerChainConfigured) {
            return null;
        }
        return this.serverHandlerChain;
    }

    private void dump() throws XMLStreamException {
        ServerHandlerChainMBeanImpl serverHandlerChainMBeanImpl = (ServerHandlerChainMBeanImpl)this.getServerHandlerChain();
        if (serverHandlerChainMBeanImpl == null) {
            return;
        }
        XMLOutputStream xMLOutputStream = XMLOutputStreamFactory.newInstance().newDebugOutputStream((OutputStream)System.out);
        xMLOutputStream.add(serverHandlerChainMBeanImpl.toXML(0));
        xMLOutputStream.flush();
    }

    public static void main(String[] stringArray) throws Exception {
        GlobalHandlerChainHelper.getInstance().dump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GlobalHandlerChainHelper getInstance() {
        if (theInstance != null) return theInstance;
        Class<GlobalHandlerChainHelper> clazz = GlobalHandlerChainHelper.class;
        synchronized (GlobalHandlerChainHelper.class) {
            if (theInstance != null) return theInstance;
            theInstance = new GlobalHandlerChainHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return theInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getInboundHandlerInfos() {
        if (this.noGlobalHandlerChainConfigured) {
            return new ArrayList();
        }
        if (!this.loadedInboundHandlerInfos) {
            GlobalHandlerChainHelper globalHandlerChainHelper = this;
            synchronized (globalHandlerChainHelper) {
                if (!this.loadedInboundHandlerInfos) {
                    ServerHandlerChainMBean serverHandlerChainMBean = this.getServerHandlerChain();
                    if (serverHandlerChainMBean == null) {
                        return new ArrayList();
                    }
                    InboundHandlerChainMBean inboundHandlerChainMBean = serverHandlerChainMBean.getInboundHandlerChain();
                    if (inboundHandlerChainMBean == null) {
                        return new ArrayList();
                    }
                    HandlerChainsMBean handlerChainsMBean = inboundHandlerChainMBean.getHandlerChains();
                    if (handlerChainsMBean == null) {
                        return new ArrayList();
                    }
                    HandlerChainMBean[] handlerChainMBeanArray = handlerChainsMBean.getHandlerChains();
                    if (handlerChainMBeanArray == null || handlerChainMBeanArray.length == 0) {
                        return new ArrayList();
                    }
                    for (int i = 0; i < handlerChainMBeanArray.length; ++i) {
                        HandlerMBean[] handlerMBeanArray = handlerChainMBeanArray[i].getHandlers();
                        for (int j = 0; j < handlerMBeanArray.length; ++j) {
                            Class clazz = null;
                            try {
                                clazz = this.loadClass(handlerMBeanArray[j].getClassName());
                            }
                            catch (WsException wsException) {
                                Verbose.log(wsException);
                                continue;
                            }
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            InitParamsMBean initParamsMBean = handlerMBeanArray[j].getInitParams();
                            if (initParamsMBean != null) {
                                InitParamMBean[] initParamMBeanArray = initParamsMBean.getInitParams();
                                for (int k = 0; k < initParamMBeanArray.length; ++k) {
                                    hashMap.put(initParamMBeanArray[k].getParamName(), initParamMBeanArray[k].getParamValue());
                                }
                            }
                            this.inboundHandlerInfoList.add(new HandlerInfo(clazz, hashMap, null));
                        }
                    }
                    this.loadedInboundHandlerInfos = true;
                }
            }
        }
        return this.inboundHandlerInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getOutboundHandlerInfos() {
        if (this.noGlobalHandlerChainConfigured) {
            return new ArrayList();
        }
        if (!this.loadedOutboundHandlerInfos) {
            GlobalHandlerChainHelper globalHandlerChainHelper = this;
            synchronized (globalHandlerChainHelper) {
                if (!this.loadedOutboundHandlerInfos) {
                    ServerHandlerChainMBean serverHandlerChainMBean = this.getServerHandlerChain();
                    if (serverHandlerChainMBean == null) {
                        return new ArrayList();
                    }
                    OutboundHandlerChainMBean outboundHandlerChainMBean = serverHandlerChainMBean.getOutboundHandlerChain();
                    if (outboundHandlerChainMBean == null) {
                        return new ArrayList();
                    }
                    HandlerChainsMBean handlerChainsMBean = outboundHandlerChainMBean.getHandlerChains();
                    if (handlerChainsMBean == null) {
                        return new ArrayList();
                    }
                    HandlerChainMBean[] handlerChainMBeanArray = handlerChainsMBean.getHandlerChains();
                    if (handlerChainMBeanArray == null || handlerChainMBeanArray.length == 0) {
                        return new ArrayList();
                    }
                    for (int i = 0; i < handlerChainMBeanArray.length; ++i) {
                        HandlerMBean[] handlerMBeanArray = handlerChainMBeanArray[i].getHandlers();
                        for (int j = 0; j < handlerMBeanArray.length; ++j) {
                            Class clazz = null;
                            try {
                                clazz = this.loadClass(handlerMBeanArray[j].getClassName());
                            }
                            catch (WsException wsException) {
                                Verbose.log(wsException);
                                continue;
                            }
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            InitParamsMBean initParamsMBean = handlerMBeanArray[j].getInitParams();
                            if (initParamsMBean != null) {
                                InitParamMBean[] initParamMBeanArray = initParamsMBean.getInitParams();
                                for (int k = 0; k < initParamMBeanArray.length; ++k) {
                                    hashMap.put(initParamMBeanArray[k].getParamName(), initParamMBeanArray[k].getParamValue());
                                }
                            }
                            this.outboundHandlerInfoList.add(new HandlerInfo(clazz, hashMap, null));
                        }
                    }
                    this.loadedOutboundHandlerInfos = true;
                }
            }
        }
        return this.outboundHandlerInfoList;
    }

    private Class loadClass(String string) throws WsException {
        try {
            return ClassUtil.loadClass((String)string);
        }
        catch (ClassUtil.ClassUtilException classUtilException) {
            throw new WsException("Failed to load class", classUtilException);
        }
    }

    private static class DDLoader {
        private Map handlerChains = new HashMap();
        private ParsingHelper ph;

        private DDLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServerHandlerChainMBean load() throws DDProcessingException {
            ServerHandlerChainMBean serverHandlerChainMBean;
            InputStream inputStream;
            block21: {
                ServerHandlerChainMBean serverHandlerChainMBean2;
                inputStream = null;
                try {
                    if (SYSTEM_SHC_DD_FILE != null && SYSTEM_SHC_DD_FILE.length() != 0) {
                        try {
                            inputStream = new FileInputStream(SYSTEM_SHC_DD_FILE);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (verbose && inputStream != null) {
                            Verbose.log(" +++ Found " + SYSTEM_SHC_DD_FILE);
                        }
                        if (inputStream == null) {
                            inputStream = this.getClass().getClassLoader().getResourceAsStream(SYSTEM_SHC_DD_FILE);
                        }
                        if (verbose && inputStream != null) {
                            Verbose.log(" +++ Found " + SYSTEM_SHC_DD_FILE + " ----- In SystemClassPath");
                        }
                    }
                    if (inputStream == null) {
                        inputStream = this.getClass().getClassLoader().getResourceAsStream(GlobalHandlerChainHelper.SHC_DD_FILE);
                        if (verbose && inputStream != null) {
                            Verbose.log(" +++ Found server-handler-chain.xml in server classpath");
                        }
                    }
                    if (inputStream == null) {
                        inputStream = this.getClass().getClassLoader().getResourceAsStream("weblogic/wsee/handler/server-handler-chain.xml");
                        if (verbose && inputStream != null) {
                            Verbose.log(" +++ Found server-handler-chain.xml in server classpath under weblogic/wsee/handler");
                        }
                    }
                    if (inputStream != null) break block21;
                    if (verbose) {
                        Verbose.log(" +++ Doesn't define server-handler-chain.xml file.  So, not configuring server handler-chains.");
                    }
                    serverHandlerChainMBean2 = null;
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Throwable throwable2) {}
                    throw throwable;
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return serverHandlerChainMBean2;
            }
            ServerHandlerChainMBean serverHandlerChainMBean3 = serverHandlerChainMBean = this.load(inputStream);
            Object var5_6 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return serverHandlerChainMBean3;
        }

        private ServerHandlerChainMBean load(InputStream inputStream) throws DDProcessingException {
            try {
                this.ph = new ParsingHelper(inputStream);
                ServerHandlerChainMBean serverHandlerChainMBean = this.processServerHandlerChainElement();
                this.ph.matchDocumentEnd();
                return serverHandlerChainMBean;
            }
            catch (XMLStreamException xMLStreamException) {
                throw new DDProcessingException("Problem parsing deployment descriptor", xMLStreamException);
            }
        }

        private ServerHandlerChainMBean processServerHandlerChainElement() throws DDProcessingException, XMLStreamException {
            OutboundHandlerChainMBean outboundHandlerChainMBean;
            ServerHandlerChainMBeanImpl serverHandlerChainMBeanImpl = new ServerHandlerChainMBeanImpl();
            this.ph.matchStartElement(GlobalHandlerChainHelper.SERVER_HANDLER_CHAIN);
            InboundHandlerChainMBean inboundHandlerChainMBean = this.processInboundHandlerChainElement();
            if (inboundHandlerChainMBean != null) {
                serverHandlerChainMBeanImpl.setInboundHandlerChain(inboundHandlerChainMBean);
            }
            if ((outboundHandlerChainMBean = this.processOutboundHandlerChainElement()) != null) {
                serverHandlerChainMBeanImpl.setOutboundHandlerChain(outboundHandlerChainMBean);
            }
            this.ph.matchEndElement(GlobalHandlerChainHelper.SERVER_HANDLER_CHAIN);
            return serverHandlerChainMBeanImpl;
        }

        private InboundHandlerChainMBean processInboundHandlerChainElement() throws DDProcessingException, XMLStreamException {
            InboundHandlerChainMBeanImpl inboundHandlerChainMBeanImpl = new InboundHandlerChainMBeanImpl();
            this.ph.matchStartElement(GlobalHandlerChainHelper.INBOUND_HANDLER_CHAIN);
            HandlerChainsMBean handlerChainsMBean = this.processHandlerChainsElement();
            if (handlerChainsMBean != null) {
                inboundHandlerChainMBeanImpl.setHandlerChains(handlerChainsMBean);
            }
            this.ph.matchEndElement(GlobalHandlerChainHelper.INBOUND_HANDLER_CHAIN);
            return inboundHandlerChainMBeanImpl;
        }

        private OutboundHandlerChainMBean processOutboundHandlerChainElement() throws DDProcessingException, XMLStreamException {
            OutboundHandlerChainMBeanImpl outboundHandlerChainMBeanImpl = new OutboundHandlerChainMBeanImpl();
            this.ph.matchStartElement(GlobalHandlerChainHelper.OUTBOUND_HANDLER_CHAIN);
            HandlerChainsMBean handlerChainsMBean = this.processHandlerChainsElement();
            if (handlerChainsMBean != null) {
                outboundHandlerChainMBeanImpl.setHandlerChains(handlerChainsMBean);
            }
            this.ph.matchEndElement(GlobalHandlerChainHelper.OUTBOUND_HANDLER_CHAIN);
            return outboundHandlerChainMBeanImpl;
        }

        private HandlerChainsMBean processHandlerChainsElement() throws DDProcessingException, XMLStreamException {
            HandlerChainsMBeanImpl handlerChainsMBeanImpl = null;
            XMLEvent xMLEvent = this.ph.matchStartElement(GlobalHandlerChainHelper.HANDLER_CHAINS);
            if (xMLEvent != null) {
                handlerChainsMBeanImpl = new HandlerChainsMBeanImpl();
                HandlerChainMBean[] handlerChainMBeanArray = this.processHandlerChainElements();
                handlerChainsMBeanImpl.setHandlerChains(handlerChainMBeanArray);
                this.ph.matchEndElement(GlobalHandlerChainHelper.HANDLER_CHAINS);
            }
            return handlerChainsMBeanImpl;
        }

        private HandlerChainMBean[] processHandlerChainElements() throws DDProcessingException, XMLStreamException {
            HandlerChainMBean handlerChainMBean = this.processHandlerChainElement();
            if (handlerChainMBean == null) {
                throw new DDProcessingException("There must be at least one <handler-chain> element in <handler-chains>", this.ph.getLocation());
            }
            ArrayList<HandlerChainMBean> arrayList = new ArrayList<HandlerChainMBean>();
            while (handlerChainMBean != null) {
                arrayList.add(handlerChainMBean);
                handlerChainMBean = this.processHandlerChainElement();
            }
            return arrayList.toArray(new HandlerChainMBeanImpl[0]);
        }

        private HandlerChainMBean processHandlerChainElement() throws DDProcessingException, XMLStreamException {
            HandlerChainMBeanImpl handlerChainMBeanImpl = null;
            XMLEvent xMLEvent = this.ph.matchOptionalStartElement(GlobalHandlerChainHelper.HANDLER_CHAIN);
            if (xMLEvent != null) {
                ParsingHelper.checkAttributes((StartElement)xMLEvent, new String[]{GlobalHandlerChainHelper.NAME});
                handlerChainMBeanImpl = new HandlerChainMBeanImpl();
                String string = ParsingHelper.getRequiredAttribute((StartElement)xMLEvent, GlobalHandlerChainHelper.NAME).getValue();
                handlerChainMBeanImpl.setHandlerChainName(string);
                HandlerMBean[] handlerMBeanArray = this.processHandlerElements();
                handlerChainMBeanImpl.setHandlers(handlerMBeanArray);
                if (this.handlerChains.put(string, handlerChainMBeanImpl) != null) {
                    throw new DDProcessingException("<handler-chain> must have a unique \"name\" attribute within the scope of a <server-handler-chain>; the name \"" + string + "\" was used in a previous <" + GlobalHandlerChainHelper.HANDLER_CHAIN + "> element", xMLEvent.getLocation());
                }
                this.ph.matchEndElement(GlobalHandlerChainHelper.HANDLER_CHAIN);
            }
            return handlerChainMBeanImpl;
        }

        private HandlerMBean[] processHandlerElements() throws DDProcessingException, XMLStreamException {
            ArrayList<HandlerMBean> arrayList = new ArrayList<HandlerMBean>();
            HandlerMBean handlerMBean = this.processHandlerElement();
            if (handlerMBean == null) {
                throw new DDProcessingException("There must be at least one <handler> element in <handler-chain>", this.ph.getLocation());
            }
            while (handlerMBean != null) {
                arrayList.add(handlerMBean);
                handlerMBean = this.processHandlerElement();
            }
            return arrayList.toArray(new HandlerMBean[0]);
        }

        private HandlerMBean processHandlerElement() throws DDProcessingException, XMLStreamException {
            HandlerMBeanImpl handlerMBeanImpl = null;
            XMLEvent xMLEvent = this.ph.matchOptionalStartElement(GlobalHandlerChainHelper.HANDLER);
            if (xMLEvent != null) {
                ParsingHelper.checkAttributes((StartElement)xMLEvent, new String[]{GlobalHandlerChainHelper.CLASS_NAME});
                handlerMBeanImpl = new HandlerMBeanImpl();
                String string = ParsingHelper.getRequiredAttribute((StartElement)xMLEvent, GlobalHandlerChainHelper.CLASS_NAME).getValue();
                handlerMBeanImpl.setClassName(string);
                InitParamsMBean initParamsMBean = this.processInitParamsElement();
                if (initParamsMBean != null) {
                    handlerMBeanImpl.setInitParams(initParamsMBean);
                }
                this.ph.matchEndElement(GlobalHandlerChainHelper.HANDLER);
            }
            return handlerMBeanImpl;
        }

        private InitParamsMBean processInitParamsElement() throws DDProcessingException, XMLStreamException {
            InitParamsMBeanImpl initParamsMBeanImpl = null;
            XMLEvent xMLEvent = this.ph.matchOptionalStartElement(GlobalHandlerChainHelper.INIT_PARAMS);
            if (xMLEvent != null) {
                initParamsMBeanImpl = new InitParamsMBeanImpl();
                InitParamMBean[] initParamMBeanArray = this.processInitParamElements();
                initParamsMBeanImpl.setInitParams(initParamMBeanArray);
                this.ph.matchEndElement(GlobalHandlerChainHelper.INIT_PARAMS);
            }
            return initParamsMBeanImpl;
        }

        private InitParamMBean[] processInitParamElements() throws DDProcessingException, XMLStreamException {
            InitParamMBean initParamMBean = this.processInitParamElement();
            if (initParamMBean == null) {
                throw new DDProcessingException("There must be at least one <param> element in <init-params>", this.ph.getLocation());
            }
            ArrayList<InitParamMBean> arrayList = new ArrayList<InitParamMBean>();
            while (initParamMBean != null) {
                arrayList.add(initParamMBean);
                initParamMBean = this.processInitParamElement();
            }
            return arrayList.toArray(new InitParamMBeanImpl[0]);
        }

        private InitParamMBean processInitParamElement() throws DDProcessingException, XMLStreamException {
            InitParamMBeanImpl initParamMBeanImpl = null;
            XMLEvent xMLEvent = this.ph.matchOptionalStartElement(GlobalHandlerChainHelper.INIT_PARAM);
            if (xMLEvent != null) {
                ParsingHelper.checkAttributes((StartElement)xMLEvent, new String[]{GlobalHandlerChainHelper.NAME, GlobalHandlerChainHelper.VALUE});
                initParamMBeanImpl = new InitParamMBeanImpl();
                String string = ParsingHelper.getRequiredAttribute((StartElement)xMLEvent, GlobalHandlerChainHelper.NAME).getValue();
                initParamMBeanImpl.setParamName(string);
                String string2 = ParsingHelper.getRequiredAttribute((StartElement)xMLEvent, GlobalHandlerChainHelper.VALUE).getValue();
                initParamMBeanImpl.setParamValue(string2);
                this.ph.matchEndElement(GlobalHandlerChainHelper.INIT_PARAM);
            }
            return initParamMBeanImpl;
        }
    }
}

