/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.handler;

import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.MessageContext;
import weblogic.wsee.handler.HandlerList;
import weblogic.wsee.handler.HandlerListImpl;
import weblogic.wsee.handler.WLHandler;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.monitoring.HandlerStats;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;

public final class HandlerIterator {
    public static final String HANDLER_INDEX = "weblogic.wsee.handler.index";
    private HandlerListImpl handlers;
    private int index = 0;
    private static final int CONSTRUCTED = 0;
    private static final int IN_HANDLE_REQUEST = 1;
    private static final int IN_HANDLE_RESPONSE = 2;
    private int status = 0;
    private boolean suspended = false;
    private boolean closureEnabled = false;
    private static final boolean verbose = Verbose.isVerbose(HandlerIterator.class);
    private static final boolean verboseHistory = Verbose.isVerbose(HandlerIterator.class.getName() + "History");
    private static final String HANDLER_HISTORY = "weblogic.wsee.handler.HandlerHistory";

    public HandlerIterator(HandlerList handlerList) {
        this.handlers = (HandlerListImpl)handlerList;
    }

    public HandlerListImpl getHandlers() {
        return this.handlers;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume(MessageContext messageContext) {
        this.suspended = false;
        if (this.status == 2) {
            this.handleResponse(messageContext);
        } else {
            this.handleRequest(messageContext, this.index);
        }
    }

    public boolean handleRequest(MessageContext messageContext) {
        return this.handleRequest(messageContext, 0);
    }

    public boolean handleRequest(MessageContext messageContext, int n) {
        this.closureEnabled = false;
        this.status = 1;
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        if (verboseHistory) {
            HandlerIterator.updateHandlerHistory("...REQUEST...", wlMessageContext);
        }
        this.index = n;
        while (this.index < this.handlers.size()) {
            Handler handler = this.handlers.get(this.index);
            if (verbose) {
                Verbose.log("Processing " + handler.getClass().getSimpleName() + "...  ");
            }
            if (verboseHistory) {
                HandlerIterator.updateHandlerHistory(handler.getClass().getSimpleName(), wlMessageContext);
            }
            HandlerStats handlerStats = this.handlers.getStats(this.index);
            try {
                wlMessageContext.setProperty(HANDLER_INDEX, new Integer(this.index));
                if (!handler.handleRequest((MessageContext)wlMessageContext)) {
                    if (verboseHistory) {
                        String string = handler.getClass().getSimpleName() + ".handleRequest=false";
                        HandlerIterator.updateHandlerHistory(string, wlMessageContext);
                    }
                    if (handlerStats != null) {
                        handlerStats.reportRequestTermination();
                    }
                    return false;
                }
                if (wlMessageContext.hasFault()) {
                    if (verbose) {
                        Verbose.log("A fault in the context");
                    }
                    if (verboseHistory) {
                        String string = handler.getClass().getSimpleName() + ".hasFault=true";
                        HandlerIterator.updateHandlerHistory(string, wlMessageContext);
                    }
                    return false;
                }
            }
            catch (Throwable throwable) {
                if (verbose) {
                    Verbose.log((Object)"Failed to invoke handler", throwable);
                }
                if (verboseHistory) {
                    String string = handler.getClass().getSimpleName() + ".throwable";
                    HandlerIterator.updateHandlerHistory(string, wlMessageContext);
                }
                if (handlerStats != null) {
                    handlerStats.reportRequestError(throwable);
                }
                wlMessageContext.setFault(throwable);
                return false;
            }
            if (this.suspended) {
                return true;
            }
            ++this.index;
        }
        --this.index;
        return true;
    }

    public boolean handleClosure(MessageContext messageContext) {
        this.closureEnabled = true;
        return this.handleResponse(messageContext);
    }

    public boolean handleAsyncClosure(MessageContext messageContext) {
        this.closureEnabled = true;
        if (this.handlers.size() == 0) {
            return true;
        }
        this.index = this.handlers.size() - 1;
        return this.handleResponse(messageContext);
    }

    public boolean handleAsyncResponse(MessageContext messageContext) {
        if (this.handlers.size() == 0) {
            return true;
        }
        this.index = this.handlers.size() - 1;
        return this.handleResponse(messageContext);
    }

    public boolean handleResponse(MessageContext messageContext) {
        assert (this.index >= 0);
        assert (this.index < this.handlers.size());
        this.status = 2;
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        if (verboseHistory) {
            HandlerIterator.updateHandlerHistory("...RESPONSE...", wlMessageContext);
        }
        while (this.index >= 0 && this.index < this.handlers.size()) {
            Handler handler = this.handlers.get(this.index);
            HandlerStats handlerStats = this.handlers.getStats(this.index);
            if (verbose) {
                Verbose.log("Processing " + handler.getClass().getSimpleName() + "...  ");
            }
            if (this.closureEnabled) {
                if (handler instanceof WLHandler) {
                    this.handleCloser(handler, messageContext, handlerStats);
                }
            } else if (wlMessageContext.hasFault()) {
                this.handleFault(handler, messageContext, handlerStats);
            } else {
                this.handleResponse(handler, handlerStats, wlMessageContext);
            }
            if (this.suspended) {
                return true;
            }
            --this.index;
        }
        return true;
    }

    private void handleResponse(Handler handler, HandlerStats handlerStats, WlMessageContext wlMessageContext) {
        try {
            boolean bl = handler.handleResponse((MessageContext)wlMessageContext);
            if (verboseHistory) {
                String string = handler.getClass().getSimpleName() + ".handleResponse" + (bl ? "" : "=false");
                HandlerIterator.updateHandlerHistory(string, wlMessageContext);
            }
            if (!bl && !wlMessageContext.hasFault()) {
                this.closureEnabled = true;
            }
        }
        catch (Throwable throwable) {
            if (verboseHistory) {
                String string = handler.getClass().getSimpleName() + ".handleResponse=Throwable";
                HandlerIterator.updateHandlerHistory(string, wlMessageContext);
            }
            this.setFaultOnContext(throwable, handlerStats, wlMessageContext);
        }
    }

    private void handleFault(Handler handler, MessageContext messageContext, HandlerStats handlerStats) {
        try {
            if (!handler.handleFault(messageContext)) {
                if (verboseHistory) {
                    String string = handler.getClass().getSimpleName() + ".handleFault=false";
                    HandlerIterator.updateHandlerHistory(string, messageContext);
                }
                this.closureEnabled = true;
            } else if (verboseHistory) {
                String string = handler.getClass().getSimpleName() + ".handleFault";
                HandlerIterator.updateHandlerHistory(string, messageContext);
            }
        }
        catch (Throwable throwable) {
            WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
            if (verboseHistory) {
                String string = handler.getClass().getSimpleName() + ".handleFault=Throwable";
                HandlerIterator.updateHandlerHistory(string, messageContext);
            }
            if (wlMessageContext.getFault() == null) {
                this.setFaultOnContext(throwable, handlerStats, wlMessageContext);
            }
            this.ignoreFault(throwable, handlerStats);
        }
    }

    private void handleCloser(Handler handler, MessageContext messageContext, HandlerStats handlerStats) {
        try {
            ((WLHandler)handler).handleClosure(messageContext);
            if (verboseHistory) {
                String string = handler.getClass().getSimpleName() + ".handleClosure";
                HandlerIterator.updateHandlerHistory(string, messageContext);
            }
        }
        catch (Throwable throwable) {
            if (verboseHistory) {
                String string = handler.getClass().getSimpleName() + ".handleClosure=Throwable";
                HandlerIterator.updateHandlerHistory(string, messageContext);
            }
            this.ignoreFault(throwable, handlerStats);
        }
    }

    private void setFaultOnContext(Throwable throwable, HandlerStats handlerStats, WlMessageContext wlMessageContext) {
        if (verbose) {
            Verbose.log((Object)"Failed to invoke handle response", throwable);
        }
        if (handlerStats != null) {
            handlerStats.reportResponseError(throwable);
        }
        wlMessageContext.setFault(throwable);
    }

    private void ignoreFault(Throwable throwable, HandlerStats handlerStats) {
        if (verbose) {
            Verbose.log((Object)"Failed to invoke handle response", throwable);
        }
        if (handlerStats != null) {
            handlerStats.reportResponseError(throwable);
        }
        assert (false) : "handleFault had fault:" + throwable;
    }

    public static void updateHandlerHistory(String string, MessageContext messageContext) {
        StringBuffer stringBuffer = HandlerIterator.getHandlerHistory(messageContext);
        if (stringBuffer.length() > 0) {
            stringBuffer.append(",");
        }
        stringBuffer.append(string);
        messageContext.setProperty(HANDLER_HISTORY, (Object)stringBuffer.toString());
    }

    public static StringBuffer getHandlerHistory(MessageContext messageContext) {
        String string = (String)messageContext.getProperty(HANDLER_HISTORY);
        if (string == null) {
            messageContext.setProperty(HANDLER_HISTORY, (Object)"");
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        return stringBuffer;
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("handlers", this.handlers);
        toStringWriter.end();
    }
}

