/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.handler.HandlerList;
import weblogic.wsee.monitoring.HandlerStats;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HandlerListImpl
implements HandlerList {
    private List handlers = new ArrayList();
    private List handlerInfos = new ArrayList();
    private List handlerStats = new ArrayList();
    private boolean initialized = false;
    private static final boolean verbose = Verbose.isVerbose(HandlerListImpl.class);

    public HandlerListImpl() {
        this.initialized = true;
    }

    public HandlerListImpl(HandlerListImpl handlerListImpl) {
        for (NamedHandlerInfo namedHandlerInfo : handlerListImpl.handlerInfos) {
            this.handlerInfos.add(new NamedHandlerInfo(namedHandlerInfo));
        }
    }

    @Override
    public int size() {
        return this.handlers.size();
    }

    public Handler get(int n) {
        return (Handler)this.handlers.get(n);
    }

    @Override
    public HandlerInfo getInfo(int n) {
        return ((NamedHandlerInfo)this.handlerInfos.get((int)n)).info;
    }

    public HandlerStats getStats(int n) {
        if (n < 0 || n >= this.handlerStats.size()) {
            return null;
        }
        return (HandlerStats)this.handlerStats.get(n);
    }

    @Override
    public String getName(int n) {
        return ((NamedHandlerInfo)this.handlerInfos.get((int)n)).name;
    }

    @Override
    public void add(String string, HandlerInfo handlerInfo) throws HandlerException {
        this.add(new NamedHandlerInfo(string, handlerInfo));
    }

    private void add(NamedHandlerInfo namedHandlerInfo) throws HandlerException {
        if (verbose) {
            Verbose.log("In HandlerList " + super.toString() + " adding handler: " + namedHandlerInfo.name + " class=" + namedHandlerInfo.info.getHandlerClass() + " at pos " + this.handlers.size() + " of " + this.handlers.size());
        }
        Handler handler = this.newHandler(namedHandlerInfo.info);
        this.handlers.add(handler);
        this.handlerInfos.add(namedHandlerInfo);
        if (verbose) {
            this.dumpHandlers();
        }
    }

    @Override
    public void insert(String string, int n, HandlerInfo handlerInfo) throws HandlerException {
        if (verbose) {
            Verbose.log("In HandlerList " + super.toString() + " inserting handler: " + string + " class=" + handlerInfo.getHandlerClass() + " at pos " + n + " of " + this.handlers.size());
        }
        Handler handler = this.newHandler(handlerInfo);
        this.handlers.add(n, handler);
        this.handlerInfos.add(n, new NamedHandlerInfo(string, handlerInfo));
        if (verbose) {
            this.dumpHandlers();
        }
    }

    public void insert(int n, HandlerStats handlerStats) {
        this.handlerStats.add(n, handlerStats);
    }

    @Override
    public int lenientInsert(String string, HandlerInfo handlerInfo, List<String> list, List<String> list2) throws HandlerException {
        return this.internalInsert(string, handlerInfo, list, list2, true);
    }

    @Override
    public int insert(String string, HandlerInfo handlerInfo, List<String> list, List<String> list2) throws HandlerException {
        return this.internalInsert(string, handlerInfo, list, list2, false);
    }

    private int internalInsert(String string, HandlerInfo handlerInfo, List<String> list, List<String> list2, boolean bl) throws HandlerException {
        int n = -1;
        if (verbose) {
            String string2 = this.dumpList(list2);
            String string3 = this.dumpList(list);
            Verbose.log("In HandlerList " + super.toString() + " adding handler: " + string + " class=" + handlerInfo.getHandlerClass() + " before (" + string2 + ") and after (" + string3 + ") of " + this.handlers.size() + " total handlers");
        }
        for (int i = 0; i < this.handlerInfos.size(); ++i) {
            if (!this.checkAfterConstraint(i, list, bl) || !this.checkBeforeConstraint(i, list2, bl)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new HandlerException(this.getMessage(list, list2));
        }
        this.insert(string, n, handlerInfo);
        return n;
    }

    private String dumpList(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private void dumpHandlers() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.handlerInfos.iterator();
        while (iterator.hasNext()) {
            NamedHandlerInfo namedHandlerInfo = (NamedHandlerInfo)iterator.next();
            stringBuffer.append(namedHandlerInfo.name);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        Verbose.log("In HandlerList " + super.toString() + " current is (" + stringBuffer.toString() + ")");
    }

    private String getMessage(List<String> list, List<String> list2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Failed to insert handler after [");
        stringBuffer.append(list);
        stringBuffer.append("] and before [");
        stringBuffer.append(list2);
        stringBuffer.append("] into handler chain [");
        for (NamedHandlerInfo namedHandlerInfo : this.handlerInfos) {
            stringBuffer.append(namedHandlerInfo.name);
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private boolean checkBeforeConstraint(int n, List<String> list, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(list);
        for (int i = n; i < this.handlerInfos.size(); ++i) {
            NamedHandlerInfo namedHandlerInfo = (NamedHandlerInfo)this.handlerInfos.get(i);
            arrayList.remove(namedHandlerInfo.name);
        }
        if (arrayList.isEmpty()) {
            return true;
        }
        return bl && this.handlerNotPresent(arrayList);
    }

    private boolean handlerNotPresent(ArrayList<String> arrayList) {
        for (int i = 0; i < this.handlerInfos.size(); ++i) {
            NamedHandlerInfo namedHandlerInfo = (NamedHandlerInfo)this.handlerInfos.get(i);
            if (!arrayList.contains(namedHandlerInfo.name)) continue;
            return false;
        }
        return true;
    }

    private boolean checkAfterConstraint(int n, List<String> list, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(list);
        for (int i = 0; i < n; ++i) {
            NamedHandlerInfo namedHandlerInfo = (NamedHandlerInfo)this.handlerInfos.get(i);
            arrayList.remove(namedHandlerInfo.name);
        }
        if (arrayList.isEmpty()) {
            return true;
        }
        return bl && this.handlerNotPresent(arrayList);
    }

    @Override
    public void remove(int n) {
        Handler handler = this.get(n);
        handler.destroy();
        this.handlers.remove(n);
        this.handlerInfos.remove(n);
        if (verbose) {
            this.dumpHandlers();
        }
    }

    @Override
    public boolean remove(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name == null");
        }
        if (verbose) {
            Verbose.log("In HandlerList " + super.toString() + " removing handler: " + string);
        }
        int n = 0;
        for (NamedHandlerInfo namedHandlerInfo : this.handlerInfos) {
            if (string.equals(namedHandlerInfo.name)) {
                this.remove(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean contains(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name == null");
        }
        for (NamedHandlerInfo namedHandlerInfo : this.handlerInfos) {
            if (!string.equals(namedHandlerInfo.name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getHandlerNames() {
        String[] stringArray = new String[this.handlerInfos.size()];
        int n = 0;
        for (NamedHandlerInfo namedHandlerInfo : this.handlerInfos) {
            stringArray[n] = namedHandlerInfo.name;
            ++n;
        }
        return stringArray;
    }

    public void destroy() {
        for (int i = this.size() - 1; i > -1; --i) {
            Handler handler = this.get(i);
            try {
                handler.destroy();
                continue;
            }
            catch (Throwable throwable) {
                assert (false) : "Failed to destroy handler:" + throwable;
                if (!verbose) continue;
                Verbose.log((Object)"Failed to destroy handler", throwable);
            }
        }
        this.handlerInfos.clear();
        this.handlers.clear();
    }

    public void init() throws HandlerException {
        assert (this.handlerInfos != null);
        assert (this.handlerInfos.size() > 0);
        if (this.initialized) {
            return;
        }
        for (NamedHandlerInfo namedHandlerInfo : this.handlerInfos) {
            try {
                Handler handler = this.newHandler(namedHandlerInfo.info);
                this.handlers.add(handler);
            }
            catch (Throwable throwable) {
                this.destroy();
                throw new HandlerException("Failed to init handlers", throwable);
            }
        }
        this.initialized = true;
    }

    private Handler newHandler(HandlerInfo handlerInfo) throws HandlerException {
        Class clazz = handlerInfo.getHandlerClass();
        try {
            Handler handler = (Handler)clazz.newInstance();
            handler.init(handlerInfo);
            return handler;
        }
        catch (InstantiationException instantiationException) {
            throw new HandlerException("Exception in handler:" + clazz.getName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeArray("handlers", this.handlers.iterator());
        toStringWriter.writeArray("handlerInfos", this.handlerInfos.iterator());
        toStringWriter.end();
    }

    private static class NamedHandlerInfo {
        public HandlerInfo info;
        public String name;

        public NamedHandlerInfo(String string, HandlerInfo handlerInfo) {
            this.name = string;
            this.info = handlerInfo;
        }

        public NamedHandlerInfo(NamedHandlerInfo namedHandlerInfo) {
            this.name = namedHandlerInfo.name;
            this.info = new HandlerInfo();
            this.info.setHandlerClass(namedHandlerInfo.info.getHandlerClass());
            this.info.setHeaders(namedHandlerInfo.info.getHeaders());
            Map map = namedHandlerInfo.info.getHandlerConfig();
            HashMap hashMap = null;
            if (map != null) {
                hashMap = new HashMap();
                for (Map.Entry entry : map.entrySet()) {
                    hashMap.put(entry.getKey(), entry.getValue());
                }
            }
            this.info.setHandlerConfig(hashMap);
        }

        public String toString() {
            return this.name + " = " + this.info;
        }
    }
}

