/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.handler;

import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.handler.HandlerListImpl;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;

public class JaxrpcHandlerChain {
    private HandlerListImpl handlers;
    private boolean serverSide;
    private boolean hasRuntimeException = false;
    private int index;

    public JaxrpcHandlerChain(HandlerListImpl handlerListImpl) {
        this.handlers = handlerListImpl;
    }

    public static JaxrpcHandlerChain cloneChain(JaxrpcHandlerChain jaxrpcHandlerChain) {
        JaxrpcHandlerChain jaxrpcHandlerChain2 = new JaxrpcHandlerChain(jaxrpcHandlerChain.handlers);
        jaxrpcHandlerChain2.setServerSide(jaxrpcHandlerChain.isServerSide());
        return jaxrpcHandlerChain2;
    }

    public static JaxrpcHandlerChain deepCloneChain(JaxrpcHandlerChain jaxrpcHandlerChain) {
        HandlerListImpl handlerListImpl = new HandlerListImpl(jaxrpcHandlerChain.handlers);
        JaxrpcHandlerChain jaxrpcHandlerChain2 = new JaxrpcHandlerChain(handlerListImpl);
        jaxrpcHandlerChain2.setServerSide(jaxrpcHandlerChain.isServerSide());
        return jaxrpcHandlerChain2;
    }

    public void init() throws HandlerException {
        this.handlers.init();
    }

    public void setServerSide(boolean bl) {
        this.serverSide = bl;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public boolean handleRequest(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        this.index = 0;
        while (this.index < this.handlers.size()) {
            try {
                if (!this.handlers.get(this.index).handleRequest((MessageContext)wlMessageContext)) {
                    return false;
                }
            }
            catch (ClassCastException classCastException) {
                Verbose.log("Exception: " + classCastException.getMessage());
                return false;
            }
            catch (SOAPFaultException sOAPFaultException) {
                wlMessageContext.setFault(sOAPFaultException);
                return false;
            }
            catch (Throwable throwable) {
                wlMessageContext.setFault(throwable);
                this.hasRuntimeException = true;
                return false;
            }
            ++this.index;
        }
        --this.index;
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        if (this.hasRuntimeException) {
            return true;
        }
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        while (this.index >= 0) {
            block9: {
                if (wlMessageContext.hasFault()) {
                    try {
                        if (!this.handlers.get(this.index).handleFault((MessageContext)wlMessageContext)) {
                            return false;
                        }
                        break block9;
                    }
                    catch (Throwable throwable) {
                        this.hasRuntimeException = true;
                        return false;
                    }
                }
                try {
                    if (!this.handlers.get(this.index).handleResponse(messageContext)) {
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    this.hasRuntimeException = true;
                    wlMessageContext.setFault(throwable);
                    return false;
                }
            }
            --this.index;
        }
        return true;
    }

    public boolean hasRuntimeException() {
        return this.hasRuntimeException;
    }

    public void destroy() {
        this.handlers.destroy();
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("handlers", this.handlers);
        toStringWriter.end();
    }
}

