/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.handler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import weblogic.wsee.handler.DDProcessingException;
import weblogic.wsee.handler.NSAttribute;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.ElementFilter;
import weblogic.xml.stream.Location;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.Name;
import weblogic.xml.stream.util.TypeFilter;
import weblogic.xml.xmlnode.XMLNode;
import weblogic.xml.xmlnode.XMLNodeSet;

public class ParsingHelper {
    private XMLInputStream stream;
    private static final boolean debug = false;
    private static final String DD_NS = "http://www.bea.com/servers/wls70";

    public ParsingHelper(InputStream inputStream) throws XMLStreamException {
        TypeFilter typeFilter = new TypeFilter(22);
        this.stream = XMLInputStreamFactory.newInstance().newInputStream(inputStream, (ElementFilter)typeFilter);
        this.stream.skip(2);
    }

    public ParsingHelper(XMLInputStream xMLInputStream) throws XMLStreamException {
        this.stream = xMLInputStream;
        this.stream.skip(2);
    }

    public XMLEvent peekStartElement(String string) throws XMLStreamException, DDProcessingException {
        XMLEvent xMLEvent = this.stream.peek();
        if (xMLEvent.getType() == 2 && xMLEvent.getName().getLocalName().equals(string)) {
            return xMLEvent;
        }
        return null;
    }

    public XMLEvent peekStartElement() throws XMLStreamException, DDProcessingException {
        XMLEvent xMLEvent = this.stream.peek();
        if (xMLEvent.getType() == 2) {
            return xMLEvent;
        }
        return null;
    }

    public XMLEvent matchStartElement(String string) throws XMLStreamException, DDProcessingException {
        XMLEvent xMLEvent = this.stream.peek();
        if (xMLEvent.getType() != 2) {
            throw new DDProcessingException("Expected start element <" + string + ">, but got " + xMLEvent.getTypeAsString() + " instead", xMLEvent.getLocation());
        }
        String string2 = xMLEvent.getName().getLocalName();
        if (!string.equals(string2)) {
            throw new DDProcessingException("Expected element <" + string + ">, but got <" + string2 + "> instead", xMLEvent.getLocation());
        }
        return this.stream.next();
    }

    public XMLEvent matchStartElement(String[] stringArray) throws XMLStreamException, DDProcessingException {
        XMLEvent xMLEvent = this.matchOptionalStartElement(stringArray);
        if (xMLEvent == null) {
            StringBuffer stringBuffer = new StringBuffer("Expected a start element matching any of ");
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuffer.append("<").append(stringArray[i]).append(">,");
            }
            stringBuffer.append(" or <").append(stringArray[stringArray.length - 1]).append(">");
            stringBuffer.append(" but got ");
            stringBuffer.append(this.stream.peek().toString());
            stringBuffer.append(" instead");
            throw new DDProcessingException(stringBuffer.toString(), this.stream.peek().getLocation());
        }
        return xMLEvent;
    }

    public XMLEvent matchOptionalStartElement(String[] stringArray) throws XMLStreamException, DDProcessingException {
        XMLEvent xMLEvent = null;
        for (int i = 0; i < stringArray.length && (xMLEvent = this.matchOptionalStartElement(stringArray[i])) == null; ++i) {
        }
        return xMLEvent;
    }

    public XMLEvent matchOptionalStartElement(String string) throws XMLStreamException {
        XMLEvent xMLEvent = this.stream.peek();
        if (xMLEvent.getType() == 2 && xMLEvent.getName().getLocalName().equals(string)) {
            return this.stream.next();
        }
        return null;
    }

    public XMLEvent matchEndElement(String string) throws XMLStreamException, DDProcessingException {
        XMLEvent xMLEvent = this.stream.peek();
        if (xMLEvent.getType() != 4) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Expected end element </" + string + ">, but got ");
            stringBuffer.append(xMLEvent.getTypeAsString());
            if (xMLEvent.getName() != null) {
                stringBuffer.append("(" + xMLEvent.getName().getQualifiedName() + ")");
            }
            stringBuffer.append(" instead.");
            throw new DDProcessingException(stringBuffer.toString(), xMLEvent.getLocation());
        }
        return this.stream.next();
    }

    public XMLEvent matchDocumentEnd() throws XMLStreamException, DDProcessingException {
        XMLEvent xMLEvent = this.stream.peek();
        if (xMLEvent.getType() != 512 && xMLEvent.getType() != 128) {
            throw new DDProcessingException("Expected end of document, but got " + xMLEvent.getTypeAsString() + " instead", xMLEvent.getLocation());
        }
        return this.stream.next();
    }

    public Location getLocation() throws XMLStreamException {
        XMLEvent xMLEvent = this.stream.peek();
        if (xMLEvent == null) {
            return null;
        }
        return xMLEvent.getLocation();
    }

    public XMLNode forkSubtree() throws XMLStreamException {
        XMLNode xMLNode = new XMLNode();
        XMLInputStream xMLInputStream = this.stream.getSubStream();
        this.stream.skipElement();
        try {
            xMLNode.read(xMLInputStream);
            return xMLNode;
        }
        catch (IOException iOException) {
            throw new XMLStreamException((Throwable)iOException);
        }
    }

    public XMLNodeSet forkSubtrees() throws XMLStreamException {
        XMLNodeSet xMLNodeSet = new XMLNodeSet();
        XMLEvent xMLEvent = this.stream.peek();
        if (xMLEvent.getType() != 2) {
            throw new XMLStreamException("Expected a start element");
        }
        XMLEvent xMLEvent2 = xMLEvent;
        while (xMLEvent2.getName().equals(xMLEvent.getName())) {
            try {
                XMLNode xMLNode = new XMLNode();
                xMLNode.read(this.stream);
                xMLNodeSet.addXMLNode(xMLNode);
            }
            catch (IOException iOException) {
                throw new XMLStreamException((Throwable)iOException);
            }
            xMLEvent2 = this.stream.peek();
            if (xMLEvent2.getName() != null) continue;
            break;
        }
        return xMLNodeSet;
    }

    public static NSAttribute getRequiredAttribute(StartElement startElement, String string) throws XMLStreamException, DDProcessingException {
        Attribute attribute = startElement.getAttributeByName((XMLName)new Name(string));
        if (attribute == null) {
            throw new DDProcessingException("Could not find required attribute \"" + string + "\" for element <" + startElement.getName().getLocalName() + ">", startElement.getLocation());
        }
        return new NSAttribute(startElement, attribute);
    }

    public static NSAttribute getOptionalAttribute(StartElement startElement, String string) throws XMLStreamException, DDProcessingException {
        Attribute attribute = startElement.getAttributeByName((XMLName)new Name(string));
        if (attribute == null) {
            return null;
        }
        return new NSAttribute(startElement, attribute);
    }

    public static void checkAttributes(StartElement startElement, String[] stringArray) throws DDProcessingException {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        AttributeIterator attributeIterator = startElement.getAttributes();
        while (attributeIterator.hasNext()) {
            XMLName xMLName = attributeIterator.next().getName();
            if (xMLName.getNamespaceUri() != null && !xMLName.getNamespaceUri().equals(DD_NS) || hashSet.contains(xMLName.getLocalName())) continue;
            throw new DDProcessingException("Unrecognized attribute " + xMLName.getLocalName(), startElement.getLocation());
        }
    }

    private static void dumpEvents(XMLInputStream xMLInputStream) throws XMLStreamException {
        while (xMLInputStream.hasNext()) {
            XMLEvent xMLEvent = xMLInputStream.next();
            System.out.print("EVENT: " + xMLEvent.getTypeAsString() + " [");
            System.out.print(xMLEvent);
            System.out.println("]");
        }
    }
}

